/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.requestfactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.grouping.distributed.ShardRequestFactory;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;

public class StoredFieldsShardRequestFactory
implements ShardRequestFactory {
    @Override
    public ShardRequest[] constructRequest(ResponseBuilder rb) {
        HashMap<String, Set<ShardDoc>> shardMap = new HashMap<String, Set<ShardDoc>>();
        for (TopGroups<BytesRef> topGroups : rb.mergedTopGroups.values()) {
            for (GroupDocs group : topGroups.groups) {
                this.mapShardToDocs(shardMap, group.scoreDocs);
            }
        }
        for (QueryCommandResult queryCommandResult : rb.mergedQueryCommandResults.values()) {
            this.mapShardToDocs(shardMap, queryCommandResult.getTopDocs().scoreDocs);
        }
        ShardRequest[] shardRequests = new ShardRequest[shardMap.size()];
        SchemaField uniqueField = rb.req.getSchema().getUniqueKeyField();
        int i = 0;
        for (Collection collection : shardMap.values()) {
            ShardRequest sreq = new ShardRequest();
            sreq.purpose = 64;
            sreq.shards = new String[]{((ShardDoc)collection.iterator().next()).shard};
            sreq.params = new ModifiableSolrParams();
            sreq.params.add(rb.req.getParams());
            sreq.params.remove("group");
            sreq.params.remove("sort");
            sreq.params.remove("fsv");
            String fl = sreq.params.get("fl");
            if (fl != null && (fl = fl.trim()).length() != 0 && !"score".equals(fl) && !"*".equals(fl)) {
                sreq.params.set("fl", fl + ',' + uniqueField.getName());
            }
            ArrayList<String> ids = new ArrayList<String>(collection.size());
            for (ShardDoc shardDoc : collection) {
                ids.add(shardDoc.id.toString());
            }
            sreq.params.add("ids", StrUtils.join(ids, ','));
            shardRequests[i++] = sreq;
        }
        return shardRequests;
    }

    private void mapShardToDocs(HashMap<String, Set<ShardDoc>> shardMap, ScoreDoc[] scoreDocs) {
        for (ScoreDoc scoreDoc : scoreDocs) {
            ShardDoc solrDoc = (ShardDoc)scoreDoc;
            Set<ShardDoc> shardDocs = shardMap.get(solrDoc.shard);
            if (shardDocs == null) {
                shardDocs = new HashSet<ShardDoc>();
                shardMap.put(solrDoc.shard, shardDocs);
            }
            shardDocs.add(solrDoc);
        }
    }
}

