/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import com.carrotsearch.hppc.IntFloatOpenHashMap;
import com.carrotsearch.hppc.IntIntOpenHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryRescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.MergeStrategy;
import org.apache.solr.handler.component.QueryElevationComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.RankQuery;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class ReRankQParserPlugin
extends QParserPlugin {
    public static final String NAME = "rerank";
    private static Query defaultQuery = new MatchAllDocsQuery();

    @Override
    public void init(NamedList args) {
    }

    @Override
    public QParser createParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new ReRankQParser(query, localParams, params, req);
    }

    static /* synthetic */ Query access$000() {
        return defaultQuery;
    }

    public class BoostedComp
    implements Comparator {
        IntFloatOpenHashMap boostedMap;

        public BoostedComp(IntIntOpenHashMap boostedDocs, ScoreDoc[] scoreDocs, float maxScore) {
            this.boostedMap = new IntFloatOpenHashMap(boostedDocs.size() * 2);
            for (int i = 0; i < scoreDocs.length && boostedDocs.containsKey(scoreDocs[i].doc); ++i) {
                this.boostedMap.put(scoreDocs[i].doc, maxScore + (float)boostedDocs.lget());
            }
        }

        public int compare(Object o1, Object o2) {
            ScoreDoc doc1 = (ScoreDoc)o1;
            ScoreDoc doc2 = (ScoreDoc)o2;
            float score1 = doc1.score;
            float score2 = doc2.score;
            if (this.boostedMap.containsKey(doc1.doc)) {
                score1 = this.boostedMap.lget();
            }
            if (this.boostedMap.containsKey(doc2.doc)) {
                score2 = this.boostedMap.lget();
            }
            if (score1 > score2) {
                return -1;
            }
            if (score1 < score2) {
                return 1;
            }
            return 0;
        }
    }

    private class ReRankCollector
    extends TopDocsCollector {
        private Query reRankQuery;
        private TopDocsCollector mainCollector;
        private IndexSearcher searcher;
        private int reRankDocs;
        private int length;
        private double reRankWeight;
        private Map<BytesRef, Integer> boostedPriority;

        public ReRankCollector(int reRankDocs, int length, Query reRankQuery, double reRankWeight, SolrIndexSearcher.QueryCommand cmd, IndexSearcher searcher, Map<BytesRef, Integer> boostedPriority) throws IOException {
            super(null);
            this.reRankQuery = reRankQuery;
            this.reRankDocs = reRankDocs;
            this.length = length;
            this.boostedPriority = boostedPriority;
            Sort sort = cmd.getSort();
            if (sort == null) {
                this.mainCollector = TopScoreDocCollector.create(Math.max(this.reRankDocs, length), true);
            } else {
                sort = sort.rewrite(searcher);
                this.mainCollector = TopFieldCollector.create(sort, Math.max(this.reRankDocs, length), false, true, true, true);
            }
            this.searcher = searcher;
            this.reRankWeight = reRankWeight;
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        @Override
        public void collect(int doc) throws IOException {
            this.mainCollector.collect(doc);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.mainCollector.setScorer(scorer);
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.mainCollector.setNextReader(context);
        }

        @Override
        public int getTotalHits() {
            return this.mainCollector.getTotalHits();
        }

        @Override
        public TopDocs topDocs(int start, int howMany) {
            try {
                TopDocs mainDocs = this.mainCollector.topDocs(0, Math.max(this.reRankDocs, this.length));
                if (mainDocs.totalHits == 0 || mainDocs.scoreDocs.length == 0) {
                    return mainDocs;
                }
                if (this.boostedPriority != null) {
                    SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
                    Map<Object, Object> requestContext = null;
                    if (info != null) {
                        requestContext = info.getReq().getContext();
                    }
                    IntIntOpenHashMap boostedDocs = QueryElevationComponent.getBoostDocs((SolrIndexSearcher)this.searcher, this.boostedPriority, requestContext);
                    ScoreDoc[] mainScoreDocs = mainDocs.scoreDocs;
                    ScoreDoc[] reRankScoreDocs = new ScoreDoc[Math.min(mainScoreDocs.length, this.reRankDocs)];
                    System.arraycopy(mainScoreDocs, 0, reRankScoreDocs, 0, reRankScoreDocs.length);
                    mainDocs.scoreDocs = reRankScoreDocs;
                    TopDocs rescoredDocs = new QueryRescorer(this.reRankQuery){

                        @Override
                        protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                            float score = firstPassScore;
                            if (secondPassMatches) {
                                score = (float)((double)score + ReRankCollector.this.reRankWeight * (double)secondPassScore);
                            }
                            return score;
                        }
                    }.rescore(this.searcher, mainDocs, mainDocs.scoreDocs.length);
                    Arrays.sort(rescoredDocs.scoreDocs, new BoostedComp(boostedDocs, mainDocs.scoreDocs, rescoredDocs.getMaxScore()));
                    howMany = Math.min(howMany, mainScoreDocs.length);
                    if (howMany == rescoredDocs.scoreDocs.length) {
                        return rescoredDocs;
                    }
                    if (howMany > rescoredDocs.scoreDocs.length) {
                        ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                        System.arraycopy(mainScoreDocs, 0, scoreDocs, 0, scoreDocs.length);
                        System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, rescoredDocs.scoreDocs.length);
                        rescoredDocs.scoreDocs = scoreDocs;
                        return rescoredDocs;
                    }
                    ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                    System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, howMany);
                    rescoredDocs.scoreDocs = scoreDocs;
                    return rescoredDocs;
                }
                ScoreDoc[] mainScoreDocs = mainDocs.scoreDocs;
                ScoreDoc[] reRankScoreDocs = new ScoreDoc[Math.min(mainScoreDocs.length, this.reRankDocs)];
                System.arraycopy(mainScoreDocs, 0, reRankScoreDocs, 0, reRankScoreDocs.length);
                mainDocs.scoreDocs = reRankScoreDocs;
                TopDocs rescoredDocs = new QueryRescorer(this.reRankQuery){

                    @Override
                    protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                        float score = firstPassScore;
                        if (secondPassMatches) {
                            score = (float)((double)score + ReRankCollector.this.reRankWeight * (double)secondPassScore);
                        }
                        return score;
                    }
                }.rescore(this.searcher, mainDocs, mainDocs.scoreDocs.length);
                howMany = Math.min(howMany, mainScoreDocs.length);
                if (howMany == rescoredDocs.scoreDocs.length) {
                    return rescoredDocs;
                }
                if (howMany > rescoredDocs.scoreDocs.length) {
                    ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                    System.arraycopy(mainScoreDocs, 0, scoreDocs, 0, scoreDocs.length);
                    System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, rescoredDocs.scoreDocs.length);
                    rescoredDocs.scoreDocs = scoreDocs;
                    return rescoredDocs;
                }
                ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, howMany);
                rescoredDocs.scoreDocs = scoreDocs;
                return rescoredDocs;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        }
    }

    private class ReRankWeight
    extends Weight {
        private Query reRankQuery;
        private IndexSearcher searcher;
        private Weight mainWeight;
        private double reRankWeight;

        public ReRankWeight(Query mainQuery, Query reRankQuery, double reRankWeight, IndexSearcher searcher) throws IOException {
            this.reRankQuery = reRankQuery;
            this.searcher = searcher;
            this.reRankWeight = reRankWeight;
            this.mainWeight = mainQuery.createWeight(searcher);
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return this.mainWeight.getValueForNormalization();
        }

        @Override
        public Scorer scorer(AtomicReaderContext context, Bits bits) throws IOException {
            return this.mainWeight.scorer(context, bits);
        }

        @Override
        public Query getQuery() {
            return this.mainWeight.getQuery();
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            this.mainWeight.normalize(norm, topLevelBoost);
        }

        @Override
        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            Explanation mainExplain = this.mainWeight.explain(context, doc);
            return new QueryRescorer(this.reRankQuery){

                @Override
                protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                    float score = firstPassScore;
                    if (secondPassMatches) {
                        score = (float)((double)score + ReRankWeight.this.reRankWeight * (double)secondPassScore);
                    }
                    return score;
                }
            }.explain(this.searcher, mainExplain, context.docBase + doc);
        }
    }

    private class ReRankQuery
    extends RankQuery {
        private Query mainQuery = ReRankQParserPlugin.access$000();
        private Query reRankQuery;
        private int reRankDocs;
        private int length;
        private double reRankWeight;
        private Map<BytesRef, Integer> boostedPriority;

        @Override
        public int hashCode() {
            return this.mainQuery.hashCode() + this.reRankQuery.hashCode() + (int)this.reRankWeight + this.reRankDocs + (int)this.getBoost();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ReRankQuery) {
                ReRankQuery rrq = (ReRankQuery)o;
                return this.mainQuery.equals(rrq.mainQuery) && this.reRankQuery.equals(rrq.reRankQuery) && this.reRankWeight == rrq.reRankWeight && this.reRankDocs == rrq.reRankDocs && this.getBoost() == rrq.getBoost();
            }
            return false;
        }

        public ReRankQuery(Query reRankQuery, int reRankDocs, double reRankWeight, int length) {
            this.reRankQuery = reRankQuery;
            this.reRankDocs = reRankDocs;
            this.reRankWeight = reRankWeight;
            this.length = length;
        }

        @Override
        public RankQuery wrap(Query _mainQuery) {
            if (_mainQuery != null) {
                this.mainQuery = _mainQuery;
            }
            return this;
        }

        @Override
        public MergeStrategy getMergeStrategy() {
            return null;
        }

        @Override
        public TopDocsCollector getTopDocsCollector(int len, SolrIndexSearcher.QueryCommand cmd, IndexSearcher searcher) throws IOException {
            SolrRequestInfo info;
            if (this.boostedPriority == null && (info = SolrRequestInfo.getRequestInfo()) != null) {
                Map<Object, Object> context = info.getReq().getContext();
                this.boostedPriority = (Map)context.get("BOOSTED_PRIORITY");
            }
            return new ReRankCollector(this.reRankDocs, this.length, this.reRankQuery, this.reRankWeight, cmd, searcher, this.boostedPriority);
        }

        @Override
        public String toString(String s) {
            return "{!rerank mainQuery='" + this.mainQuery.toString() + "' reRankQuery='" + this.reRankQuery.toString() + "' reRankDocs=" + this.reRankDocs + " reRankWeigh=" + this.reRankWeight + "}";
        }

        @Override
        public String toString() {
            return this.toString(null);
        }

        @Override
        public Query rewrite(IndexReader reader) throws IOException {
            return this.wrap(this.mainQuery.rewrite(reader));
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.mainQuery.extractTerms(terms);
        }

        @Override
        public Weight createWeight(IndexSearcher searcher) throws IOException {
            return new ReRankWeight(this.mainQuery, this.reRankQuery, this.reRankWeight, searcher);
        }
    }

    private class ReRankQParser
    extends QParser {
        public ReRankQParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(query, localParams, params, req);
        }

        @Override
        public Query parse() throws SyntaxError {
            String reRankQueryString = this.localParams.get("reRankQuery");
            QParser reRankParser = QParser.getParser(reRankQueryString, null, this.req);
            Query reRankQuery = reRankParser.parse();
            int reRankDocs = this.localParams.getInt("reRankDocs", 200);
            reRankDocs = Math.max(1, reRankDocs);
            double reRankWeight = this.localParams.getDouble("reRankWeight", 2.0);
            int start = this.params.getInt("start", 0);
            int rows = this.params.getInt("rows", 10);
            int length = start + rows;
            return new ReRankQuery(reRankQuery, reRankDocs, reRankWeight, length);
        }
    }
}

