/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SortSpec;

public final class CursorMark {
    private final SortSpec sortSpec;
    private List<Object> values = null;
    private final JavaBinCodec codec = new JavaBinCodec();

    public CursorMark(IndexSchema schema, SortSpec sortSpec) {
        SchemaField uniqueKey = schema.getUniqueKeyField();
        if (null == uniqueKey) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cursor functionality is not available unless the IndexSchema defines a uniqueKey field");
        }
        Sort sort = sortSpec.getSort();
        if (null == sort) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cursor functionality requires a sort containing a uniqueKey field tie breaker");
        }
        if (!sortSpec.getSchemaFields().contains(uniqueKey)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cursor functionality requires a sort containing a uniqueKey field tie breaker");
        }
        if (0 != sortSpec.getOffset()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cursor functionality requires start=0");
        }
        for (SortField sf : sort.getSort()) {
            if (!sf.getType().equals((Object)SortField.Type.DOC)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cursor functionality can not be used with internal doc ordering sort: _docid_");
        }
        if (sort.getSort().length != sortSpec.getSchemaFields().size()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cursor SortSpec failure: sort length != SchemaFields: " + sort.getSort().length + " != " + sortSpec.getSchemaFields().size());
        }
        this.sortSpec = sortSpec;
        this.values = null;
    }

    private CursorMark(CursorMark previous) {
        this.sortSpec = previous.sortSpec;
        this.values = null;
    }

    public CursorMark createNext(List<Object> nextSortValues) {
        CursorMark next = new CursorMark(this);
        next.setSortValues(nextSortValues);
        return next;
    }

    public void setSortValues(List<Object> input) {
        if (null == input) {
            this.values = null;
        } else {
            assert (input.size() == this.sortSpec.getSort().getSort().length);
            this.values = new ArrayList<Object>(input);
        }
    }

    public List<Object> getSortValues() {
        return null == this.values ? null : new ArrayList<Object>(this.values);
    }

    public SortSpec getSortSpec() {
        return this.sortSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseSerializedTotem(String serialized) {
        if ("*".equals(serialized)) {
            this.values = null;
            return;
        }
        SortField[] sortFields = this.sortSpec.getSort().getSort();
        List<SchemaField> schemaFields = this.sortSpec.getSchemaFields();
        List pieces = null;
        try {
            byte[] rawData = Base64.base64ToByteArray(serialized);
            try (ByteArrayInputStream in = new ByteArrayInputStream(rawData);){
                pieces = (List)this.codec.unmarshal(in);
                boolean b = false;
                for (Object o : pieces) {
                    if (!(o instanceof BytesRefBuilder) && !(o instanceof BytesRef) && !(o instanceof String)) continue;
                    b = true;
                    break;
                }
                if (b) {
                    in.reset();
                    pieces = (List)this.codec.unmarshal(in);
                }
            }
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to parse 'cursorMark' after totem: value must either be '*' or the 'nextCursorMark' returned by a previous search: " + serialized, (Throwable)ex);
        }
        assert (null != pieces) : "pieces wasn't parsed?";
        if (sortFields.length != pieces.size()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "cursorMark does not work with current sort (wrong size): " + serialized);
        }
        this.values = new ArrayList<Object>(sortFields.length);
        BytesRef tmpBytes = new BytesRef();
        for (int i = 0; i < sortFields.length; ++i) {
            SortField curSort = sortFields[i];
            SchemaField curField = schemaFields.get(i);
            Object rawValue = pieces.get(i);
            if (null != curField) {
                FieldType curType = curField.getType();
                rawValue = curType.unmarshalSortValue(rawValue);
            }
            this.values.add(rawValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerializedTotem() {
        String string;
        if (null == this.values) {
            return "*";
        }
        List<SchemaField> schemaFields = this.sortSpec.getSchemaFields();
        ArrayList<Object> marshalledValues = new ArrayList<Object>(this.values.size() + 1);
        for (int i = 0; i < schemaFields.size(); ++i) {
            SchemaField fld = schemaFields.get(i);
            Object safeValue = this.values.get(i);
            if (null != fld) {
                FieldType type = fld.getType();
                safeValue = type.marshalSortValue(safeValue);
            }
            marshalledValues.add(safeValue);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        try {
            this.codec.marshal(marshalledValues, out);
            byte[] rawData = out.toByteArray();
            string = Base64.byteArrayToBase64(rawData, 0, rawData.length);
        }
        catch (Throwable throwable) {
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to format search after totem", (Throwable)ex);
            }
        }
        out.close();
        return string;
    }

    public FieldDoc getSearchAfterFieldDoc() {
        if (null == this.values) {
            return null;
        }
        return new FieldDoc(Integer.MAX_VALUE, 0.0f, this.values.toArray());
    }
}

