/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.DateValueFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.QParser;

public class TrieDateField
extends DateField
implements DateValueFieldType {
    final TrieField wrappedField = new TrieField(){
        {
            this.type = TrieField.TrieTypes.DATE;
        }
    };

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        this.wrappedField.init(schema, args);
    }

    @Override
    public Date toObject(IndexableField f) {
        return (Date)this.wrappedField.toObject(f);
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return this.wrappedField.toObject(sf, term);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        return this.wrappedField.getSortField(field, top);
    }

    @Override
    public Object marshalSortValue(Object value) {
        return value;
    }

    @Override
    public Object unmarshalSortValue(Object value) {
        return value;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        return this.wrappedField.getValueSource(field, parser);
    }

    public int getPrecisionStep() {
        return this.wrappedField.getPrecisionStep();
    }

    @Override
    public FieldType.NumericType getNumericType() {
        return this.wrappedField.getNumericType();
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        this.wrappedField.write(writer, name, f);
    }

    @Override
    public boolean isTokenized() {
        return this.wrappedField.isTokenized();
    }

    @Override
    public boolean multiValuedFieldCache() {
        return this.wrappedField.multiValuedFieldCache();
    }

    @Override
    public String storedToReadable(IndexableField f) {
        return this.wrappedField.storedToReadable(f);
    }

    @Override
    public String readableToIndexed(String val) {
        return this.wrappedField.readableToIndexed(val);
    }

    @Override
    public String toInternal(String val) {
        return this.wrappedField.toInternal(val);
    }

    @Override
    public String toExternal(IndexableField f) {
        return this.wrappedField.toExternal(f);
    }

    @Override
    public String indexedToReadable(String _indexedForm) {
        return this.wrappedField.indexedToReadable(_indexedForm);
    }

    @Override
    public CharsRef indexedToReadable(BytesRef input, CharsRef charsRef) {
        return this.wrappedField.indexedToReadable(input, charsRef);
    }

    @Override
    public String storedToIndexed(IndexableField f) {
        return this.wrappedField.storedToIndexed(f);
    }

    @Override
    public IndexableField createField(SchemaField field, Object value, float boost) {
        return this.wrappedField.createField(field, value, boost);
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object value, float boost) {
        return this.wrappedField.createFields(field, value, boost);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        return this.wrappedField.getRangeQuery(parser, field, min, max, minInclusive, maxInclusive);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField sf, Date min, Date max, boolean minInclusive, boolean maxInclusive) {
        return NumericRangeQuery.newLongRange(sf.getName(), this.wrappedField.precisionStep, min == null ? null : Long.valueOf(min.getTime()), max == null ? null : Long.valueOf(max.getTime()), minInclusive, maxInclusive);
    }

    @Override
    public void checkSchemaField(SchemaField field) {
        this.wrappedField.checkSchemaField(field);
    }
}

