/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.File;
import java.io.InputStream;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.ClassicIndexSchemaFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.SystemIdResolver;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public abstract class IndexSchemaFactory
implements NamedListInitializedPlugin {
    private static final Logger log = LoggerFactory.getLogger(IndexSchemaFactory.class);

    public IndexSchema create(String resourceName, SolrConfig config) {
        SolrResourceLoader loader = config.getResourceLoader();
        InputStream schemaInputStream = null;
        if (null == resourceName) {
            resourceName = "schema.xml";
        }
        try {
            schemaInputStream = loader.openSchema(resourceName);
        }
        catch (Exception e) {
            String msg = "Error loading schema resource " + resourceName;
            log.error(msg, e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)e);
        }
        InputSource inputSource = new InputSource(schemaInputStream);
        inputSource.setSystemId(SystemIdResolver.createSystemIdFromResourceName(resourceName));
        IndexSchema schema = new IndexSchema(config, resourceName, inputSource);
        return schema;
    }

    public static IndexSchema buildIndexSchema(String resourceName, SolrConfig config) {
        IndexSchemaFactory factory;
        PluginInfo info = config.getPluginInfo(IndexSchemaFactory.class.getName());
        if (null != info) {
            factory = config.getResourceLoader().newInstance(info.className, IndexSchemaFactory.class);
            factory.init(info.initArgs);
        } else {
            factory = new ClassicIndexSchemaFactory();
        }
        IndexSchema schema = factory.create(resourceName, config);
        return schema;
    }

    public static String getResourceNameToBeUsed(String resourceName, SolrConfig config) {
        String nonManagedResourceName;
        PluginInfo info = config.getPluginInfo(IndexSchemaFactory.class.getName());
        String string = nonManagedResourceName = null == resourceName ? "schema.xml" : resourceName;
        if (null == info) {
            return nonManagedResourceName;
        }
        String managedSchemaResourceName = (String)info.initArgs.get("managedSchemaResourceName");
        if (null == managedSchemaResourceName) {
            managedSchemaResourceName = "managed-schema";
        }
        if (new File(config.getResourceLoader().getConfigDir(), managedSchemaResourceName).exists()) {
            return managedSchemaResourceName;
        }
        return nonManagedResourceName;
    }
}

