/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;

class DateFieldSource
extends FieldCacheSource {
    SchemaField sf;
    FieldType ft;
    private static int hcode = DateFieldSource.class.hashCode();

    public DateFieldSource(String name, SchemaField sf) {
        super(name);
        this.sf = sf;
        this.ft = sf.getType();
    }

    @Override
    public String description() {
        return "date(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        return new DocTermsIndexDocValues(this, readerContext, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return DateFieldSource.this.ft.toInternal(readableValue);
            }

            @Override
            public boolean exists(int doc) {
                return this.termsIndex.getOrd(doc) >= 0;
            }

            @Override
            public float floatVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public int intVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                return ord;
            }

            @Override
            public long longVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                return this.intVal(doc);
            }

            @Override
            public String strVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                if (ord == -1) {
                    return null;
                }
                BytesRef spare = this.termsIndex.lookupOrd(ord);
                return DateFieldSource.this.ft.indexedToReadable(spare, this.spareChars).toString();
            }

            @Override
            public Object objectVal(int doc) {
                int ord = this.termsIndex.getOrd(doc);
                if (ord == -1) {
                    return null;
                }
                BytesRef br = this.termsIndex.lookupOrd(ord);
                return DateFieldSource.this.ft.toObject(DateFieldSource.this.sf, br);
            }

            @Override
            public String toString(int doc) {
                return DateFieldSource.this.description() + '=' + this.intVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof DateFieldSource && super.equals(o);
    }

    @Override
    public int hashCode() {
        return hcode + super.hashCode();
    }
}

