/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.BoolDocValues;
import org.apache.lucene.queries.function.valuesource.OrdFieldSource;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueBool;

class BoolFieldSource
extends ValueSource {
    protected String field;
    private static final int hcode = OrdFieldSource.class.hashCode();

    public BoolFieldSource(String field) {
        this.field = field;
    }

    @Override
    public String description() {
        return "bool(" + this.field + ')';
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        final SortedDocValues sindex = FieldCache.DEFAULT.getTermsIndex(readerContext.reader(), this.field);
        int nord = sindex.getValueCount();
        int tord = -2;
        for (int i = 0; i < nord; ++i) {
            BytesRef br = sindex.lookupOrd(i);
            if (br.length != 1 || br.bytes[br.offset] != 84) continue;
            tord = i;
            break;
        }
        final int trueOrd = tord;
        return new BoolDocValues(this){

            @Override
            public boolean boolVal(int doc) {
                return sindex.getOrd(doc) == trueOrd;
            }

            @Override
            public boolean exists(int doc) {
                return sindex.getOrd(doc) != -1;
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueBool mval = new MutableValueBool();

                    @Override
                    public MutableValue getValue() {
                        return this.mval;
                    }

                    @Override
                    public void fillValue(int doc) {
                        int ord = sindex.getOrd(doc);
                        this.mval.value = ord == trueOrd;
                        this.mval.exists = ord != -1;
                    }
                };
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o.getClass() == BoolFieldSource.class && this.field.equals(((BoolFieldSource)o).field);
    }

    @Override
    public int hashCode() {
        return hcode + this.field.hashCode();
    }
}

