/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.Map;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTreeFactory;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.util.MapListener;

public abstract class AbstractSpatialPrefixTreeFieldType<T extends PrefixTreeStrategy>
extends AbstractSpatialFieldType<T> {
    public static final String DEFAULT_FIELD_VALUES_ARRAY_LEN = "defaultFieldValuesArrayLen";
    protected SpatialPrefixTree grid;
    private Double distErrPct;
    private Integer defaultFieldValuesArrayLen;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        MapListener<String, String> argsWrap = new MapListener<String, String>(args);
        this.grid = SpatialPrefixTreeFactory.makeSPT(argsWrap, schema.getResourceLoader().getClassLoader(), this.ctx);
        args.keySet().removeAll(argsWrap.getSeenKeys());
        String v = args.remove("distErrPct");
        if (v != null) {
            this.distErrPct = Double.valueOf(v);
        }
        if ((v = args.remove(DEFAULT_FIELD_VALUES_ARRAY_LEN)) != null) {
            this.defaultFieldValuesArrayLen = Integer.valueOf(v);
        }
    }

    @Override
    protected T newSpatialStrategy(String fieldName) {
        T strat = this.newPrefixTreeStrategy(fieldName);
        if (this.distErrPct != null) {
            ((PrefixTreeStrategy)strat).setDistErrPct(this.distErrPct);
        }
        if (this.defaultFieldValuesArrayLen != null) {
            ((PrefixTreeStrategy)strat).setDefaultFieldValuesArrayLen(this.defaultFieldValuesArrayLen);
        }
        this.log.info(this.toString() + " strat: " + strat + " maxLevels: " + this.grid.getMaxLevels());
        return strat;
    }

    protected abstract T newPrefixTreeStrategy(String var1);
}

