/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.util.LinkedHashSet;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.schema.SchemaField;
import org.restlet.resource.ResourceException;

abstract class BaseFieldResource
extends BaseSolrResource {
    protected static final String INCLUDE_DYNAMIC_PARAM = "includeDynamic";
    private static final String DYNAMIC_BASE = "dynamicBase";
    private LinkedHashSet<String> requestedFields;
    private boolean showDefaults;

    protected LinkedHashSet<String> getRequestedFields() {
        return this.requestedFields;
    }

    protected BaseFieldResource() {
    }

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            String[] fields;
            String flParam = this.getSolrRequest().getParams().get("fl");
            if (null != flParam && (fields = flParam.trim().split("[,\\s]+")).length > 0) {
                this.requestedFields = new LinkedHashSet();
                for (String field : fields) {
                    if (field.trim().isEmpty()) continue;
                    this.requestedFields.add(field.trim());
                }
            }
            this.showDefaults = this.getSolrRequest().getParams().getBool("showDefaults", false);
        }
    }

    protected SimpleOrderedMap<Object> getFieldProperties(SchemaField field) {
        if (null == field) {
            return null;
        }
        SimpleOrderedMap<Object> properties = field.getNamedPropertyValues(this.showDefaults);
        if (!this.getSchema().getFields().containsKey(field.getName())) {
            String dynamicBase = this.getSchema().getDynamicPattern(field.getName());
            if (!field.getName().equals(dynamicBase)) {
                properties.add(DYNAMIC_BASE, dynamicBase);
            }
        }
        if (field == this.getSchema().getUniqueKeyField()) {
            properties.add("uniqueKey", true);
        }
        return properties;
    }
}

