/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.rest.RestManager;
import org.apache.solr.rest.schema.CopyFieldCollectionResource;
import org.apache.solr.rest.schema.DefaultSearchFieldResource;
import org.apache.solr.rest.schema.DynamicFieldCollectionResource;
import org.apache.solr.rest.schema.DynamicFieldResource;
import org.apache.solr.rest.schema.FieldCollectionResource;
import org.apache.solr.rest.schema.FieldResource;
import org.apache.solr.rest.schema.FieldTypeCollectionResource;
import org.apache.solr.rest.schema.FieldTypeResource;
import org.apache.solr.rest.schema.SchemaNameResource;
import org.apache.solr.rest.schema.SchemaResource;
import org.apache.solr.rest.schema.SchemaSimilarityResource;
import org.apache.solr.rest.schema.SchemaVersionResource;
import org.apache.solr.rest.schema.SolrQueryParserDefaultOperatorResource;
import org.apache.solr.rest.schema.SolrQueryParserResource;
import org.apache.solr.rest.schema.UniqueKeyFieldResource;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.routing.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrSchemaRestApi
extends Application {
    public static final Logger log = LoggerFactory.getLogger(SolrSchemaRestApi.class);
    public static final String FIELDS_PATH = "/fields";
    public static final String DYNAMIC_FIELDS = "dynamicFields".toLowerCase(Locale.ROOT);
    public static final String DYNAMIC_FIELDS_PATH = "/" + DYNAMIC_FIELDS;
    public static final String FIELDTYPES = "fieldTypes".toLowerCase(Locale.ROOT);
    public static final String FIELDTYPES_PATH = "/" + FIELDTYPES;
    public static final String NAME_PATH = "/" + "name".toLowerCase(Locale.ROOT);
    public static final String NAME_SEGMENT = "/{" + "name".toLowerCase(Locale.ROOT) + "}";
    public static final String COPY_FIELDS = "copyFields".toLowerCase(Locale.ROOT);
    public static final String COPY_FIELDS_PATH = "/" + COPY_FIELDS;
    public static final String VERSION_PATH = "/" + "version".toLowerCase(Locale.ROOT);
    public static final String DEFAULT_SEARCH_FIELD = "defaultSearchField".toLowerCase(Locale.ROOT);
    public static final String DEFAULT_SEARCH_FIELD_PATH = "/" + DEFAULT_SEARCH_FIELD;
    public static final String SIMILARITY_PATH = "/" + "similarity".toLowerCase(Locale.ROOT);
    public static final String SOLR_QUERY_PARSER = "solrQueryParser".toLowerCase(Locale.ROOT);
    public static final String SOLR_QUERY_PARSER_PATH = "/" + SOLR_QUERY_PARSER;
    public static final String DEFAULT_OPERATOR = "defaultOperator".toLowerCase(Locale.ROOT);
    public static final String DEFAULT_OPERATOR_PATH = SOLR_QUERY_PARSER_PATH + "/" + DEFAULT_OPERATOR;
    public static final String UNIQUE_KEY_FIELD = "uniqueKey".toLowerCase(Locale.ROOT);
    public static final String UNIQUE_KEY_FIELD_PATH = "/" + UNIQUE_KEY_FIELD;
    private Router router = new Router(this.getContext());

    public static Set<String> getReservedEndpoints() {
        HashSet<String> reservedEndpoints = new HashSet<String>();
        reservedEndpoints.add("/schema/fields");
        reservedEndpoints.add("/schema" + DYNAMIC_FIELDS_PATH);
        reservedEndpoints.add("/schema" + FIELDTYPES_PATH);
        reservedEndpoints.add("/schema" + NAME_PATH);
        reservedEndpoints.add("/schema" + COPY_FIELDS_PATH);
        reservedEndpoints.add("/schema" + VERSION_PATH);
        reservedEndpoints.add("/schema" + DEFAULT_SEARCH_FIELD_PATH);
        reservedEndpoints.add("/schema" + SIMILARITY_PATH);
        reservedEndpoints.add("/schema" + SOLR_QUERY_PARSER_PATH);
        reservedEndpoints.add("/schema" + DEFAULT_OPERATOR_PATH);
        reservedEndpoints.add("/schema" + UNIQUE_KEY_FIELD_PATH);
        return Collections.unmodifiableSet(reservedEndpoints);
    }

    @Override
    public void stop() throws Exception {
        if (null != this.router) {
            this.router.stop();
        }
    }

    @Override
    public synchronized Restlet createInboundRoot() {
        log.info("createInboundRoot started for /schema");
        this.router.attach("", SchemaResource.class);
        this.router.attach("/", SchemaResource.class);
        this.router.attach(FIELDS_PATH, FieldCollectionResource.class);
        this.router.attach("/fields/", FieldCollectionResource.class);
        this.router.attach(FIELDS_PATH + NAME_SEGMENT, FieldResource.class);
        this.router.attach(DYNAMIC_FIELDS_PATH, DynamicFieldCollectionResource.class);
        this.router.attach(DYNAMIC_FIELDS_PATH + "/", DynamicFieldCollectionResource.class);
        this.router.attach(DYNAMIC_FIELDS_PATH + NAME_SEGMENT, DynamicFieldResource.class);
        this.router.attach(FIELDTYPES_PATH, FieldTypeCollectionResource.class);
        this.router.attach(FIELDTYPES_PATH + "/", FieldTypeCollectionResource.class);
        this.router.attach(FIELDTYPES_PATH + NAME_SEGMENT, FieldTypeResource.class);
        this.router.attach(COPY_FIELDS_PATH, CopyFieldCollectionResource.class);
        this.router.attach(COPY_FIELDS_PATH + "/", CopyFieldCollectionResource.class);
        this.router.attach(NAME_PATH, SchemaNameResource.class);
        this.router.attach(VERSION_PATH, SchemaVersionResource.class);
        this.router.attach(UNIQUE_KEY_FIELD_PATH, UniqueKeyFieldResource.class);
        this.router.attach(DEFAULT_SEARCH_FIELD_PATH, DefaultSearchFieldResource.class);
        this.router.attach(SIMILARITY_PATH, SchemaSimilarityResource.class);
        this.router.attach(SOLR_QUERY_PARSER_PATH, SolrQueryParserResource.class);
        this.router.attach(DEFAULT_OPERATOR_PATH, SolrQueryParserDefaultOperatorResource.class);
        this.router.attachDefault(RestManager.ManagedEndpoint.class);
        RestManager.getRestManager(SolrRequestInfo.getRequestInfo()).attachManagedResources("/schema", this.router);
        log.info("createInboundRoot complete for /schema");
        return this.router;
    }
}

