/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.util.ArrayList;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;

public class ResponseWriterUtil {
    public static final SolrDocument toSolrDocument(Document doc, IndexSchema schema) {
        SolrDocument out = new SolrDocument();
        for (IndexableField f : doc.getFields()) {
            Object existing = out.get(f.name());
            if (existing == null) {
                SchemaField sf = schema.getFieldOrNull(f.name());
                if (sf != null && sf.multiValued()) {
                    ArrayList<IndexableField> vals = new ArrayList<IndexableField>();
                    vals.add(f);
                    out.setField(f.name(), vals);
                    continue;
                }
                out.setField(f.name(), f);
                continue;
            }
            out.addField(f.name(), f);
        }
        return out;
    }
}

