/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.CountSortedFacetCollector;
import org.apache.solr.request.FacetCollector;
import org.apache.solr.request.IndexSortedFacetCollector;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

class PerSegmentSingleValuedFaceting {
    SolrIndexSearcher searcher;
    DocSet docs;
    String fieldName;
    int offset;
    int limit;
    int mincount;
    boolean missing;
    String sort;
    String prefix;
    Filter baseSet;
    int nThreads;

    public PerSegmentSingleValuedFaceting(SolrIndexSearcher searcher, DocSet docs, String fieldName, int offset, int limit, int mincount, boolean missing, String sort, String prefix) {
        this.searcher = searcher;
        this.docs = docs;
        this.fieldName = fieldName;
        this.offset = offset;
        this.limit = limit;
        this.mincount = mincount;
        this.missing = missing;
        this.sort = sort;
        this.prefix = prefix;
    }

    public void setNumThreads(int threads) {
        this.nThreads = threads;
    }

    NamedList<Integer> getFacetCounts(Executor executor) throws IOException {
        SegFacet seg;
        ExecutorCompletionService<SegFacet> completionService = new ExecutorCompletionService<SegFacet>(executor);
        this.baseSet = this.docs.getTopFilter();
        List<AtomicReaderContext> leaves = this.searcher.getTopReaderContext().leaves();
        LinkedList<1> pending = new LinkedList<1>();
        int threads = this.nThreads <= 0 ? Integer.MAX_VALUE : this.nThreads;
        for (AtomicReaderContext leave : leaves) {
            final SegFacet segFacet = new SegFacet(leave);
            Callable<SegFacet> task = new Callable<SegFacet>(){

                @Override
                public SegFacet call() throws Exception {
                    segFacet.countTerms();
                    return segFacet;
                }
            };
            if (--threads >= 0) {
                completionService.submit(task);
                continue;
            }
            pending.add(task);
        }
        PriorityQueue<SegFacet> queue = new PriorityQueue<SegFacet>(leaves.size()){

            @Override
            protected boolean lessThan(SegFacet a, SegFacet b) {
                return a.tempBR.compareTo(b.tempBR) < 0;
            }
        };
        boolean hasMissingCount = false;
        int missingCount = 0;
        int c = leaves.size();
        for (int i = 0; i < c; ++i) {
            seg = null;
            try {
                Future future = completionService.take();
                seg = (SegFacet)future.get();
                if (!pending.isEmpty()) {
                    completionService.submit((Callable)pending.removeFirst());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in per-segment faceting on field: " + this.fieldName, cause);
            }
            if (seg.startTermIndex >= seg.endTermIndex) continue;
            if (seg.startTermIndex == -1) {
                hasMissingCount = true;
                missingCount += seg.counts[0];
                seg.pos = 0;
            } else {
                seg.pos = seg.startTermIndex;
            }
            if (seg.pos >= seg.endTermIndex) continue;
            seg.tenum = seg.si.termsEnum();
            seg.tenum.seekExact(seg.pos);
            seg.tempBR = seg.tenum.term();
            queue.add(seg);
        }
        FacetCollector collector = this.sort.equals("count") || this.sort.equals("true") ? new CountSortedFacetCollector(this.offset, this.limit, this.mincount) : new IndexSortedFacetCollector(this.offset, this.limit, this.mincount);
        BytesRefBuilder val = new BytesRefBuilder();
        while (queue.size() > 0) {
            seg = (SegFacet)queue.top();
            val.copyBytes(seg.tempBR);
            int count = 0;
            do {
                count += seg.counts[seg.pos - seg.startTermIndex];
                ++seg.pos;
                if (seg.pos >= seg.endTermIndex) {
                    queue.pop();
                    seg = (SegFacet)queue.top();
                    continue;
                }
                seg.tempBR = seg.tenum.next();
                seg = (SegFacet)queue.updateTop();
            } while (seg != null && val.get().compareTo(seg.tempBR) == 0);
            boolean stop = collector.collect(val.get(), count);
            if (!stop) continue;
            break;
        }
        NamedList<Integer> res = collector.getFacetCounts();
        FieldType ft = this.searcher.getSchema().getFieldType(this.fieldName);
        int sz = res.size();
        for (int i = 0; i < sz; ++i) {
            res.setName(i, ft.indexedToReadable(res.getName(i)));
        }
        if (this.missing) {
            if (!hasMissingCount) {
                missingCount = SimpleFacets.getFieldMissingCount(this.searcher, this.docs, this.fieldName);
            }
            res.add(null, missingCount);
        }
        return res;
    }

    class SegFacet {
        AtomicReaderContext context;
        SortedDocValues si;
        int startTermIndex;
        int endTermIndex;
        int[] counts;
        int pos;
        TermsEnum tenum;
        BytesRef tempBR = new BytesRef();

        SegFacet(AtomicReaderContext context) {
            this.context = context;
        }

        void countTerms() throws IOException {
            block8: {
                this.si = FieldCache.DEFAULT.getTermsIndex(this.context.reader(), PerSegmentSingleValuedFaceting.this.fieldName);
                if (PerSegmentSingleValuedFaceting.this.prefix != null) {
                    BytesRefBuilder prefixRef = new BytesRefBuilder();
                    prefixRef.copyChars(PerSegmentSingleValuedFaceting.this.prefix);
                    this.startTermIndex = this.si.lookupTerm(prefixRef.get());
                    if (this.startTermIndex < 0) {
                        this.startTermIndex = -this.startTermIndex - 1;
                    }
                    prefixRef.append(UnicodeUtil.BIG_TERM);
                    this.endTermIndex = this.si.lookupTerm(prefixRef.get());
                    assert (this.endTermIndex < 0);
                    this.endTermIndex = -this.endTermIndex - 1;
                } else {
                    this.startTermIndex = -1;
                    this.endTermIndex = this.si.getValueCount();
                }
                int nTerms = this.endTermIndex - this.startTermIndex;
                if (nTerms <= 0) break block8;
                this.counts = new int[nTerms];
                int[] counts = this.counts;
                DocIdSet idSet = PerSegmentSingleValuedFaceting.this.baseSet.getDocIdSet(this.context, null);
                DocIdSetIterator iter = idSet.iterator();
                if (PerSegmentSingleValuedFaceting.this.prefix == null) {
                    int doc;
                    while ((doc = iter.nextDoc()) < Integer.MAX_VALUE) {
                        int n = 1 + this.si.getOrd(doc);
                        counts[n] = counts[n] + 1;
                    }
                } else {
                    int doc;
                    while ((doc = iter.nextDoc()) < Integer.MAX_VALUE) {
                        int term = this.si.getOrd(doc);
                        int arrIdx = term - this.startTermIndex;
                        if (arrIdx < 0 || arrIdx >= nTerms) continue;
                        int n = arrIdx;
                        counts[n] = counts[n] + 1;
                    }
                }
            }
        }
    }
}

