/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.FieldFacetStats;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.request.DocValuesStats;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.UnInvertedField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

class SimpleStats {
    protected DocSet docs;
    protected SolrParams params;
    protected SolrIndexSearcher searcher;
    protected SolrQueryRequest req;
    protected ResponseBuilder rb;
    SolrParams localParams;
    String statsField;
    DocSet base;
    String key;

    public SimpleStats(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        this.req = req;
        this.searcher = req.getSearcher();
        this.docs = docs;
        this.params = params;
        this.rb = rb;
    }

    protected void parseParams(String param) throws SyntaxError, IOException {
        this.localParams = QueryParsing.getLocalParams(param, this.req.getParams());
        this.base = this.docs;
        this.statsField = param;
        this.key = param;
        if (this.localParams == null) {
            return;
        }
        this.key = this.statsField = this.localParams.get("v");
        this.key = this.localParams.get("key", this.key);
        String excludeStr = this.localParams.get("ex");
        if (excludeStr == null) {
            return;
        }
        Map tagMap = (Map)this.req.getContext().get("tags");
        if (tagMap != null && this.rb != null) {
            List<String> excludeTagList = StrUtils.splitSmart(excludeStr, ',');
            IdentityHashMap<Query, Boolean> excludeSet = new IdentityHashMap<Query, Boolean>();
            for (String excludeTag : excludeTagList) {
                Object olst = tagMap.get(excludeTag);
                if (!(olst instanceof Collection)) continue;
                for (Object o : (Collection)olst) {
                    if (!(o instanceof QParser)) continue;
                    QParser qp = (QParser)o;
                    excludeSet.put(qp.getQuery(), Boolean.TRUE);
                }
            }
            if (excludeSet.size() == 0) {
                return;
            }
            ArrayList<Query> qlist = new ArrayList<Query>();
            if (!excludeSet.containsKey(this.rb.getQuery())) {
                qlist.add(this.rb.getQuery());
            }
            if (this.rb.getFilters() != null) {
                for (Query q : this.rb.getFilters()) {
                    if (excludeSet.containsKey(q)) continue;
                    qlist.add(q);
                }
            }
            this.base = this.searcher.getDocSet(qlist);
        }
    }

    public NamedList<Object> getStatsCounts() throws IOException {
        SimpleOrderedMap<Object> res = new SimpleOrderedMap<Object>();
        try {
            res.add("stats_fields", this.getStatsFields());
        }
        catch (SyntaxError e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        return res;
    }

    public NamedList<Object> getStatsFields() throws IOException, SyntaxError {
        SimpleOrderedMap<Object> res = new SimpleOrderedMap<Object>();
        String[] statsFs = this.params.getParams("stats.field");
        boolean isShard = this.params.getBool("isShard", false);
        if (null != statsFs) {
            IndexSchema schema = this.searcher.getSchema();
            for (String f : statsFs) {
                NamedList<?> stv;
                boolean calcDistinct = this.params.getFieldBool(f, "stats.calcdistinct", false);
                this.parseParams(f);
                String[] facets = this.params.getFieldParams(this.key, "stats.facet");
                if (facets == null) {
                    facets = new String[]{};
                }
                SchemaField sf = schema.getField(this.statsField);
                FieldType ft = sf.getType();
                if (sf.multiValued() || ft.multiValuedFieldCache()) {
                    if (sf.hasDocValues()) {
                        stv = DocValuesStats.getCounts(this.searcher, sf.getName(), this.base, calcDistinct, facets).getStatsValues();
                    } else {
                        UnInvertedField uif = UnInvertedField.getUnInvertedField(this.statsField, this.searcher);
                        stv = uif.getStats(this.searcher, this.base, calcDistinct, facets).getStatsValues();
                    }
                } else {
                    stv = this.getFieldCacheStats(this.statsField, calcDistinct, facets);
                }
                if (isShard || (Long)stv.get("count") > 0L) {
                    res.add(this.key, stv);
                    continue;
                }
                res.add(this.key, null);
            }
        }
        return res;
    }

    public NamedList<?> getFieldCacheStats(String fieldName, boolean calcDistinct, String[] facet) throws IOException {
        IndexSchema schema = this.searcher.getSchema();
        SchemaField sf = schema.getField(fieldName);
        StatsValues allstats = StatsValuesFactory.createStatsValues(sf, calcDistinct);
        ArrayList<FieldFacetStats> facetStats = new ArrayList<FieldFacetStats>();
        for (String facetField : facet) {
            SchemaField fsf = schema.getField(facetField);
            if (fsf.multiValued()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Stats can only facet on single-valued fields, not: " + facetField);
            }
            facetStats.add(new FieldFacetStats(this.searcher, facetField, sf, fsf, calcDistinct));
        }
        Iterator<AtomicReaderContext> ctxIt = this.searcher.getIndexReader().leaves().iterator();
        AtomicReaderContext ctx = null;
        DocIterator docsIt = this.base.iterator();
        while (docsIt.hasNext()) {
            int doc = docsIt.nextDoc();
            if (ctx == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                while ((ctx = ctxIt.next()) == null || doc >= ctx.docBase + ctx.reader().maxDoc()) {
                }
                assert (doc >= ctx.docBase);
                allstats.setNextReader(ctx);
                for (FieldFacetStats f : facetStats) {
                    f.setNextReader(ctx);
                }
            }
            allstats.accumulate(doc - ctx.docBase);
            for (FieldFacetStats f : facetStats) {
                f.facet(doc - ctx.docBase);
            }
        }
        for (FieldFacetStats f : facetStats) {
            allstats.addFacet(f.name, f.facetStatsValues);
        }
        return allstats.getStatsValues();
    }
}

