/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.BitSet;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.PivotFacetField;
import org.apache.solr.handler.component.PivotFacetHelper;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.util.PivotListEntry;

public class PivotFacetValue {
    private final BitSet sourceShards = new BitSet();
    private final PivotFacetField parentPivot;
    private final Comparable value;
    private PivotFacetField childPivot = null;
    private int count;

    private PivotFacetValue(PivotFacetField parent, Comparable val) {
        this.parentPivot = parent;
        this.value = val;
    }

    public Comparable getValue() {
        return this.value;
    }

    public int getCount() {
        return this.count;
    }

    public PivotFacetField getChildPivot() {
        return this.childPivot;
    }

    public List<String> getValuePath() {
        List<String> out = this.parentPivot.getValuePath();
        if (null == this.value) {
            out.add(null);
        } else if (this.value instanceof Date) {
            out.add(TrieDateField.formatExternal((Date)this.value));
        } else {
            out.add(this.value.toString());
        }
        return out;
    }

    public static PivotFacetValue createFromNamedList(int shardNumber, ResponseBuilder rb, PivotFacetField parentField, NamedList<Object> pivotData) {
        Comparable pivotVal = null;
        int pivotCount = 0;
        List childPivotData = null;
        block6: for (int i = 0; i < pivotData.size(); ++i) {
            String key = pivotData.getName(i);
            Object value = pivotData.getVal(i);
            PivotListEntry entry = PivotListEntry.get(key);
            switch (entry) {
                case VALUE: {
                    pivotVal = (Comparable)value;
                    continue block6;
                }
                case FIELD: {
                    assert (parentField.field.equals(value)) : "Parent Field mismatch: " + parentField.field + "!=" + value;
                    continue block6;
                }
                case COUNT: {
                    pivotCount = (Integer)value;
                    continue block6;
                }
                case PIVOT: {
                    childPivotData = (List)value;
                    continue block6;
                }
                default: {
                    throw new RuntimeException("PivotListEntry contains unaccounted for item: " + (Object)((Object)entry));
                }
            }
        }
        PivotFacetValue newPivotFacet = new PivotFacetValue(parentField, pivotVal);
        newPivotFacet.count = pivotCount;
        newPivotFacet.sourceShards.set(shardNumber);
        newPivotFacet.childPivot = PivotFacetField.createFromListOfNamedLists(shardNumber, rb, newPivotFacet, childPivotData);
        return newPivotFacet;
    }

    public boolean shardHasContributed(int shardNum) {
        return this.sourceShards.get(shardNum);
    }

    public NamedList<Object> convertToNamedList() {
        SimpleOrderedMap<Object> newList = new SimpleOrderedMap<Object>();
        newList.add(PivotListEntry.FIELD.getName(), this.parentPivot.field);
        newList.add(PivotListEntry.VALUE.getName(), this.value);
        newList.add(PivotListEntry.COUNT.getName(), this.count);
        if (this.childPivot != null && this.childPivot.convertToListOfNamedLists() != null) {
            newList.add(PivotListEntry.PIVOT.getName(), this.childPivot.convertToListOfNamedLists());
        }
        return newList;
    }

    public void mergeContributionFromShard(int shardNumber, ResponseBuilder rb, NamedList<Object> value) {
        assert (null != value) : "can't merge in null data";
        if (!this.shardHasContributed(shardNumber)) {
            this.sourceShards.set(shardNumber);
            this.count += PivotFacetHelper.getCount(value).intValue();
        }
        List<NamedList<Object>> shardChildPivots = PivotFacetHelper.getPivots(value);
        if (null == this.childPivot) {
            this.childPivot = PivotFacetField.createFromListOfNamedLists(shardNumber, rb, this, shardChildPivots);
        } else {
            this.childPivot.contributeFromShard(shardNumber, rb, shardChildPivots);
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "F:%s V:%s Co:%d Ch?:%s", this.parentPivot.field, this.value, this.count, this.childPivot != null);
    }
}

