/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.PivotFacetHelper;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class PivotFacetProcessor
extends SimpleFacets {
    protected SolrParams params;

    public PivotFacetProcessor(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        super(req, docs, params, rb);
        this.params = params;
    }

    public SimpleOrderedMap<List<NamedList<Object>>> process(String[] pivots) throws IOException {
        if (!this.rb.doFacets || pivots == null) {
            return null;
        }
        SimpleOrderedMap<List<NamedList<Object>>> pivotResponse = new SimpleOrderedMap<List<NamedList<Object>>>();
        for (String pivotList : pivots) {
            String fieldValueKey;
            try {
                this.parseParams("facet.pivot", pivotList);
            }
            catch (SyntaxError e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            List<String> pivotFields = StrUtils.splitSmart(this.facetValue, ",", true);
            if (pivotFields.size() < 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Pivot Facet needs at least one field name: " + pivotList);
            }
            SolrIndexSearcher searcher = this.rb.req.getSearcher();
            for (String fieldName : pivotFields) {
                SchemaField sfield = searcher.getSchema().getField(fieldName);
                if (sfield != null) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "\"" + fieldName + "\" is not a valid field name in pivot: " + pivotList);
            }
            String string = fieldValueKey = this.localParams == null ? null : this.localParams.get("fpt");
            if (fieldValueKey != null) {
                String[] refinementValuesByField;
                for (String refinements : refinementValuesByField = this.params.getParams("fpt" + fieldValueKey)) {
                    pivotResponse.addAll(this.processSingle(pivotFields, refinements));
                }
                continue;
            }
            pivotResponse.addAll(this.processSingle(pivotFields, null));
        }
        return pivotResponse;
    }

    private SimpleOrderedMap<List<NamedList<Object>>> processSingle(List<String> pivotFields, String refinements) throws IOException {
        NamedList<Integer> facetCounts;
        SolrIndexSearcher searcher = this.rb.req.getSearcher();
        SimpleOrderedMap<List<NamedList<Object>>> pivotResponse = new SimpleOrderedMap<List<NamedList<Object>>>();
        String field = pivotFields.get(0);
        SchemaField sfield = searcher.getSchema().getField(field);
        LinkedList<String> fnames = new LinkedList<String>();
        for (int i = pivotFields.size() - 1; i > 1; --i) {
            fnames.push(pivotFields.get(i));
        }
        LinkedList<String> vnames = new LinkedList<String>();
        if (null != refinements) {
            List<String> refinementValuesByField = PivotFacetHelper.decodeRefinementValuePath(refinements);
            for (int i = refinementValuesByField.size() - 1; i > 0; --i) {
                vnames.push(refinementValuesByField.get(i));
            }
            String firstFieldsValues = refinementValuesByField.get(0);
            facetCounts = new NamedList();
            facetCounts.add(firstFieldsValues, this.getSubsetSize(this.docs, sfield, firstFieldsValues));
        } else {
            facetCounts = this.getTermCountsForPivots(field, this.docs);
        }
        if (pivotFields.size() > 1) {
            String subField = pivotFields.get(1);
            pivotResponse.add(this.key, this.doPivots(facetCounts, field, subField, fnames, vnames, this.docs));
        } else {
            pivotResponse.add(this.key, this.doPivots(facetCounts, field, null, fnames, vnames, this.docs));
        }
        return pivotResponse;
    }

    protected List<NamedList<Object>> doPivots(NamedList<Integer> superFacets, String field, String subField, Deque<String> fnames, Deque<String> vnames, DocSet docs) throws IOException {
        SolrIndexSearcher searcher = this.rb.req.getSearcher();
        SchemaField sfield = searcher.getSchema().getField(field);
        FieldType ftype = sfield.getType();
        String nextField = fnames.poll();
        BytesRef termval = new BytesRef();
        ArrayList<NamedList<Object>> values = new ArrayList<NamedList<Object>>(superFacets.size());
        for (Map.Entry<String, Integer> entry : superFacets) {
            if (entry.getValue() < this.getMinCountForField(field)) continue;
            String fieldValue = entry.getKey();
            SimpleOrderedMap<Object> pivot = new SimpleOrderedMap<Object>();
            pivot.add("field", field);
            if (null == fieldValue) {
                pivot.add("value", null);
            } else {
                ftype.readableToIndexed(fieldValue, termval);
                pivot.add("value", ftype.toObject(sfield, termval));
            }
            pivot.add("count", entry.getValue());
            DocSet subset = this.getSubset(docs, sfield, fieldValue);
            if (subField != null) {
                NamedList<Integer> facetCounts;
                if (!vnames.isEmpty()) {
                    String val = vnames.pop();
                    facetCounts = new NamedList();
                    facetCounts.add(val, this.getSubsetSize(subset, searcher.getSchema().getField(subField), val));
                } else {
                    facetCounts = this.getTermCountsForPivots(subField, subset);
                }
                if (facetCounts.size() >= 1) {
                    pivot.add("pivot", this.doPivots(facetCounts, subField, nextField, fnames, vnames, subset));
                }
            }
            values.add(pivot);
        }
        fnames.push(nextField);
        return values;
    }

    private int getSubsetSize(DocSet base, SchemaField field, String pivotValue) throws IOException {
        FieldType ft = field.getType();
        if (null == pivotValue) {
            Query query = ft.getRangeQuery(null, field, null, null, false, false);
            DocSet hasVal = this.searcher.getDocSet(query);
            return base.andNotSize(hasVal);
        }
        Query query = ft.getFieldQuery(null, field, pivotValue);
        return this.searcher.numDocs(query, base);
    }

    private DocSet getSubset(DocSet base, SchemaField field, String pivotValue) throws IOException {
        FieldType ft = field.getType();
        if (null == pivotValue) {
            Query query = ft.getRangeQuery(null, field, null, null, false, false);
            DocSet hasVal = this.searcher.getDocSet(query);
            return base.andNot(hasVal);
        }
        Query query = ft.getFieldQuery(null, field, pivotValue);
        return this.searcher.getDocSet(query, base);
    }

    private int getMinCountForField(String fieldname) {
        return this.params.getFieldInt(fieldname, "facet.pivot.mincount", 1);
    }
}

