/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.PivotListEntry;

public class PivotFacetHelper {
    public static String encodeRefinementValuePath(List<String> values) {
        assert (null != values);
        if (values.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (String val : values) {
            if (null == val) {
                out.append('^');
            } else {
                out.append('~');
                StrUtils.appendEscapedTextToBuilder(out, val, ',');
            }
            out.append(',');
        }
        out.deleteCharAt(out.length() - 1);
        return out.toString();
    }

    public static List<String> decodeRefinementValuePath(String valuePath) {
        List<String> rawvals = StrUtils.splitSmart(valuePath, ",", true);
        if (rawvals.isEmpty()) {
            return rawvals;
        }
        ArrayList<String> out = new ArrayList<String>(rawvals.size());
        for (String raw : rawvals) {
            assert (0 < raw.length());
            if ('^' == raw.charAt(0)) {
                assert (1 == raw.length());
                out.add(null);
                continue;
            }
            assert ('~' == raw.charAt(0));
            out.add(raw.substring(1));
        }
        return out;
    }

    public static Comparable getValue(NamedList<Object> pivotList) {
        return (Comparable)PivotFacetHelper.retrieve(PivotListEntry.VALUE, pivotList);
    }

    public static String getField(NamedList<Object> pivotList) {
        return (String)PivotFacetHelper.retrieve(PivotListEntry.FIELD, pivotList);
    }

    public static Integer getCount(NamedList<Object> pivotList) {
        return (Integer)PivotFacetHelper.retrieve(PivotListEntry.COUNT, pivotList);
    }

    public static List<NamedList<Object>> getPivots(NamedList<Object> pivotList) {
        int pivotIdx = pivotList.indexOf(PivotListEntry.PIVOT.getName(), 0);
        if (pivotIdx > -1) {
            return (List)pivotList.getVal(pivotIdx);
        }
        return null;
    }

    private static Object retrieve(PivotListEntry entryToGet, NamedList<Object> pivotList) {
        return pivotList.get(entryToGet.getName(), entryToGet.getIndex());
    }
}

