/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.PivotFacet;
import org.apache.solr.handler.component.PivotFacetHelper;
import org.apache.solr.handler.component.PivotFacetProcessor;
import org.apache.solr.handler.component.PivotFacetValue;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SyntaxError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetComponent
extends SearchComponent {
    public static Logger log = LoggerFactory.getLogger(FacetComponent.class);
    public static final String COMPONENT_NAME = "facet";
    private static final String PIVOT_KEY = "facet_pivot";
    private static final String PIVOT_REFINE_PREFIX = "{!fpt=";
    int pivotRefinementCounter = 0;
    private static final String commandPrefix = "{!terms=$";

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool(COMPONENT_NAME, false)) {
            rb.setNeedDocSet(true);
            rb.doFacets = true;
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        if (rb.doFacets) {
            PivotFacetProcessor pivotProcessor;
            SimpleOrderedMap<List<NamedList<Object>>> v;
            ModifiableSolrParams params = new ModifiableSolrParams();
            SolrParams origParams = rb.req.getParams();
            Iterator<String> iter = origParams.getParameterNamesIterator();
            while (iter.hasNext()) {
                String paramName = iter.next();
                if (!paramName.startsWith(COMPONENT_NAME)) {
                    params.add(paramName, origParams.getParams(paramName));
                    continue;
                }
                LinkedHashSet<String> deDupe = new LinkedHashSet<String>(Arrays.asList(origParams.getParams(paramName)));
                params.add(paramName, deDupe.toArray(new String[deDupe.size()]));
            }
            SimpleFacets f = new SimpleFacets(rb.req, rb.getResults().docSet, params, rb);
            NamedList<Object> counts = f.getFacetCounts();
            String[] pivots = params.getParams("facet.pivot");
            if (pivots != null && pivots.length > 0 && (v = (pivotProcessor = new PivotFacetProcessor(rb.req, rb.getResults().docSet, params, rb)).process(pivots)) != null) {
                counts.add(PIVOT_KEY, v);
            }
            rb.rsp.add("facet_counts", counts);
        }
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) throws IOException {
        if (!rb.doFacets) {
            return ResponseBuilder.STAGE_DONE;
        }
        if (rb.stage == ResponseBuilder.STAGE_GET_FIELDS) {
            for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
                ArrayList<String> distribFieldFacetRefinements = null;
                for (DistribFieldFacet dff : rb._facetInfo.facets.values()) {
                    List<String> refList;
                    if (!dff.needRefinements || (refList = dff._toRefine[shardNum]) == null || refList.size() == 0) continue;
                    String key = dff.getKey();
                    String termsKey = key + "__terms";
                    String termsVal = StrUtils.join(refList, ',');
                    String termsKeyEncoded = QueryParsing.encodeLocalParamVal(termsKey);
                    String facetCommand = dff.localParams != null ? commandPrefix + termsKeyEncoded + " " + dff.facetStr.substring(2) : commandPrefix + termsKeyEncoded + '}' + dff.field;
                    if (distribFieldFacetRefinements == null) {
                        distribFieldFacetRefinements = new ArrayList<String>();
                    }
                    distribFieldFacetRefinements.add(facetCommand);
                    distribFieldFacetRefinements.add(termsKey);
                    distribFieldFacetRefinements.add(termsVal);
                }
                boolean pivotFacetRefinementRequestsExistForShard = this.doAnyPivotFacetRefinementRequestsExistForShard(rb._facetInfo, shardNum);
                if (distribFieldFacetRefinements == null && !pivotFacetRefinementRequestsExistForShard) continue;
                String shard = rb.shards[shardNum];
                ShardRequest shardsRefineRequest = null;
                boolean newRequest = false;
                for (ShardRequest sreq : rb.outgoing) {
                    if ((sreq.purpose & 0x40) == 0 || sreq.shards == null || sreq.shards.length != 1 || !sreq.shards[0].equals(shard)) continue;
                    shardsRefineRequest = sreq;
                    break;
                }
                if (shardsRefineRequest == null) {
                    newRequest = true;
                    shardsRefineRequest = new ShardRequest();
                    shardsRefineRequest.shards = new String[]{rb.shards[shardNum]};
                    shardsRefineRequest.params = new ModifiableSolrParams(rb.req.getParams());
                    shardsRefineRequest.params.remove("start");
                    shardsRefineRequest.params.set("rows", "0");
                }
                if (distribFieldFacetRefinements != null) {
                    shardsRefineRequest.purpose |= 0x20;
                    shardsRefineRequest.params.set(COMPONENT_NAME, "true");
                    shardsRefineRequest.params.remove("facet.field");
                    shardsRefineRequest.params.remove("facet.query");
                    int i = 0;
                    while (i < distribFieldFacetRefinements.size()) {
                        String facetCommand = (String)distribFieldFacetRefinements.get(i++);
                        String termsKey = (String)distribFieldFacetRefinements.get(i++);
                        String termsVal = (String)distribFieldFacetRefinements.get(i++);
                        shardsRefineRequest.params.add("facet.field", facetCommand);
                        shardsRefineRequest.params.set(termsKey, termsVal);
                    }
                }
                if (newRequest) {
                    rb.addRequest(this, shardsRefineRequest);
                }
                if (!pivotFacetRefinementRequestsExistForShard) continue;
                if (newRequest) {
                    shardsRefineRequest.params.remove("facet.pivot");
                    shardsRefineRequest.params.remove("facet.pivot.mincount");
                }
                this.enqueuePivotFacetShardRequests(null, rb, shardNum);
            }
        }
        return ResponseBuilder.STAGE_DONE;
    }

    private void enqueuePivotFacetShardRequests(HashMap<String, List<String>> pivotFacetRefinements, ResponseBuilder rb, int shardNum) {
        FacetInfo fi = rb._facetInfo;
        ShardRequest shardsRefineRequestPivot = new ShardRequest();
        shardsRefineRequestPivot.shards = new String[]{rb.shards[shardNum]};
        shardsRefineRequestPivot.params = new ModifiableSolrParams(rb.req.getParams());
        shardsRefineRequestPivot.params.remove("start");
        shardsRefineRequestPivot.params.set("rows", "0");
        shardsRefineRequestPivot.purpose |= 0x2000;
        shardsRefineRequestPivot.params.set(COMPONENT_NAME, "true");
        shardsRefineRequestPivot.params.remove("facet.pivot.mincount");
        shardsRefineRequestPivot.params.set("facet.pivot.mincount", -1);
        shardsRefineRequestPivot.params.remove("facet.pivot");
        shardsRefineRequestPivot.params.remove("facet.offset");
        for (int pivotIndex = 0; pivotIndex < fi.pivotFacets.size(); ++pivotIndex) {
            String pivotFacetKey = fi.pivotFacets.getName(pivotIndex);
            PivotFacet pivotFacet = (PivotFacet)fi.pivotFacets.getVal(pivotIndex);
            List<PivotFacetValue> queuedRefinementsForShard = pivotFacet.getQueuedRefinements(shardNum);
            if (!queuedRefinementsForShard.isEmpty()) {
                String fieldsKey = "fpt" + this.pivotRefinementCounter;
                String command = pivotFacet.localParams != null ? PIVOT_REFINE_PREFIX + this.pivotRefinementCounter + " " + pivotFacet.facetStr.substring(2) : PIVOT_REFINE_PREFIX + this.pivotRefinementCounter + "}" + pivotFacet.getKey();
                shardsRefineRequestPivot.params.add("facet.pivot", command);
                for (PivotFacetValue refinementValue : queuedRefinementsForShard) {
                    String refinementStr = PivotFacetHelper.encodeRefinementValuePath(refinementValue.getValuePath());
                    shardsRefineRequestPivot.params.add(fieldsKey, refinementStr);
                }
            }
            ++this.pivotRefinementCounter;
        }
        rb.addRequest(this, shardsRefineRequestPivot);
    }

    @Override
    public void modifyRequest(ResponseBuilder rb, SearchComponent who, ShardRequest sreq) {
        if (!rb.doFacets) {
            return;
        }
        if ((sreq.purpose & 4) != 0) {
            sreq.purpose |= 0x10;
            FacetInfo fi = rb._facetInfo;
            if (fi == null) {
                rb._facetInfo = fi = new FacetInfo();
                fi.parse(rb.req.getParams(), rb);
            }
            this.modifyRequestForFieldFacets(rb, sreq, fi);
            this.modifyRequestForPivotFacets(rb, sreq, fi.pivotFacets);
            sreq.params.remove("facet.mincount");
            sreq.params.remove("facet.offset");
        } else {
            sreq.params.set(COMPONENT_NAME, "false");
        }
    }

    private void modifyRequestForFieldFacets(ResponseBuilder rb, ShardRequest sreq, FacetInfo fi) {
        for (DistribFieldFacet dff : fi.facets.values()) {
            String paramStart = "f." + dff.field + '.';
            sreq.params.remove(paramStart + "facet.mincount");
            sreq.params.remove(paramStart + "facet.offset");
            int n = dff.initialLimit = dff.limit <= 0 ? dff.limit : dff.offset + dff.limit;
            if (dff.sort.equals("count")) {
                if (dff.limit > 0) {
                    dff.initialLimit = this.doOverRequestMath(dff.initialLimit, dff.overrequestRatio, dff.overrequestCount);
                    dff.initialMincount = 0;
                } else {
                    dff.initialMincount = Math.min(dff.minCount, 1);
                }
            } else {
                dff.initialMincount = dff.minCount <= 1 ? dff.minCount : (int)Math.ceil((double)dff.minCount / (double)rb.slices.length);
            }
            dff.initialLimit = rb.req.getParams().getInt("facet.shard.limit", dff.initialLimit);
            sreq.params.set(paramStart + "facet.limit", dff.initialLimit);
            sreq.params.set(paramStart + "facet.mincount", dff.initialMincount);
        }
    }

    private void modifyRequestForPivotFacets(ResponseBuilder rb, ShardRequest sreq, SimpleOrderedMap<PivotFacet> pivotFacets) {
        for (Map.Entry pfwEntry : pivotFacets) {
            PivotFacet pivot = (PivotFacet)pfwEntry.getValue();
            for (String pivotField : StrUtils.splitSmart(pivot.getKey(), ',')) {
                this.modifyRequestForIndividualPivotFacets(rb, sreq, pivotField);
            }
        }
    }

    private void modifyRequestForIndividualPivotFacets(ResponseBuilder rb, ShardRequest sreq, String fieldToOverRequest) {
        SolrParams originalParams = rb.req.getParams();
        String paramStart = "f." + fieldToOverRequest + ".";
        int requestedLimit = originalParams.getFieldInt(fieldToOverRequest, "facet.limit", 100);
        sreq.params.remove(paramStart + "facet.limit");
        int offset = originalParams.getFieldInt(fieldToOverRequest, "facet.offset", 0);
        sreq.params.remove(paramStart + "facet.offset");
        double overRequestRatio = originalParams.getFieldDouble(fieldToOverRequest, "facet.overrequest.ratio", 1.5);
        sreq.params.remove(paramStart + "facet.overrequest.ratio");
        int overRequestCount = originalParams.getFieldInt(fieldToOverRequest, "facet.overrequest.count", 10);
        sreq.params.remove(paramStart + "facet.overrequest.count");
        int requestedMinCount = originalParams.getFieldInt(fieldToOverRequest, "facet.pivot.mincount", 1);
        sreq.params.remove(paramStart + "facet.pivot.mincount");
        String defaultSort = requestedLimit > 0 ? "count" : "index";
        String sort = originalParams.getFieldParam(fieldToOverRequest, "facet.sort", defaultSort);
        int shardLimit = requestedLimit + offset;
        int shardMinCount = requestedMinCount;
        if ("index".equals(sort) && 1 < requestedMinCount && 0 < requestedLimit) {
            shardMinCount = (int)Math.ceil((double)requestedMinCount / (double)rb.slices.length);
            shardLimit = this.doOverRequestMath(shardLimit, overRequestRatio, overRequestCount);
        } else if ("count".equals(sort)) {
            if (0 < requestedLimit) {
                shardLimit = this.doOverRequestMath(shardLimit, overRequestRatio, overRequestCount);
                shardMinCount = 0;
            } else {
                shardMinCount = Math.min(requestedMinCount, 1);
            }
        }
        sreq.params.set(paramStart + "facet.limit", shardLimit);
        sreq.params.set(paramStart + "facet.pivot.mincount", shardMinCount);
    }

    private int doOverRequestMath(int limit, double ratio, int count) {
        int adjustedLimit = (int)((double)limit * ratio) + count;
        return Math.max(limit, adjustedLimit);
    }

    @Override
    public void handleResponses(ResponseBuilder rb, ShardRequest sreq) {
        if (!rb.doFacets) {
            return;
        }
        if ((sreq.purpose & 0x10) != 0) {
            this.countFacets(rb, sreq);
        } else {
            if ((sreq.purpose & 0x20) != 0) {
                this.refineFacets(rb, sreq);
            }
            if ((sreq.purpose & 0x2000) != 0) {
                this.refinePivotFacets(rb, sreq);
            }
        }
    }

    private void countFacets(ResponseBuilder rb, ShardRequest sreq) {
        FacetInfo fi = rb._facetInfo;
        for (ShardResponse shardResponse : sreq.responses) {
            NamedList facet_fields;
            int shardNum = rb.getShardNum(shardResponse.getShard());
            NamedList facet_counts = null;
            try {
                facet_counts = (NamedList)shardResponse.getSolrResponse().getResponse().get("facet_counts");
            }
            catch (Exception ex) {
                if (rb.req.getParams().getBool("shards.tolerant", false)) continue;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to read facet info for shard: " + shardResponse.getShard(), (Throwable)ex);
            }
            NamedList facet_queries = (NamedList)facet_counts.get("facet_queries");
            if (facet_queries != null) {
                for (int i = 0; i < facet_queries.size(); ++i) {
                    String returnedKey = facet_queries.getName(i);
                    long count = ((Number)facet_queries.getVal(i)).longValue();
                    QueryFacet qf = fi.queryFacets.get(returnedKey);
                    qf.count += count;
                }
            }
            if ((facet_fields = (NamedList)facet_counts.get("facet_fields")) != null) {
                for (DistribFieldFacet dff : fi.facets.values()) {
                    dff.add(shardNum, (NamedList)facet_fields.get(dff.getKey()), dff.initialLimit);
                }
            }
            this.doDistribDates(fi, facet_counts);
            this.doDistribRanges(fi, facet_counts);
            this.doDistribIntervals(fi, facet_counts);
            this.doDistribPivots(rb, shardNum, facet_counts);
        }
        for (Map.Entry entry : fi.pivotFacets) {
            ((PivotFacet)entry.getValue()).queuePivotRefinementRequests();
        }
        for (DistribFieldFacet distribFieldFacet : fi.facets.values()) {
            if (distribFieldFacet.initialLimit <= 0 && distribFieldFacet.initialMincount <= 1 || distribFieldFacet.minCount <= 1 && distribFieldFacet.sort.equals("index")) continue;
            List[] tmp = new List[rb.shards.length];
            distribFieldFacet._toRefine = tmp;
            ShardFacetCount[] counts = distribFieldFacet.getCountSorted();
            int ntop = Math.min(counts.length, distribFieldFacet.limit >= 0 ? distribFieldFacet.offset + distribFieldFacet.limit : Integer.MAX_VALUE);
            long smallestCount = counts.length == 0 ? 0L : counts[ntop - 1].count;
            for (int i = 0; i < counts.length; ++i) {
                ShardFacetCount sfc = counts[i];
                boolean needRefinement = false;
                if (i < ntop) {
                    needRefinement = true;
                } else {
                    long maxCount = sfc.count;
                    for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
                        FixedBitSet fbs = distribFieldFacet.counted[shardNum];
                        if (fbs == null || sfc.termNum < fbs.length() && fbs.get(sfc.termNum)) continue;
                        maxCount += distribFieldFacet.maxPossible(sfc, shardNum);
                    }
                    if (maxCount >= smallestCount) {
                        needRefinement = true;
                    }
                }
                if (!needRefinement) continue;
                for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
                    FixedBitSet fbs = distribFieldFacet.counted[shardNum];
                    if (fbs == null || sfc.termNum < fbs.length() && fbs.get(sfc.termNum) || distribFieldFacet.maxPossible(sfc, shardNum) <= 0L) continue;
                    distribFieldFacet.needRefinements = true;
                    List<String> lst = distribFieldFacet._toRefine[shardNum];
                    if (lst == null) {
                        lst = distribFieldFacet._toRefine[shardNum] = new ArrayList<String>();
                    }
                    lst.add(sfc.name);
                }
            }
        }
    }

    private void doDistribIntervals(FacetInfo fi, NamedList facet_counts) {
        SimpleOrderedMap facet_intervals = (SimpleOrderedMap)facet_counts.get("facet_intervals");
        if (facet_intervals != null) {
            for (Map.Entry entry : facet_intervals) {
                String field = entry.getKey();
                SimpleOrderedMap existingCounts = (SimpleOrderedMap)fi.intervalFacets.get(field);
                if (existingCounts == null) {
                    fi.intervalFacets.add(field, (SimpleOrderedMap<Integer>)entry.getValue());
                    continue;
                }
                Iterator newItr = ((SimpleOrderedMap)entry.getValue()).iterator();
                for (Map.Entry exItem : existingCounts) {
                    if (!newItr.hasNext()) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interval facet shard response missing key: " + exItem.getKey());
                    }
                    Map.Entry newItem = newItr.next();
                    if (!newItem.getKey().equals(exItem.getKey())) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interval facet shard response has extra key: " + newItem.getKey());
                    }
                    exItem.setValue((Integer)exItem.getValue() + (Integer)newItem.getValue());
                }
                if (!newItr.hasNext()) continue;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interval facet shard response has at least one extra key: " + newItr.next().getKey());
            }
        }
    }

    private void doDistribRanges(FacetInfo fi, NamedList facet_counts) {
        SimpleOrderedMap facet_ranges = (SimpleOrderedMap)facet_counts.get("facet_ranges");
        if (facet_ranges != null) {
            for (Map.Entry entry : facet_ranges) {
                String field = entry.getKey();
                if (fi.rangeFacets.get(field) == null) {
                    fi.rangeFacets.add(field, (SimpleOrderedMap<Object>)entry.getValue());
                    continue;
                }
                NamedList shardFieldValues = (NamedList)((SimpleOrderedMap)entry.getValue()).get("counts");
                NamedList existFieldValues = (NamedList)((SimpleOrderedMap)fi.rangeFacets.get(field)).get("counts");
                for (Map.Entry existPair : existFieldValues) {
                    String key = existPair.getKey();
                    Integer newValue = (Integer)shardFieldValues.get(key);
                    if (null == newValue) continue;
                    Integer oldValue = (Integer)existPair.getValue();
                    existPair.setValue(oldValue + newValue);
                }
            }
        }
    }

    private void doDistribDates(FacetInfo fi, NamedList facet_counts) {
        SimpleOrderedMap facet_dates = (SimpleOrderedMap)facet_counts.get("facet_dates");
        if (facet_dates != null) {
            for (Map.Entry entry : facet_dates) {
                String field = entry.getKey();
                if (fi.dateFacets.get(field) == null) {
                    fi.dateFacets.add(field, (SimpleOrderedMap<Object>)entry.getValue());
                    continue;
                }
                SimpleOrderedMap shardFieldValues = (SimpleOrderedMap)entry.getValue();
                SimpleOrderedMap existFieldValues = (SimpleOrderedMap)fi.dateFacets.get(field);
                for (Map.Entry existPair : existFieldValues) {
                    Integer newValue;
                    String key = existPair.getKey();
                    if (key.equals("gap") || key.equals("end") || key.equals("start") || null == (newValue = (Integer)shardFieldValues.get(key))) continue;
                    Integer oldValue = (Integer)existPair.getValue();
                    existPair.setValue(oldValue + newValue);
                }
            }
        }
    }

    private void doDistribPivots(ResponseBuilder rb, int shardNum, NamedList facet_counts) {
        SimpleOrderedMap facet_pivot = (SimpleOrderedMap)facet_counts.get(PIVOT_KEY);
        if (facet_pivot != null) {
            for (Map.Entry pivot : facet_pivot) {
                String pivotName = pivot.getKey();
                PivotFacet facet = (PivotFacet)rb._facetInfo.pivotFacets.get(pivotName);
                facet.mergeResponseFromShard(shardNum, rb, (List)pivot.getValue());
            }
        }
    }

    private void refineFacets(ResponseBuilder rb, ShardRequest sreq) {
        FacetInfo fi = rb._facetInfo;
        for (ShardResponse srsp : sreq.responses) {
            NamedList facet_counts = (NamedList)srsp.getSolrResponse().getResponse().get("facet_counts");
            NamedList facet_fields = (NamedList)facet_counts.get("facet_fields");
            if (facet_fields == null) continue;
            for (int i = 0; i < facet_fields.size(); ++i) {
                String key = facet_fields.getName(i);
                DistribFieldFacet dff = fi.facets.get(key);
                if (dff == null) continue;
                NamedList shardCounts = (NamedList)facet_fields.getVal(i);
                for (int j = 0; j < shardCounts.size(); ++j) {
                    String name = shardCounts.getName(j);
                    long count = ((Number)shardCounts.getVal(j)).longValue();
                    ShardFacetCount sfc = dff.counts.get(name);
                    if (sfc == null) {
                        log.error("Unexpected term returned for facet refining. key=" + key + " term='" + name + "'" + "\n\trequest params=" + sreq.params + "\n\ttoRefine=" + dff._toRefine + "\n\tresponse=" + shardCounts);
                        continue;
                    }
                    sfc.count += count;
                }
            }
        }
    }

    private void refinePivotFacets(ResponseBuilder rb, ShardRequest sreq) {
        FacetInfo fi = rb._facetInfo;
        for (ShardResponse shardResponse : sreq.responses) {
            int shardNumber = rb.getShardNum(shardResponse.getShard());
            NamedList facetCounts = (NamedList)shardResponse.getSolrResponse().getResponse().get("facet_counts");
            NamedList pivotFacetResponsesFromShard = (NamedList)facetCounts.get(PIVOT_KEY);
            if (null == pivotFacetResponsesFromShard) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No pivot refinement response from shard: " + shardResponse.getShard());
            }
            for (Map.Entry pivotFacetResponseFromShard : pivotFacetResponsesFromShard) {
                PivotFacet masterPivotFacet = (PivotFacet)fi.pivotFacets.get(pivotFacetResponseFromShard.getKey());
                masterPivotFacet.mergeResponseFromShard(shardNumber, rb, (List)pivotFacetResponseFromShard.getValue());
                masterPivotFacet.removeAllRefinementsForShard(shardNumber);
            }
        }
        if (this.allPivotFacetsAreFullyRefined(fi)) {
            for (Map.Entry entry : fi.pivotFacets) {
                ((PivotFacet)entry.getValue()).queuePivotRefinementRequests();
            }
            this.reQueuePivotFacetShardRequests(rb);
        }
    }

    private boolean allPivotFacetsAreFullyRefined(FacetInfo fi) {
        for (Map.Entry pf : fi.pivotFacets) {
            if (!((PivotFacet)pf.getValue()).isRefinementsRequired()) continue;
            return false;
        }
        return true;
    }

    private boolean doAnyPivotFacetRefinementRequestsExistForShard(FacetInfo fi, int shardNum) {
        for (int i = 0; i < fi.pivotFacets.size(); ++i) {
            PivotFacet pf = (PivotFacet)fi.pivotFacets.getVal(i);
            if (pf.getQueuedRefinements(shardNum).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void reQueuePivotFacetShardRequests(ResponseBuilder rb) {
        for (int shardNum = 0; shardNum < rb.shards.length; ++shardNum) {
            if (!this.doAnyPivotFacetRefinementRequestsExistForShard(rb._facetInfo, shardNum)) continue;
            this.enqueuePivotFacetShardRequests(null, rb, shardNum);
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        this.pivotRefinementCounter = 0;
        if (!rb.doFacets || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        FacetInfo fi = rb._facetInfo;
        SimpleOrderedMap facet_counts = new SimpleOrderedMap();
        SimpleOrderedMap<Number> facet_queries = new SimpleOrderedMap<Number>();
        facet_counts.add("facet_queries", facet_queries);
        for (QueryFacet qf : fi.queryFacets.values()) {
            facet_queries.add(qf.getKey(), this.num(qf.count));
        }
        SimpleOrderedMap facet_fields = new SimpleOrderedMap();
        facet_counts.add("facet_fields", facet_fields);
        for (DistribFieldFacet dff : fi.facets.values()) {
            ShardFacetCount[] counts;
            NamedList<Number> fieldCounts = new NamedList<Number>();
            facet_fields.add(dff.getKey(), fieldCounts);
            boolean countSorted = dff.sort.equals("count");
            if (countSorted) {
                counts = dff.countSorted;
                if (counts == null || dff.needRefinements) {
                    counts = dff.getCountSorted();
                }
            } else {
                counts = dff.sort.equals("index") ? dff.getLexSorted() : dff.getLexSorted();
            }
            if (countSorted) {
                int end = dff.limit < 0 ? counts.length : Math.min(dff.offset + dff.limit, counts.length);
                for (int i = dff.offset; i < end && counts[i].count >= (long)dff.minCount; ++i) {
                    fieldCounts.add(counts[i].name, this.num(counts[i].count));
                }
            } else {
                int off = dff.offset;
                int lim = dff.limit >= 0 ? dff.limit : Integer.MAX_VALUE;
                for (int i = 0; i < counts.length; ++i) {
                    long count = counts[i].count;
                    if (count < (long)dff.minCount) continue;
                    if (off > 0) {
                        --off;
                        continue;
                    }
                    if (lim > 0) {
                        --lim;
                        fieldCounts.add(counts[i].name, this.num(count));
                        continue;
                    }
                    break;
                }
            }
            if (!dff.missing) continue;
            fieldCounts.add(null, this.num(dff.missingCount));
        }
        facet_counts.add("facet_dates", fi.dateFacets);
        facet_counts.add("facet_ranges", fi.rangeFacets);
        facet_counts.add("facet_intervals", fi.intervalFacets);
        if (fi.pivotFacets != null && fi.pivotFacets.size() > 0) {
            facet_counts.add(PIVOT_KEY, this.createPivotFacetOutput(rb));
        }
        rb.rsp.add("facet_counts", facet_counts);
        rb._facetInfo = null;
    }

    private SimpleOrderedMap<List<NamedList<Object>>> createPivotFacetOutput(ResponseBuilder rb) {
        SimpleOrderedMap<List<NamedList<Object>>> combinedPivotFacets = new SimpleOrderedMap<List<NamedList<Object>>>();
        for (Map.Entry entry : rb._facetInfo.pivotFacets) {
            String key = entry.getKey();
            PivotFacet pivot = (PivotFacet)entry.getValue();
            List<NamedList<Object>> trimmedPivots = pivot.getTrimmedPivotsAsListOfNamedLists(rb);
            if (null == trimmedPivots) {
                trimmedPivots = Collections.emptyList();
            }
            combinedPivotFacets.add(key, trimmedPivots);
        }
        return combinedPivotFacets;
    }

    private Number num(long val) {
        if (val < Integer.MAX_VALUE) {
            return (int)val;
        }
        return val;
    }

    private Number num(Long val) {
        if (val < Integer.MAX_VALUE) {
            return val.intValue();
        }
        return val;
    }

    @Override
    public String getDescription() {
        return "Handle Faceting";
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public URL[] getDocs() {
        return null;
    }

    public static class ShardFacetCount {
        public String name;
        public String indexed;
        public long count;
        public int termNum;

        public String toString() {
            return "{term=" + this.name + ",termNum=" + this.termNum + ",count=" + this.count + "}";
        }
    }

    public static class DistribFieldFacet
    extends FieldFacet {
        public List<String>[] _toRefine;
        public long missingMaxPossible;
        public long[] missingMax;
        public FixedBitSet[] counted;
        public HashMap<String, ShardFacetCount> counts = new HashMap(128);
        public int termNum;
        public int initialLimit;
        public int initialMincount;
        public double overrequestRatio;
        public int overrequestCount;
        public boolean needRefinements;
        public ShardFacetCount[] countSorted;

        DistribFieldFacet(ResponseBuilder rb, String facetStr) {
            super(rb, facetStr);
            this.missingMax = new long[rb.shards.length];
            this.counted = new FixedBitSet[rb.shards.length];
        }

        @Override
        protected void fillParams(ResponseBuilder rb, SolrParams params, String field) {
            super.fillParams(rb, params, field);
            this.overrequestRatio = params.getFieldDouble(field, "facet.overrequest.ratio", 1.5);
            this.overrequestCount = params.getFieldInt(field, "facet.overrequest.count", 10);
        }

        void add(int shardNum, NamedList shardCounts, int numRequested) {
            int sz;
            int numReceived = sz = shardCounts == null ? 0 : shardCounts.size();
            FixedBitSet terms = new FixedBitSet(this.termNum + sz);
            long last = 0L;
            for (int i = 0; i < sz; ++i) {
                String name = shardCounts.getName(i);
                long count = ((Number)shardCounts.getVal(i)).longValue();
                if (name == null) {
                    this.missingCount += count;
                    --numReceived;
                    continue;
                }
                ShardFacetCount sfc = this.counts.get(name);
                if (sfc == null) {
                    sfc = new ShardFacetCount();
                    sfc.name = name;
                    sfc.indexed = this.ftype == null ? sfc.name : this.ftype.toInternal(sfc.name);
                    ++this.termNum;
                    sfc.termNum = sfc.termNum;
                    this.counts.put(name, sfc);
                }
                sfc.count += count;
                terms.set(sfc.termNum);
                last = count;
            }
            if (numRequested < 0 || numRequested != 0 && numReceived < numRequested) {
                last = this.initialMincount;
            }
            this.missingMaxPossible += last;
            this.missingMax[shardNum] = last;
            this.counted[shardNum] = terms;
        }

        public ShardFacetCount[] getLexSorted() {
            ShardFacetCount[] arr = this.counts.values().toArray(new ShardFacetCount[this.counts.size()]);
            Arrays.sort(arr, new Comparator<ShardFacetCount>(){

                @Override
                public int compare(ShardFacetCount o1, ShardFacetCount o2) {
                    return o1.indexed.compareTo(o2.indexed);
                }
            });
            this.countSorted = arr;
            return arr;
        }

        public ShardFacetCount[] getCountSorted() {
            ShardFacetCount[] arr = this.counts.values().toArray(new ShardFacetCount[this.counts.size()]);
            Arrays.sort(arr, new Comparator<ShardFacetCount>(){

                @Override
                public int compare(ShardFacetCount o1, ShardFacetCount o2) {
                    if (o2.count < o1.count) {
                        return -1;
                    }
                    if (o1.count < o2.count) {
                        return 1;
                    }
                    return o1.indexed.compareTo(o2.indexed);
                }
            });
            this.countSorted = arr;
            return arr;
        }

        long maxPossible(ShardFacetCount sfc, int shardNum) {
            return this.missingMax[shardNum];
        }
    }

    public static class FieldFacet
    extends FacetBase {
        public String field;
        public FieldType ftype;
        public int offset;
        public int limit;
        public int minCount;
        public String sort;
        public boolean missing;
        public String prefix;
        public long missingCount;

        public FieldFacet(ResponseBuilder rb, String facetStr) {
            super(rb, "facet.field", facetStr);
            this.fillParams(rb, rb.req.getParams(), this.facetOn);
        }

        protected void fillParams(ResponseBuilder rb, SolrParams params, String field) {
            this.field = field;
            this.ftype = rb.req.getSchema().getFieldTypeNoEx(this.field);
            this.offset = params.getFieldInt(field, "facet.offset", 0);
            this.limit = params.getFieldInt(field, "facet.limit", 100);
            Integer mincount = params.getFieldInt(field, "facet.mincount");
            if (mincount == null) {
                Boolean zeros = params.getFieldBool(field, "facet.zeros");
                mincount = zeros != null && zeros == false ? 1 : 0;
            }
            this.minCount = mincount;
            this.missing = params.getFieldBool(field, "facet.missing", false);
            this.sort = params.getFieldParam(field, "facet.sort", this.limit > 0 ? "count" : "index");
            if (this.sort.equals("true")) {
                this.sort = "count";
            } else if (this.sort.equals("false")) {
                this.sort = "index";
            }
            this.prefix = params.getFieldParam(field, "facet.prefix");
        }
    }

    public static class QueryFacet
    extends FacetBase {
        public long count;

        public QueryFacet(ResponseBuilder rb, String facetStr) {
            super(rb, "facet.query", facetStr);
        }
    }

    public static class FacetBase {
        String facetType;
        String facetStr;
        String facetOn;
        private String key;
        SolrParams localParams;

        public FacetBase(ResponseBuilder rb, String facetType, String facetStr) {
            this.facetType = facetType;
            this.facetStr = facetStr;
            try {
                this.localParams = QueryParsing.getLocalParams(facetStr, rb.req.getParams());
            }
            catch (SyntaxError e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            this.facetOn = facetStr;
            this.key = facetStr;
            if (this.localParams != null) {
                if (!facetType.equals("facet.query")) {
                    this.key = this.facetOn = this.localParams.get("v");
                }
                this.key = this.localParams.get("key", this.key);
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getType() {
            return this.facetType;
        }
    }

    public static class FacetInfo {
        public LinkedHashMap<String, QueryFacet> queryFacets;
        public LinkedHashMap<String, DistribFieldFacet> facets;
        public SimpleOrderedMap<SimpleOrderedMap<Object>> dateFacets = new SimpleOrderedMap();
        public SimpleOrderedMap<SimpleOrderedMap<Object>> rangeFacets = new SimpleOrderedMap();
        public SimpleOrderedMap<SimpleOrderedMap<Integer>> intervalFacets = new SimpleOrderedMap();
        public SimpleOrderedMap<PivotFacet> pivotFacets = new SimpleOrderedMap();

        void parse(SolrParams params, ResponseBuilder rb) {
            String[] facetPFs;
            String[] facetFs;
            this.queryFacets = new LinkedHashMap();
            this.facets = new LinkedHashMap();
            String[] facetQs = params.getParams("facet.query");
            if (facetQs != null) {
                for (String query : facetQs) {
                    QueryFacet queryFacet = new QueryFacet(rb, query);
                    this.queryFacets.put(queryFacet.getKey(), queryFacet);
                }
            }
            if ((facetFs = params.getParams("facet.field")) != null) {
                for (String field : facetFs) {
                    DistribFieldFacet ff = new DistribFieldFacet(rb, field);
                    this.facets.put(ff.getKey(), ff);
                }
            }
            if ((facetPFs = params.getParams("facet.pivot")) != null) {
                for (String fieldGroup : facetPFs) {
                    PivotFacet pf = new PivotFacet(rb, fieldGroup);
                    this.pivotFacets.add(pf.getKey(), pf);
                }
            }
        }
    }
}

