/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.PriorityQueue;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.luke.FieldFlag;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LukeRequestHandler
extends RequestHandlerBase {
    private static Logger log = LoggerFactory.getLogger(LukeRequestHandler.class);
    public static final String NUMTERMS = "numTerms";
    public static final String DOC_ID = "docId";
    public static final String ID = "id";
    public static final int DEFAULT_COUNT = 10;
    static final int HIST_ARRAY_SIZE = 33;

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        IndexSchema schema = req.getSchema();
        SolrIndexSearcher searcher = req.getSearcher();
        DirectoryReader reader = searcher.getIndexReader();
        SolrParams params = req.getParams();
        ShowStyle style = ShowStyle.get(params.get("show"));
        rsp.add("index", LukeRequestHandler.getIndexInfo(reader));
        if (ShowStyle.INDEX == style) {
            return;
        }
        Integer docId = params.getInt(DOC_ID);
        if (docId == null && params.get(ID) != null) {
            SchemaField uniqueKey = schema.getUniqueKeyField();
            String v = uniqueKey.getType().toInternal(params.get(ID));
            Term t = new Term(uniqueKey.getName(), v);
            docId = searcher.getFirstMatch(t);
            if (docId < 0) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can't find document: " + params.get(ID));
            }
        }
        if (docId != null) {
            if (style != null && style != ShowStyle.DOC) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing doc param for doc style");
            }
            Document doc = null;
            try {
                doc = reader.document(docId);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (doc == null) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Can't find document: " + docId);
            }
            SimpleOrderedMap<Object> info = LukeRequestHandler.getDocumentFieldsInfo(doc, docId, reader, schema);
            SimpleOrderedMap<Object> docinfo = new SimpleOrderedMap<Object>();
            docinfo.add(DOC_ID, docId);
            docinfo.add("lucene", info);
            docinfo.add("solr", doc);
            rsp.add("doc", docinfo);
        } else if (ShowStyle.SCHEMA == style) {
            rsp.add("schema", LukeRequestHandler.getSchemaInfo(req.getSchema()));
        } else {
            rsp.add("fields", LukeRequestHandler.getIndexedFieldsInfo(req));
        }
        SimpleOrderedMap<Object> info = new SimpleOrderedMap<Object>();
        info.add("key", LukeRequestHandler.getFieldFlagsKey());
        info.add("NOTE", "Document Frequency (df) is not updated when a document is marked for deletion.  df values include deleted documents.");
        rsp.add("info", info);
        rsp.setHttpCaching(false);
    }

    private static String getFieldFlags(IndexableField f) {
        FieldInfo.IndexOptions opts = f == null ? null : f.fieldType().indexOptions();
        StringBuilder flags = new StringBuilder();
        flags.append(f != null && f.fieldType().indexed() ? FieldFlag.INDEXED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().tokenized() ? FieldFlag.TOKENIZED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().stored() ? FieldFlag.STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().docValueType() != null ? Character.valueOf(FieldFlag.DOC_VALUES.getAbbreviation()) : "-");
        flags.append('-');
        flags.append(f != null && f.fieldType().storeTermVectors() ? FieldFlag.TERM_VECTOR_STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().storeTermVectorOffsets() ? FieldFlag.TERM_VECTOR_OFFSET.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().storeTermVectorPositions() ? FieldFlag.TERM_VECTOR_POSITION.getAbbreviation() : (char)'-');
        flags.append(f != null && f.fieldType().omitNorms() ? FieldFlag.OMIT_NORMS.getAbbreviation() : (char)'-');
        flags.append(f != null && FieldInfo.IndexOptions.DOCS_ONLY == opts ? FieldFlag.OMIT_TF.getAbbreviation() : (char)'-');
        flags.append(f != null && FieldInfo.IndexOptions.DOCS_AND_FREQS == opts ? FieldFlag.OMIT_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(f != null && FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS == opts ? FieldFlag.STORE_OFFSETS_WITH_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.getClass().getSimpleName().equals("LazyField") ? FieldFlag.LAZY.getAbbreviation() : (char)'-');
        flags.append(f != null && f.binaryValue() != null ? FieldFlag.BINARY.getAbbreviation() : (char)'-');
        flags.append('-');
        flags.append('-');
        return flags.toString();
    }

    private static String getFieldFlags(SchemaField f) {
        FieldType t = f == null ? null : f.getType();
        boolean lazy = false;
        boolean binary = false;
        StringBuilder flags = new StringBuilder();
        flags.append(f != null && f.indexed() ? FieldFlag.INDEXED.getAbbreviation() : (char)'-');
        flags.append(t != null && t.isTokenized() ? FieldFlag.TOKENIZED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.stored() ? FieldFlag.STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.hasDocValues() ? Character.valueOf(FieldFlag.DOC_VALUES.getAbbreviation()) : "-");
        flags.append(f != null && f.multiValued() ? FieldFlag.MULTI_VALUED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermVector() ? FieldFlag.TERM_VECTOR_STORED.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermOffsets() ? FieldFlag.TERM_VECTOR_OFFSET.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeTermPositions() ? FieldFlag.TERM_VECTOR_POSITION.getAbbreviation() : (char)'-');
        flags.append(f != null && f.omitNorms() ? FieldFlag.OMIT_NORMS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.omitTermFreqAndPositions() ? FieldFlag.OMIT_TF.getAbbreviation() : (char)'-');
        flags.append(f != null && f.omitPositions() ? FieldFlag.OMIT_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(f != null && f.storeOffsetsWithPositions() ? FieldFlag.STORE_OFFSETS_WITH_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(lazy ? (char)FieldFlag.LAZY.getAbbreviation() : (char)'-');
        flags.append(binary ? (char)FieldFlag.BINARY.getAbbreviation() : (char)'-');
        flags.append(f != null && f.sortMissingFirst() ? FieldFlag.SORT_MISSING_FIRST.getAbbreviation() : (char)'-');
        flags.append(f != null && f.sortMissingLast() ? FieldFlag.SORT_MISSING_LAST.getAbbreviation() : (char)'-');
        return flags.toString();
    }

    public static SimpleOrderedMap<String> getFieldFlagsKey() {
        SimpleOrderedMap<String> key = new SimpleOrderedMap<String>();
        for (FieldFlag f : FieldFlag.values()) {
            key.add(String.valueOf(f.getAbbreviation()), f.getDisplay());
        }
        return key;
    }

    private static SimpleOrderedMap<Object> getDocumentFieldsInfo(Document doc, int docId, IndexReader reader, IndexSchema schema) throws IOException {
        CharsRefBuilder spare = new CharsRefBuilder();
        SimpleOrderedMap<Object> finfo = new SimpleOrderedMap<Object>();
        for (IndexableField o : doc.getFields()) {
            Field field = (Field)o;
            SimpleOrderedMap<Object> f = new SimpleOrderedMap<Object>();
            SchemaField sfield = schema.getFieldOrNull(field.name());
            FieldType ftype = sfield == null ? null : sfield.getType();
            f.add("type", ftype == null ? null : ftype.getTypeName());
            f.add("schema", LukeRequestHandler.getFieldFlags(sfield));
            f.add("flags", LukeRequestHandler.getFieldFlags(field));
            Term t = new Term(field.name(), ftype != null ? ftype.storedToIndexed(field) : field.stringValue());
            f.add("value", ftype == null ? null : ftype.toExternal(field));
            f.add("internal", field.stringValue());
            BytesRef bytes = field.binaryValue();
            if (bytes != null) {
                f.add("binary", Base64.byteArrayToBase64(bytes.bytes, bytes.offset, bytes.length));
            }
            f.add("boost", Float.valueOf(field.boost()));
            f.add("docFreq", t.text() == null ? 0 : reader.docFreq(t));
            if (field.fieldType().storeTermVectors()) {
                try {
                    Terms v = reader.getTermVector(docId, field.name());
                    if (v != null) {
                        BytesRef text;
                        SimpleOrderedMap<Integer> tfv = new SimpleOrderedMap<Integer>();
                        TermsEnum termsEnum = v.iterator(null);
                        while ((text = termsEnum.next()) != null) {
                            int freq = (int)termsEnum.totalTermFreq();
                            spare.copyUTF8Bytes(text);
                            tfv.add(spare.toString(), freq);
                        }
                        f.add("termVector", tfv);
                    }
                }
                catch (Exception ex) {
                    log.warn("error writing term vector", ex);
                }
            }
            finfo.add(field.name(), f);
        }
        return finfo;
    }

    private static SimpleOrderedMap<Object> getIndexedFieldsInfo(SolrQueryRequest req) throws Exception {
        SolrIndexSearcher searcher = req.getSearcher();
        SolrParams params = req.getParams();
        TreeSet<String> fields = null;
        String fl = params.get("fl");
        if (fl != null) {
            fields = new TreeSet<String>(Arrays.asList(fl.split("[,\\s]+")));
        }
        AtomicReader reader = searcher.getAtomicReader();
        IndexSchema schema = searcher.getSchema();
        TreeSet<String> fieldNames = new TreeSet<String>();
        for (FieldInfo fieldInfo : reader.getFieldInfos()) {
            fieldNames.add(fieldInfo.name);
        }
        SimpleOrderedMap<Object> finfo = new SimpleOrderedMap<Object>();
        for (String fieldName : fieldNames) {
            Terms terms;
            if (fields != null && !fields.contains(fieldName) && !fields.contains("*")) continue;
            SimpleOrderedMap<Object> fieldMap = new SimpleOrderedMap<Object>();
            SchemaField sfield = schema.getFieldOrNull(fieldName);
            FieldType ftype = sfield == null ? null : sfield.getType();
            fieldMap.add("type", ftype == null ? null : ftype.getTypeName());
            fieldMap.add("schema", LukeRequestHandler.getFieldFlags(sfield));
            if (sfield != null && schema.isDynamicField(sfield.getName()) && schema.getDynamicPattern(sfield.getName()) != null) {
                fieldMap.add("dynamicBase", schema.getDynamicPattern(sfield.getName()));
            }
            if ((terms = reader.fields().terms(fieldName)) == null) {
                finfo.add(fieldName, fieldMap);
                continue;
            }
            if (sfield != null && sfield.indexed()) {
                Document doc = LukeRequestHandler.getFirstLiveDoc(terms, reader);
                if (doc != null) {
                    try {
                        IndexableField fld = doc.getField(fieldName);
                        if (fld != null) {
                            fieldMap.add("index", LukeRequestHandler.getFieldFlags(fld));
                        } else {
                            fieldMap.add("index", "(unstored field)");
                        }
                    }
                    catch (Exception ex) {
                        log.warn("error reading field: " + fieldName);
                    }
                }
                fieldMap.add("docs", terms.getDocCount());
            }
            if (fields != null && (fields.contains(fieldName) || fields.contains("*"))) {
                LukeRequestHandler.getDetailedFieldInfo(req, fieldName, fieldMap);
            }
            finfo.add(fieldName, fieldMap);
        }
        return finfo;
    }

    private static Document getFirstLiveDoc(Terms terms, AtomicReader reader) throws IOException {
        DocsEnum docsEnum = null;
        TermsEnum termsEnum = terms.iterator(null);
        for (int idx = 0; idx < 1000 && docsEnum == null; ++idx) {
            BytesRef text = termsEnum.next();
            if (text == null) {
                return null;
            }
            docsEnum = termsEnum.docs(reader.getLiveDocs(), docsEnum, 0);
            if (docsEnum.nextDoc() == Integer.MAX_VALUE) continue;
            return reader.document(docsEnum.docID());
        }
        return null;
    }

    private static SimpleOrderedMap<Object> getSchemaInfo(IndexSchema schema) {
        TreeMap<String, List<String>> typeusemap = new TreeMap<String, List<String>>();
        TreeMap<String, Object> fields = new TreeMap<String, Object>();
        SchemaField uniqueField = schema.getUniqueKeyField();
        for (SchemaField f : schema.getFields().values()) {
            LukeRequestHandler.populateFieldInfo(schema, typeusemap, fields, uniqueField, f);
        }
        TreeMap<String, Object> dynamicFields = new TreeMap<String, Object>();
        for (SchemaField f : schema.getDynamicFieldPrototypes()) {
            LukeRequestHandler.populateFieldInfo(schema, typeusemap, dynamicFields, uniqueField, f);
        }
        SimpleOrderedMap types = new SimpleOrderedMap();
        TreeMap<String, FieldType> sortedTypes = new TreeMap<String, FieldType>(schema.getFieldTypes());
        for (FieldType ft : sortedTypes.values()) {
            SimpleOrderedMap<Object> field = new SimpleOrderedMap<Object>();
            field.add("fields", typeusemap.get(ft.getTypeName()));
            field.add("tokenized", ft.isTokenized());
            field.add("className", ft.getClass().getName());
            field.add("indexAnalyzer", LukeRequestHandler.getAnalyzerInfo(ft.getIndexAnalyzer()));
            field.add("queryAnalyzer", LukeRequestHandler.getAnalyzerInfo(ft.getQueryAnalyzer()));
            field.add("similarity", LukeRequestHandler.getSimilarityInfo(ft.getSimilarity()));
            types.add(ft.getTypeName(), field);
        }
        SimpleOrderedMap<Object> finfo = new SimpleOrderedMap<Object>();
        SimpleOrderedMap fieldsSimple = new SimpleOrderedMap();
        for (Map.Entry ent : fields.entrySet()) {
            fieldsSimple.add((String)ent.getKey(), ent.getValue());
        }
        finfo.add("fields", fieldsSimple);
        SimpleOrderedMap dynamicSimple = new SimpleOrderedMap();
        for (Map.Entry ent : dynamicFields.entrySet()) {
            dynamicSimple.add((String)ent.getKey(), ent.getValue());
        }
        finfo.add("dynamicFields", dynamicSimple);
        finfo.add("uniqueKeyField", null == uniqueField ? null : uniqueField.getName());
        finfo.add("defaultSearchField", schema.getDefaultSearchFieldName());
        finfo.add("types", types);
        return finfo;
    }

    private static SimpleOrderedMap<Object> getSimilarityInfo(Similarity similarity) {
        SimpleOrderedMap<Object> toReturn = new SimpleOrderedMap<Object>();
        if (similarity != null) {
            toReturn.add("className", similarity.getClass().getName());
            toReturn.add("details", similarity.toString());
        }
        return toReturn;
    }

    private static SimpleOrderedMap<Object> getAnalyzerInfo(Analyzer analyzer) {
        SimpleOrderedMap<Object> aninfo = new SimpleOrderedMap<Object>();
        aninfo.add("className", analyzer.getClass().getName());
        if (analyzer instanceof TokenizerChain) {
            TokenizerChain tchain = (TokenizerChain)analyzer;
            CharFilterFactory[] cfiltfacs = tchain.getCharFilterFactories();
            SimpleOrderedMap cfilters = new SimpleOrderedMap();
            for (CharFilterFactory cfiltfac : cfiltfacs) {
                HashMap<String, Object> tok = new HashMap<String, Object>();
                String className = cfiltfac.getClass().getName();
                tok.put("className", className);
                tok.put("args", cfiltfac.getOriginalArgs());
                cfilters.add(className.substring(className.lastIndexOf(46) + 1), tok);
            }
            if (cfilters.size() > 0) {
                aninfo.add("charFilters", cfilters);
            }
            SimpleOrderedMap<Object> tokenizer = new SimpleOrderedMap<Object>();
            TokenizerFactory tfac = tchain.getTokenizerFactory();
            tokenizer.add("className", tfac.getClass().getName());
            tokenizer.add("args", tfac.getOriginalArgs());
            aninfo.add("tokenizer", tokenizer);
            TokenFilterFactory[] filtfacs = tchain.getTokenFilterFactories();
            SimpleOrderedMap filters = new SimpleOrderedMap();
            for (TokenFilterFactory filtfac : filtfacs) {
                HashMap<String, Object> tok = new HashMap<String, Object>();
                String className = filtfac.getClass().getName();
                tok.put("className", className);
                tok.put("args", filtfac.getOriginalArgs());
                filters.add(className.substring(className.lastIndexOf(46) + 1), tok);
            }
            if (filters.size() > 0) {
                aninfo.add("filters", filters);
            }
        }
        return aninfo;
    }

    private static void populateFieldInfo(IndexSchema schema, Map<String, List<String>> typeusemap, Map<String, Object> fields, SchemaField uniqueField, SchemaField f) {
        FieldType ft = f.getType();
        SimpleOrderedMap<Object> field = new SimpleOrderedMap<Object>();
        field.add("type", ft.getTypeName());
        field.add("flags", LukeRequestHandler.getFieldFlags(f));
        if (f.isRequired()) {
            field.add("required", f.isRequired());
        }
        if (f.getDefaultValue() != null) {
            field.add("default", f.getDefaultValue());
        }
        if (f == uniqueField) {
            field.add("uniqueKey", true);
        }
        if (ft.getIndexAnalyzer().getPositionIncrementGap(f.getName()) != 0) {
            field.add("positionIncrementGap", ft.getIndexAnalyzer().getPositionIncrementGap(f.getName()));
        }
        field.add("copyDests", LukeRequestHandler.toListOfStringDests(schema.getCopyFieldsList(f.getName())));
        field.add("copySources", schema.getCopySources(f.getName()));
        fields.put(f.getName(), field);
        List<String> v = typeusemap.get(ft.getTypeName());
        if (v == null) {
            v = new ArrayList<String>();
        }
        v.add(f.getName());
        typeusemap.put(ft.getTypeName(), v);
    }

    public static SimpleOrderedMap<Object> getIndexInfo(DirectoryReader reader, boolean detail) throws IOException {
        return LukeRequestHandler.getIndexInfo(reader);
    }

    public static SimpleOrderedMap<Object> getIndexInfo(DirectoryReader reader) throws IOException {
        Directory dir = reader.directory();
        SimpleOrderedMap<Object> indexInfo = new SimpleOrderedMap<Object>();
        indexInfo.add("numDocs", reader.numDocs());
        indexInfo.add("maxDoc", reader.maxDoc());
        indexInfo.add("deletedDocs", reader.maxDoc() - reader.numDocs());
        indexInfo.add("indexHeapUsageBytes", LukeRequestHandler.getIndexHeapUsed(reader));
        indexInfo.add("version", reader.getVersion());
        indexInfo.add("segmentCount", reader.leaves().size());
        indexInfo.add("current", reader.isCurrent());
        indexInfo.add("hasDeletions", reader.hasDeletions());
        indexInfo.add("directory", dir);
        indexInfo.add("userData", reader.getIndexCommit().getUserData());
        String s = reader.getIndexCommit().getUserData().get("commitTimeMSec");
        if (s != null) {
            indexInfo.add("lastModified", new Date(Long.parseLong(s)));
        }
        return indexInfo;
    }

    private static long getIndexHeapUsed(DirectoryReader reader) {
        long indexHeapRamBytesUsed = 0L;
        for (AtomicReaderContext atomicReaderContext : reader.leaves()) {
            AtomicReader atomicReader = atomicReaderContext.reader();
            if (atomicReader instanceof SegmentReader) {
                indexHeapRamBytesUsed += ((SegmentReader)atomicReader).ramBytesUsed();
                continue;
            }
            return -1L;
        }
        return indexHeapRamBytesUsed;
    }

    private static void getDetailedFieldInfo(SolrQueryRequest req, String field, SimpleOrderedMap<Object> fieldMap) throws IOException {
        BytesRef text;
        SolrParams params = req.getParams();
        int numTerms = params.getInt(NUMTERMS, 10);
        TopTermQueue tiq = new TopTermQueue(numTerms + 1);
        CharsRefBuilder spare = new CharsRefBuilder();
        Fields fields = MultiFields.getFields(req.getSearcher().getIndexReader());
        if (fields == null) {
            return;
        }
        Terms terms = fields.terms(field);
        if (terms == null) {
            return;
        }
        TermsEnum termsEnum = terms.iterator(null);
        int[] buckets = new int[33];
        while ((text = termsEnum.next()) != null) {
            ++tiq.distinctTerms;
            int freq = termsEnum.docFreq();
            int slot = 32 - Integer.numberOfLeadingZeros(Math.max(0, freq - 1));
            buckets[slot] = buckets[slot] + 1;
            if (numTerms <= 0 || freq <= tiq.minFreq) continue;
            spare.copyUTF8Bytes(text);
            String t = spare.toString();
            tiq.add(new TopTermQueue.TermInfo(new Term(field, t), termsEnum.docFreq()));
            if (tiq.size() <= numTerms) continue;
            tiq.pop();
            tiq.minFreq = tiq.getTopTermInfo().docFreq;
        }
        tiq.histogram.add(buckets);
        fieldMap.add("distinct", tiq.distinctTerms);
        fieldMap.add("topTerms", tiq.toNamedList(req.getSearcher().getSchema()));
        fieldMap.add("histogram", tiq.histogram.toNamedList());
    }

    private static List<String> toListOfStrings(SchemaField[] raw) {
        ArrayList<String> result = new ArrayList<String>(raw.length);
        for (SchemaField f : raw) {
            result.add(f.getName());
        }
        return result;
    }

    private static List<String> toListOfStringDests(List<CopyField> raw) {
        ArrayList<String> result = new ArrayList<String>(raw.size());
        for (CopyField f : raw) {
            result.add(f.getDestination().getName());
        }
        return result;
    }

    @Override
    public String getDescription() {
        return "Lucene Index Browser.  Inspired and modeled after Luke: http://www.getopt.org/luke/";
    }

    @Override
    public String getSource() {
        return null;
    }

    @Override
    public URL[] getDocs() {
        try {
            return new URL[]{new URL("http://wiki.apache.org/solr/LukeRequestHandler")};
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private static class TopTermQueue
    extends PriorityQueue {
        public int minFreq = 0;
        public int distinctTerms = 0;
        public TermHistogram histogram = new TermHistogram();

        TopTermQueue(int size) {
            super(size);
        }

        protected final boolean lessThan(Object a, Object b) {
            TermInfo termInfoA = (TermInfo)a;
            TermInfo termInfoB = (TermInfo)b;
            return termInfoA.docFreq < termInfoB.docFreq;
        }

        public NamedList<Integer> toNamedList(IndexSchema schema) {
            LinkedList<TermInfo> aslist = new LinkedList<TermInfo>();
            while (this.size() > 0) {
                aslist.add(0, (TermInfo)this.pop());
            }
            NamedList<Integer> list = new NamedList<Integer>();
            for (TermInfo i : aslist) {
                String txt = i.term.text();
                SchemaField ft = schema.getFieldOrNull(i.term.field());
                if (ft != null) {
                    txt = ft.getType().indexedToReadable(txt);
                }
                list.add(txt, i.docFreq);
            }
            return list;
        }

        public TermInfo getTopTermInfo() {
            return (TermInfo)this.top();
        }

        static class TermInfo {
            int docFreq;
            Term term;

            TermInfo(Term t, int df) {
                this.term = t;
                this.docFreq = df;
            }
        }
    }

    static class TermHistogram {
        int _maxBucket = -1;
        int[] _buckets = new int[33];

        TermHistogram() {
        }

        public void add(int[] buckets) {
            int idx;
            for (idx = 0; idx < buckets.length; ++idx) {
                if (buckets[idx] == 0) continue;
                this._maxBucket = idx;
            }
            for (idx = 0; idx <= this._maxBucket; ++idx) {
                this._buckets[idx] = buckets[idx];
            }
        }

        public NamedList<Integer> toNamedList() {
            NamedList<Integer> nl = new NamedList<Integer>();
            for (int bucket = 0; bucket <= this._maxBucket; ++bucket) {
                nl.add("" + (1 << bucket), this._buckets[bucket]);
            }
            return nl;
        }
    }

    private static enum ShowStyle {
        ALL,
        DOC,
        SCHEMA,
        INDEX;


        public static ShowStyle get(String v) {
            if (v == null) {
                return null;
            }
            if ("schema".equalsIgnoreCase(v)) {
                return SCHEMA;
            }
            if ("index".equalsIgnoreCase(v)) {
                return INDEX;
            }
            if ("doc".equalsIgnoreCase(v)) {
                return DOC;
            }
            if ("all".equalsIgnoreCase(v)) {
                return ALL;
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown Show Style: " + v);
        }
    }
}

