/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.SyncStrategy;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrXMLCoresLocator;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.MergeIndexesCommand;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.NumberUtils;
import org.apache.solr.util.RefCounted;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreAdminHandler
extends RequestHandlerBase {
    protected static Logger log = LoggerFactory.getLogger(CoreAdminHandler.class);
    protected final CoreContainer coreContainer;
    protected static HashMap<String, Map<String, TaskObject>> requestStatusMap = new HashMap();
    protected final ExecutorService parallelExecutor = Executors.newFixedThreadPool(50, new DefaultSolrThreadFactory("parallelCoreAdminExecutor"));
    protected static int MAX_TRACKED_REQUESTS = 100;
    public static String RUNNING = "running";
    public static String COMPLETED = "completed";
    public static String FAILED = "failed";
    public static String RESPONSE = "Response";
    public static String RESPONSE_STATUS = "STATUS";
    public static String RESPONSE_MESSAGE = "msg";
    public static ImmutableMap<String, String> paramToProp;
    public static ImmutableMap<String, String> cloudParamToProp;

    public CoreAdminHandler() {
        this.coreContainer = null;
    }

    public CoreAdminHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public final void init(NamedList args) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "CoreAdminHandler should not be configured in solrconf.xml\nit is a special Handler configured directly by the RequestDispatcher");
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        CoreContainer cores = this.getCoreContainer();
        if (cores == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core container instance missing");
        }
        String taskId = req.getParams().get("async");
        TaskObject taskObject = new TaskObject(taskId);
        if (taskId != null) {
            if (this.getMap(RUNNING).containsKey(taskId) || this.getMap(COMPLETED).containsKey(taskId) || this.getMap(FAILED).containsKey(taskId)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Duplicate request with the same requestid found.");
            }
            this.addTask(RUNNING, taskObject);
        }
        SolrParams params = req.getParams();
        CoreAdminParams.CoreAdminAction action = CoreAdminParams.CoreAdminAction.STATUS;
        String a = params.get("action");
        if (a != null && (action = CoreAdminParams.CoreAdminAction.get(a)) == null) {
            this.handleCustomAction(req, rsp);
        }
        if (taskId == null) {
            this.handleRequestInternal(req, rsp, action);
        } else {
            ParallelCoreAdminHandlerThread parallelHandlerThread = new ParallelCoreAdminHandlerThread(req, rsp, action, taskObject);
            this.parallelExecutor.execute(parallelHandlerThread);
        }
    }

    protected void handleRequestInternal(SolrQueryRequest req, SolrQueryResponse rsp, CoreAdminParams.CoreAdminAction action) throws Exception {
        if (action != null) {
            switch (action) {
                case CREATE: {
                    this.handleCreateAction(req, rsp);
                    break;
                }
                case RENAME: {
                    this.handleRenameAction(req, rsp);
                    break;
                }
                case UNLOAD: {
                    this.handleUnloadAction(req, rsp);
                    break;
                }
                case STATUS: {
                    this.handleStatusAction(req, rsp);
                    break;
                }
                case PERSIST: {
                    this.handlePersistAction(req, rsp);
                    break;
                }
                case RELOAD: {
                    this.handleReloadAction(req, rsp);
                    break;
                }
                case SWAP: {
                    this.handleSwapAction(req, rsp);
                    break;
                }
                case MERGEINDEXES: {
                    this.handleMergeAction(req, rsp);
                    break;
                }
                case SPLIT: {
                    this.handleSplitAction(req, rsp);
                    break;
                }
                case PREPRECOVERY: {
                    this.handleWaitForStateAction(req, rsp);
                    break;
                }
                case REQUESTRECOVERY: {
                    this.handleRequestRecoveryAction(req, rsp);
                    break;
                }
                case REQUESTSYNCSHARD: {
                    this.handleRequestSyncAction(req, rsp);
                    break;
                }
                case REQUESTAPPLYUPDATES: {
                    this.handleRequestApplyUpdatesAction(req, rsp);
                    break;
                }
                case REQUESTBUFFERUPDATES: {
                    this.handleRequestBufferUpdatesAction(req, rsp);
                    break;
                }
                case REQUESTSTATUS: {
                    this.handleRequestActionStatus(req, rsp);
                    break;
                }
                case OVERSEEROP: {
                    ZkController zkController = this.coreContainer.getZkController();
                    if (zkController == null) break;
                    String op = req.getParams().get("op");
                    String electionNode = req.getParams().get("electionNode");
                    if (electionNode != null) {
                        zkController.rejoinOverseerElection(electionNode, "rejoinAtHead".equals(op));
                        break;
                    }
                    log.info("electionNode is required param");
                    break;
                }
                default: {
                    this.handleCustomAction(req, rsp);
                }
                case LOAD: 
            }
        }
        rsp.setHttpCaching(false);
    }

    protected void handleSplitAction(SolrQueryRequest adminReq, SolrQueryResponse rsp) throws IOException {
        SolrParams params = adminReq.getParams();
        ArrayList<DocRouter.Range> ranges = null;
        String[] pathsArr = params.getParams("path");
        String rangesStr = params.get("ranges");
        if (rangesStr != null) {
            String[] rangesArr = rangesStr.split(",");
            if (rangesArr.length == 0) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "There must be at least one range specified to split an index");
            }
            ranges = new ArrayList<DocRouter.Range>(rangesArr.length);
            for (String r : rangesArr) {
                try {
                    ranges.add(DocRouter.DEFAULT.fromString(r));
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Exception parsing hexadecimal hash range: " + r, (Throwable)e);
                }
            }
        }
        String splitKey = params.get("split.key");
        String[] newCoreNames = params.getParams("targetCore");
        String cname = params.get("core", "");
        if (!(pathsArr != null && pathsArr.length != 0 || newCoreNames != null && newCoreNames.length != 0)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Either path or targetCore param must be specified");
        }
        log.info("Invoked split action for core: " + cname);
        SolrCore core = this.coreContainer.getCore(cname);
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(core, params);
        ArrayList<SolrCore> newCores = null;
        try {
            List<String> paths = null;
            int partitions = pathsArr != null ? pathsArr.length : newCoreNames.length;
            DocRouter router = null;
            String routeFieldName = null;
            if (this.coreContainer.isZooKeeperAware()) {
                Object routerObj;
                ClusterState clusterState = this.coreContainer.getZkController().getClusterState();
                String collectionName = req.getCore().getCoreDescriptor().getCloudDescriptor().getCollectionName();
                DocCollection collection = clusterState.getCollection(collectionName);
                String sliceName = req.getCore().getCoreDescriptor().getCloudDescriptor().getShardId();
                Slice slice = clusterState.getSlice(collectionName, sliceName);
                DocRouter docRouter = router = collection.getRouter() != null ? collection.getRouter() : DocRouter.DEFAULT;
                if (ranges == null) {
                    DocRouter.Range currentRange = slice.getRange();
                    List<DocRouter.Range> list = ranges = currentRange != null ? router.partitionRange(partitions, currentRange) : null;
                }
                if ((routerObj = collection.get("router")) != null && routerObj instanceof Map) {
                    Map routerProps = (Map)routerObj;
                    routeFieldName = (String)routerProps.get("field");
                }
            }
            if (pathsArr == null) {
                newCores = new ArrayList<SolrCore>(partitions);
                for (String newCoreName : newCoreNames) {
                    SolrCore newcore = this.coreContainer.getCore(newCoreName);
                    if (newcore == null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core with core name " + newCoreName + " expected but doesn't exist.");
                    }
                    newCores.add(newcore);
                }
            } else {
                paths = Arrays.asList(pathsArr);
            }
            SplitIndexCommand cmd = new SplitIndexCommand(req, paths, newCores, ranges, router, routeFieldName, splitKey);
            core.getUpdateHandler().split(cmd);
        }
        catch (Exception e) {
            log.error("ERROR executing split:", e);
            throw new RuntimeException(e);
        }
        finally {
            if (req != null) {
                req.close();
            }
            if (core != null) {
                core.close();
            }
            if (newCores != null) {
                for (SolrCore newCore : newCores) {
                    newCore.close();
                }
            }
        }
    }

    protected void handleMergeAction(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        String cname = params.required().get("core");
        SolrCore core = this.coreContainer.getCore(cname);
        SolrQueryRequest wrappedReq = null;
        ArrayList<SolrCore> sourceCores = Lists.newArrayList();
        ArrayList<RefCounted<SolrIndexSearcher>> searchers = Lists.newArrayList();
        ArrayList<DirectoryReader> readersToBeClosed = Lists.newArrayList();
        ArrayList<Directory> dirsToBeReleased = Lists.newArrayList();
        if (core != null) {
            try {
                int i;
                String[] dirNames = params.getParams("indexDir");
                if (dirNames == null || dirNames.length == 0) {
                    String[] sources = params.getParams("srcCore");
                    if (sources == null || sources.length == 0) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "At least one indexDir or srcCore must be specified");
                    }
                    for (i = 0; i < sources.length; ++i) {
                        String source = sources[i];
                        SolrCore srcCore = this.coreContainer.getCore(source);
                        if (srcCore == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core: " + source + " does not exist");
                        }
                        sourceCores.add(srcCore);
                    }
                } else {
                    DirectoryFactory dirFactory = core.getDirectoryFactory();
                    for (i = 0; i < dirNames.length; ++i) {
                        Directory dir = dirFactory.get(dirNames[i], DirectoryFactory.DirContext.DEFAULT, core.getSolrConfig().indexConfig.lockType);
                        dirsToBeReleased.add(dir);
                        readersToBeClosed.add(DirectoryReader.open(dir));
                    }
                }
                ArrayList<DirectoryReader> readers = null;
                if (readersToBeClosed.size() > 0) {
                    readers = readersToBeClosed;
                } else {
                    readers = Lists.newArrayList();
                    for (SolrCore solrCore : sourceCores) {
                        RefCounted<SolrIndexSearcher> searcher = solrCore.getSearcher();
                        searchers.add(searcher);
                        readers.add(searcher.get().getIndexReader());
                    }
                }
                UpdateRequestProcessorChain processorChain = core.getUpdateProcessingChain(params.get("update.chain"));
                wrappedReq = new LocalSolrQueryRequest(core, req.getParams());
                UpdateRequestProcessor processor = processorChain.createProcessor(wrappedReq, rsp);
                processor.processMergeIndexes(new MergeIndexesCommand(readers, req));
            }
            catch (Exception e) {
                log.error("ERROR executing merge:", e);
                throw e;
            }
            finally {
                for (RefCounted refCounted : searchers) {
                    if (refCounted == null) continue;
                    refCounted.decref();
                }
                for (SolrCore solrCore : sourceCores) {
                    if (solrCore == null) continue;
                    solrCore.close();
                }
                IOUtils.closeWhileHandlingException(readersToBeClosed);
                for (Directory directory : dirsToBeReleased) {
                    DirectoryFactory dirFactory = core.getDirectoryFactory();
                    dirFactory.release(directory);
                }
                if (wrappedReq != null) {
                    wrappedReq.close();
                }
                core.close();
            }
        }
    }

    protected void handleCustomAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported operation: " + req.getParams().get("action"));
    }

    protected static CoreDescriptor buildCoreDescriptor(SolrParams params, CoreContainer container) {
        String name = CoreAdminHandler.checkNotEmpty(params.get("name"), "Missing parameter [name]");
        Properties coreProps = new Properties();
        for (String param : paramToProp.keySet()) {
            String value = params.get(param, null);
            if (!StringUtils.isNotEmpty(value)) continue;
            coreProps.setProperty(paramToProp.get(param), value);
        }
        Iterator<String> paramsIt = params.getParameterNamesIterator();
        while (paramsIt.hasNext()) {
            String param;
            param = paramsIt.next();
            if (!param.startsWith("property.")) continue;
            String propName = param.substring("property.".length());
            String propValue = params.get(param);
            coreProps.setProperty(propName, propValue);
        }
        String instancedir = params.get("instanceDir");
        if (StringUtils.isEmpty(instancedir) && coreProps.getProperty("instanceDir") != null) {
            instancedir = coreProps.getProperty("instanceDir");
        } else if (StringUtils.isEmpty(instancedir)) {
            instancedir = name;
        }
        return new CoreDescriptor(container, name, instancedir, coreProps, params);
    }

    private static String checkNotEmpty(String value, String message) {
        if (StringUtils.isEmpty(value)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
        }
        return value;
    }

    protected void handleCreateAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        log.info("core create command {}", (Object)params);
        CoreDescriptor dcore = CoreAdminHandler.buildCoreDescriptor(params, this.coreContainer);
        if (this.coreContainer.getAllCoreNames().contains(dcore.getName())) {
            log.warn("Creating a core with existing name is not allowed");
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core with name '" + dcore.getName() + "' already exists.");
        }
        boolean preExisitingZkEntry = false;
        try {
            if (this.coreContainer.getZkController() != null) {
                if (!Overseer.isLegacy(this.coreContainer.getZkController().getZkStateReader().getClusterProps()) && dcore.getCloudDescriptor().getCoreNodeName() == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "non legacy mode coreNodeName missing " + params);
                }
                preExisitingZkEntry = this.checkIfCoreNodeNameAlreadyExists(dcore);
            }
            SolrCore core = this.coreContainer.create(dcore);
            this.coreContainer.getCoresLocator().create(this.coreContainer, dcore);
            if (this.coreContainer.getCoresLocator() instanceof SolrXMLCoresLocator) {
                this.coreContainer.getCoresLocator().create(this.coreContainer, new CoreDescriptor[0]);
            }
            rsp.add("core", core.getName());
        }
        catch (Exception ex) {
            if (this.coreContainer.isZooKeeperAware() && dcore != null && !preExisitingZkEntry) {
                try {
                    this.coreContainer.getZkController().unregister(dcore.getName(), dcore);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    SolrException.log(log, null, e);
                }
                catch (KeeperException e) {
                    SolrException.log(log, null, e);
                }
            }
            Throwable tc = ex;
            Throwable c = null;
            do {
                if ((tc = tc.getCause()) == null) continue;
                c = tc;
            } while (tc != null);
            String rootMsg = "";
            if (c != null) {
                rootMsg = " Caused by: " + c.getMessage();
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error CREATEing SolrCore '" + dcore.getName() + "': " + ex.getMessage() + rootMsg, (Throwable)ex);
        }
    }

    private boolean checkIfCoreNodeNameAlreadyExists(CoreDescriptor dcore) {
        ZkStateReader zkStateReader = this.coreContainer.getZkController().getZkStateReader();
        DocCollection collection = zkStateReader.getClusterState().getCollectionOrNull(dcore.getCollectionName());
        if (collection != null) {
            Collection<Slice> slices = collection.getSlices();
            for (Slice slice : slices) {
                Collection<Replica> replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    if (!replica.getName().equals(dcore.getCloudDescriptor().getCoreNodeName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void handleRenameAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String name = params.get("other");
        String cname = params.get("core");
        if (cname.equals(name)) {
            return;
        }
        this.coreContainer.rename(cname, name);
    }

    @Deprecated
    protected void handleAliasAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The ALIAS action is no longer supported");
    }

    protected void handleUnloadAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        boolean deleteIndexDir = params.getBool("deleteIndex", false);
        boolean deleteDataDir = params.getBool("deleteDataDir", false);
        boolean deleteInstanceDir = params.getBool("deleteInstanceDir", false);
        this.coreContainer.unload(cname, deleteIndexDir, deleteDataDir, deleteInstanceDir);
    }

    protected void handleStatusAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        String indexInfo = params.get("indexInfo");
        boolean isIndexInfoNeeded = Boolean.parseBoolean(null == indexInfo ? "true" : indexInfo);
        SimpleOrderedMap<NamedList<Object>> status = new SimpleOrderedMap<NamedList<Object>>();
        Map<String, Exception> failures = new HashMap<String, Exception>();
        for (Map.Entry<String, CoreContainer.CoreLoadFailure> failure : this.coreContainer.getCoreInitFailures().entrySet()) {
            failures.put(failure.getKey(), failure.getValue().exception);
        }
        try {
            if (cname == null) {
                rsp.add("defaultCoreName", this.coreContainer.getDefaultCoreName());
                for (String name : this.coreContainer.getAllCoreNames()) {
                    status.add(name, this.getCoreStatus(this.coreContainer, name, isIndexInfoNeeded));
                }
                rsp.add("initFailures", failures);
            } else {
                failures = failures.containsKey(cname) ? Collections.singletonMap(cname, failures.get(cname)) : Collections.emptyMap();
                rsp.add("initFailures", failures);
                status.add(cname, this.getCoreStatus(this.coreContainer, cname, isIndexInfoNeeded));
            }
            rsp.add("status", status);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling 'status' action ", (Throwable)ex);
        }
    }

    protected void handlePersistAction(SolrQueryRequest req, SolrQueryResponse rsp) throws SolrException {
        rsp.add("message", "The PERSIST action has been deprecated");
    }

    protected void handleReloadAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        if (!this.coreContainer.getCoreNames().contains(cname)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core with core name [" + cname + "] does not exist.");
        }
        try {
            this.coreContainer.reload(cname);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling 'reload' action", (Throwable)ex);
        }
    }

    protected void handleRequestActionStatus(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String requestId = params.get("requestid");
        log.info("Checking request status for : " + requestId);
        if (this.mapContainsTask(RUNNING, requestId)) {
            rsp.add(RESPONSE_STATUS, RUNNING);
        } else if (this.mapContainsTask(COMPLETED, requestId)) {
            rsp.add(RESPONSE_STATUS, COMPLETED);
            rsp.add(RESPONSE, this.getMap(COMPLETED).get(requestId).getRspObject());
        } else if (this.mapContainsTask(FAILED, requestId)) {
            rsp.add(RESPONSE_STATUS, FAILED);
            rsp.add(RESPONSE, this.getMap(FAILED).get(requestId).getRspObject());
        } else {
            rsp.add(RESPONSE_STATUS, "notfound");
            rsp.add(RESPONSE_MESSAGE, "No task found in running, completed or failed tasks");
        }
    }

    protected void handleSwapAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        RequiredSolrParams required = params.required();
        String cname = params.get("core");
        String other = ((SolrParams)required).get("other");
        this.coreContainer.swap(cname, other);
    }

    protected void handleRequestRecoveryAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        final SolrParams params = req.getParams();
        log.info("It has been requested that we recover: core=" + params.get("core"));
        Thread thread = new Thread(){

            @Override
            public void run() {
                block18: {
                    String cname = params.get("core");
                    if (cname == null) {
                        cname = "";
                    }
                    try (SolrCore core = CoreAdminHandler.this.coreContainer.getCore(cname);){
                        if (core != null) {
                            block17: {
                                try {
                                    CoreAdminHandler.this.coreContainer.getZkController().publish(core.getCoreDescriptor(), "recovering");
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    SolrException.log(log, "", e);
                                }
                                catch (Throwable e) {
                                    SolrException.log(log, "", e);
                                    if (!(e instanceof Error)) break block17;
                                    throw (Error)e;
                                }
                            }
                            core.getUpdateHandler().getSolrCoreState().doRecovery(CoreAdminHandler.this.coreContainer, core.getCoreDescriptor());
                            break block18;
                        }
                        SolrException.log(log, "Could not find core to call recovery:" + cname);
                    }
                }
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequestSyncAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        block27: {
            SolrParams params = req.getParams();
            log.info("I have been requested to sync up my shard");
            ZkController zkController = this.coreContainer.getZkController();
            if (zkController == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only valid for SolrCloud");
            }
            String cname = params.get("core");
            if (cname == null) {
                throw new IllegalArgumentException("core is required");
            }
            try (SyncStrategy syncStrategy = null;
                 SolrCore core = this.coreContainer.getCore(cname);){
                if (core != null) {
                    syncStrategy = new SyncStrategy(core.getCoreDescriptor().getCoreContainer());
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("base_url", zkController.getBaseUrl());
                    props.put("core", cname);
                    props.put("node_name", zkController.getNodeName());
                    boolean success = syncStrategy.sync(zkController, core, new ZkNodeProps(props), true);
                    if (log.isDebugEnabled()) {
                        try {
                            RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                            SolrIndexSearcher searcher = searchHolder.get();
                            try {
                                log.debug(core.getCoreDescriptor().getCoreContainer().getZkController().getNodeName() + " synched " + searcher.search((Query)new MatchAllDocsQuery(), (int)1).totalHits);
                            }
                            finally {
                                searchHolder.decref();
                            }
                        }
                        catch (Exception e) {
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
                        }
                    }
                    if (!success) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Sync Failed");
                    }
                    break block27;
                }
                SolrException.log(log, "Cound not find core to call sync:" + cname);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleWaitForStateAction(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException, InterruptedException, KeeperException {
        SolrParams params = req.getParams();
        String cname = params.get("core");
        if (cname == null) {
            cname = "";
        }
        String nodeName = params.get("nodeName");
        String coreNodeName = params.get("coreNodeName");
        String waitForState = params.get("state");
        Boolean checkLive = params.getBool("checkLive");
        Boolean onlyIfLeader = params.getBool("onlyIfLeader");
        Boolean onlyIfLeaderActive = params.getBool("onlyIfLeaderActive");
        log.info("Going to wait for coreNodeName: " + coreNodeName + ", state: " + waitForState + ", checkLive: " + checkLive + ", onlyIfLeader: " + onlyIfLeader + ", onlyIfLeaderActive: " + onlyIfLeaderActive);
        int maxTries = 0;
        String state = null;
        boolean live = false;
        int retry = 0;
        while (true) {
            block40: {
                try (SolrCore core = this.coreContainer.getCore(cname);){
                    if (core == null && retry == 30) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "core not found:" + cname);
                    }
                    if (core != null) {
                        ZkNodeProps nodeProps;
                        String collection;
                        ClusterState clusterState;
                        Slice slice;
                        if (onlyIfLeader != null && onlyIfLeader.booleanValue() && !core.getCoreDescriptor().getCloudDescriptor().isLeader()) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "We are not the leader");
                        }
                        CloudDescriptor cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor();
                        if (retry % 15 == 0) {
                            if (retry > 0 && log.isInfoEnabled()) {
                                log.info("After " + retry + " seconds, core " + cname + " (" + cloudDescriptor.getShardId() + " of " + cloudDescriptor.getCollectionName() + ") still does not have state: " + waitForState + "; forcing ClusterState update from ZooKeeper");
                            }
                            this.coreContainer.getZkController().getZkStateReader().updateClusterState(true);
                        }
                        if (maxTries == 0) {
                            int conflictWaitMs = this.coreContainer.getZkController().getLeaderConflictResolveWait();
                            maxTries = Math.round(conflictWaitMs / 1000) + 3;
                            log.info("Will wait a max of " + maxTries + " seconds to see " + cname + " (" + cloudDescriptor.getShardId() + " of " + cloudDescriptor.getCollectionName() + ") have state: " + waitForState);
                        }
                        if ((slice = (clusterState = this.coreContainer.getZkController().getClusterState()).getSlice(collection = cloudDescriptor.getCollectionName(), cloudDescriptor.getShardId())) != null && (nodeProps = (ZkNodeProps)slice.getReplicasMap().get(coreNodeName)) != null) {
                            boolean leaderDoesNotNeedRecovery;
                            state = nodeProps.getStr("state");
                            live = clusterState.liveNodesContain(nodeName);
                            String localState = cloudDescriptor.getLastPublished();
                            boolean bl = leaderDoesNotNeedRecovery = onlyIfLeader != null && onlyIfLeader != false && core.getName().equals(nodeProps.getStr("core")) && "recovering".equals(waitForState) && "active".equals(localState) && "active".equals(state);
                            if (leaderDoesNotNeedRecovery) {
                                log.warn("Leader " + core.getName() + " ignoring request to be in the recovering state because it is live and active.");
                            }
                            boolean onlyIfActiveCheckResult = onlyIfLeaderActive != null && onlyIfLeaderActive != false && (localState == null || !localState.equals("active"));
                            log.info("In WaitForState(" + waitForState + "): collection=" + collection + ", shard=" + slice.getName() + ", thisCore=" + core.getName() + ", leaderDoesNotNeedRecovery=" + leaderDoesNotNeedRecovery + ", isLeader? " + core.getCoreDescriptor().getCloudDescriptor().isLeader() + ", live=" + live + ", checkLive=" + checkLive + ", currentState=" + state + ", localState=" + localState + ", nodeName=" + nodeName + ", coreNodeName=" + coreNodeName + ", onlyIfActiveCheckResult=" + onlyIfActiveCheckResult + ", nodeProps: " + nodeProps);
                            if (!onlyIfActiveCheckResult && nodeProps != null && (state.equals(waitForState) || leaderDoesNotNeedRecovery) && (checkLive == null || checkLive.booleanValue() && live || !checkLive.booleanValue() && !live)) break;
                        }
                    }
                    if (retry++ == maxTries) {
                        String collection = null;
                        String leaderInfo = null;
                        String shardId = null;
                        try {
                            CloudDescriptor cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor();
                            collection = cloudDescriptor.getCollectionName();
                            shardId = cloudDescriptor.getShardId();
                            leaderInfo = this.coreContainer.getZkController().getZkStateReader().getLeaderUrl(collection, shardId, 5000);
                        }
                        catch (Exception exc) {
                            leaderInfo = "Not available due to: " + exc;
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "I was asked to wait on state " + waitForState + " for " + shardId + " in " + collection + " on " + nodeName + " but I still do not see the requested state. I see state: " + state + " live:" + live + " leader from ZK: " + leaderInfo);
                    }
                    if (this.coreContainer.isShutDown()) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Solr is shutting down");
                    }
                    if (!log.isDebugEnabled()) break block40;
                    try {
                        LocalSolrQueryRequest r = new LocalSolrQueryRequest(core, new ModifiableSolrParams());
                        CommitUpdateCommand commitCmd = new CommitUpdateCommand(r, false);
                        commitCmd.softCommit = true;
                        core.getUpdateHandler().commit(commitCmd);
                        RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                        SolrIndexSearcher searcher = searchHolder.get();
                        try {
                            log.debug(core.getCoreDescriptor().getCoreContainer().getZkController().getNodeName() + " to replicate " + searcher.search((Query)new MatchAllDocsQuery(), (int)1).totalHits + " gen:" + core.getDeletionPolicy().getLatestCommit().getGeneration() + " data:" + core.getDataDir());
                        }
                        finally {
                            searchHolder.decref();
                        }
                    }
                    catch (Exception e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
                    }
                }
            }
            Thread.sleep(1000L);
        }
        log.info("Waited coreNodeName: " + coreNodeName + ", state: " + waitForState + ", checkLive: " + checkLive + ", onlyIfLeader: " + onlyIfLeader + " for: " + retry + " seconds.");
    }

    private void handleRequestApplyUpdatesAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String cname = params.get("name", "");
        log.info("Applying buffered updates on core: " + cname);
        try (SolrCore core = this.coreContainer.getCore(cname);){
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core [" + cname + "] not found");
            }
            UpdateLog updateLog = core.getUpdateHandler().getUpdateLog();
            if (updateLog.getState() != UpdateLog.State.BUFFERING) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core " + cname + " not in buffering state");
            }
            Future<UpdateLog.RecoveryInfo> future = updateLog.applyBufferedUpdates();
            if (future == null) {
                log.info("No buffered updates available. core=" + cname);
                rsp.add("core", cname);
                rsp.add("status", "EMPTY_BUFFER");
                return;
            }
            UpdateLog.RecoveryInfo report = future.get();
            if (report.failed) {
                SolrException.log(log, "Replay failed");
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Replay failed");
            }
            this.coreContainer.getZkController().publish(core.getCoreDescriptor(), "active");
            rsp.add("core", cname);
            rsp.add("status", "BUFFER_APPLIED");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Recovery was interrupted", e);
        }
        catch (Exception e) {
            if (e instanceof SolrException) {
                throw (SolrException)e;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not apply buffered updates", (Throwable)e);
        }
        finally {
            if (req != null) {
                req.close();
            }
        }
    }

    private void handleRequestBufferUpdatesAction(SolrQueryRequest req, SolrQueryResponse rsp) {
        SolrParams params = req.getParams();
        String cname = params.get("name", "");
        log.info("Starting to buffer updates on core:" + cname);
        try (SolrCore core = this.coreContainer.getCore(cname);){
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core [" + cname + "] does not exist");
            }
            UpdateLog updateLog = core.getUpdateHandler().getUpdateLog();
            if (updateLog.getState() != UpdateLog.State.ACTIVE) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core " + cname + " not in active state");
            }
            updateLog.bufferUpdates();
            rsp.add("core", cname);
            rsp.add("status", "BUFFERING");
        }
        catch (Throwable e) {
            if (e instanceof SolrException) {
                throw (SolrException)e;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not start buffering updates", e);
        }
        finally {
            if (req != null) {
                req.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NamedList<Object> getCoreStatus(CoreContainer cores, String cname, boolean isIndexInfoNeeded) throws IOException {
        SimpleOrderedMap<Object> info;
        block21: {
            info = new SimpleOrderedMap<Object>();
            if (!cores.isLoaded(cname)) {
                CoreDescriptor desc = cores.getUnloadedCoreDescriptor(cname);
                if (desc != null) {
                    info.add("name", desc.getName());
                    info.add("isDefaultCore", desc.getName().equals(cores.getDefaultCoreName()));
                    info.add("instanceDir", desc.getInstanceDir());
                    String tmp = desc.getDataDir();
                    if (StringUtils.isNotBlank(tmp)) {
                        info.add("dataDir", tmp);
                    }
                    if (StringUtils.isNotBlank(tmp = desc.getConfigName())) {
                        info.add("config", tmp);
                    }
                    if (StringUtils.isNotBlank(tmp = desc.getSchemaName())) {
                        info.add("schema", tmp);
                    }
                    info.add("isLoaded", "false");
                }
            } else {
                try (SolrCore core = cores.getCore(cname);){
                    if (core == null) break block21;
                    info.add("name", core.getName());
                    info.add("isDefaultCore", core.getName().equals(cores.getDefaultCoreName()));
                    info.add("instanceDir", CoreAdminHandler.normalizePath(core.getResourceLoader().getInstanceDir()));
                    info.add("dataDir", CoreAdminHandler.normalizePath(core.getDataDir()));
                    info.add("config", core.getConfigResource());
                    info.add("schema", core.getSchemaResource());
                    info.add("startTime", new Date(core.getStartTime()));
                    info.add("uptime", System.currentTimeMillis() - core.getStartTime());
                    if (!isIndexInfoNeeded) break block21;
                    RefCounted<SolrIndexSearcher> searcher = core.getSearcher();
                    try {
                        SimpleOrderedMap<Object> indexInfo = LukeRequestHandler.getIndexInfo(searcher.get().getIndexReader());
                        long size = this.getIndexSize(core);
                        indexInfo.add("sizeInBytes", size);
                        indexInfo.add("size", NumberUtils.readableSize(size));
                        info.add("index", indexInfo);
                    }
                    finally {
                        searcher.decref();
                    }
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getIndexSize(SolrCore core) {
        long size = 0L;
        try {
            Directory dir = core.getDirectoryFactory().get(core.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, core.getSolrConfig().indexConfig.lockType);
            try {
                size = DirectoryFactory.sizeOfDirectory(dir);
            }
            finally {
                core.getDirectoryFactory().release(dir);
            }
        }
        catch (IOException e) {
            SolrException.log(log, "IO error while trying to get the size of the Directory", e);
        }
        return size;
    }

    protected static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        path = path.replace('/', File.separatorChar);
        path = path.replace('\\', File.separatorChar);
        return path;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], params[i + 1]);
        }
        return msp;
    }

    @Override
    public String getDescription() {
        return "Manage Multiple Solr Cores";
    }

    @Override
    public String getSource() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(String map, TaskObject o, boolean limit) {
        Map<String, TaskObject> map2 = this.getMap(map);
        synchronized (map2) {
            if (limit && this.getMap(map).size() == MAX_TRACKED_REQUESTS) {
                String key = this.getMap(map).entrySet().iterator().next().getKey();
                this.getMap(map).remove(key);
            }
            this.addTask(map, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTask(String map, TaskObject o) {
        Map<String, TaskObject> map2 = this.getMap(map);
        synchronized (map2) {
            this.getMap(map).put(o.taskId, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTask(String map, String taskId) {
        Map<String, TaskObject> map2 = this.getMap(map);
        synchronized (map2) {
            this.getMap(map).remove(taskId);
        }
    }

    protected boolean mapContainsTask(String map, String taskId) {
        return this.getMap(map).containsKey(taskId);
    }

    protected TaskObject getTask(String map, String taskId) {
        return this.getMap(map).get(taskId);
    }

    private Map<String, TaskObject> getMap(String map) {
        return requestStatusMap.get(map);
    }

    public void shutdown() {
        if (this.parallelExecutor != null && !this.parallelExecutor.isShutdown()) {
            ExecutorUtil.shutdownAndAwaitTermination(this.parallelExecutor);
        }
    }

    static {
        requestStatusMap.put(RUNNING, Collections.synchronizedMap(new LinkedHashMap()));
        requestStatusMap.put(COMPLETED, Collections.synchronizedMap(new LinkedHashMap()));
        requestStatusMap.put(FAILED, Collections.synchronizedMap(new LinkedHashMap()));
        paramToProp = ImmutableMap.builder().put("config", "config").put("schema", "schema").put("dataDir", "dataDir").put("ulogDir", "ulogDir").put("configSet", "configSet").put("loadOnStartup", "loadOnStartup").put("transient", "transient").put("shard", "shard").put("collection", "collection").put("roles", "roles").put("coreNodeName", "coreNodeName").put("numShards", "numShards").build();
    }

    private class TaskObject {
        String taskId;
        String rspInfo;

        public TaskObject(String taskId) {
            this.taskId = taskId;
        }

        public String getRspObject() {
            return this.rspInfo;
        }

        public void setRspObject(SolrQueryResponse rspObject) {
            this.rspInfo = rspObject.getToLogAsString("TaskId: " + this.taskId + " ");
        }

        public void setRspObjectFromException(Exception e) {
            this.rspInfo = e.getMessage();
        }
    }

    protected class ParallelCoreAdminHandlerThread
    implements Runnable {
        SolrQueryRequest req;
        SolrQueryResponse rsp;
        CoreAdminParams.CoreAdminAction action;
        TaskObject taskObject;

        public ParallelCoreAdminHandlerThread(SolrQueryRequest req, SolrQueryResponse rsp, CoreAdminParams.CoreAdminAction action, TaskObject taskObject) {
            this.req = req;
            this.rsp = rsp;
            this.action = action;
            this.taskObject = taskObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean exceptionCaught = false;
            try {
                CoreAdminHandler.this.handleRequestInternal(this.req, this.rsp, this.action);
                this.taskObject.setRspObject(this.rsp);
            }
            catch (Exception e) {
                exceptionCaught = true;
                this.taskObject.setRspObjectFromException(e);
            }
            finally {
                CoreAdminHandler.this.removeTask("running", this.taskObject.taskId);
                if (exceptionCaught) {
                    CoreAdminHandler.this.addTask("failed", this.taskObject, true);
                } else {
                    CoreAdminHandler.this.addTask("completed", this.taskObject, true);
                }
            }
        }
    }
}

