/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class DumpRequestHandler
extends RequestHandlerBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        rsp.add("params", req.getParams().toNamedList());
        if (req.getContentStreams() != null) {
            ArrayList streams = new ArrayList();
            for (ContentStream content : req.getContentStreams()) {
                SimpleOrderedMap<Object> stream = new SimpleOrderedMap<Object>();
                stream.add("name", content.getName());
                stream.add("sourceInfo", content.getSourceInfo());
                stream.add("size", content.getSize());
                stream.add("contentType", content.getContentType());
                try (Reader reader = content.getReader();){
                    stream.add("stream", IOUtils.toString(reader));
                }
                streams.add(stream);
            }
            rsp.add("streams", streams);
        }
        rsp.add("context", req.getContext());
    }

    @Override
    public String getDescription() {
        return "Dump handler (debug)";
    }

    @Override
    public String getSource() {
        return null;
    }
}

