/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.Config;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.SolrXMLCoresLocator;
import org.apache.solr.util.DOMUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigSolrXmlOld
extends ConfigSolr {
    protected static Logger log = LoggerFactory.getLogger(ConfigSolrXmlOld.class);
    private NodeList coreNodes = null;
    private final CoresLocator persistor;
    public static final String DEFAULT_DEFAULT_CORE_NAME = "collection1";
    public static final String DEF_SOLR_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<solr persistent=\"false\">\n  <cores adminPath=\"/admin/cores\" defaultCoreName=\"collection1\" host=\"${host:}\" hostPort=\"${hostPort:}\" hostContext=\"${hostContext:}\" zkClientTimeout=\"${zkClientTimeout:15000}\">\n    <core name=\"collection1\" shard=\"${shard:}\" collection=\"${collection:collection1}\" instanceDir=\"collection1\" />\n  </cores>\n</solr>";

    @Override
    protected String getShardHandlerFactoryConfigPath() {
        return "solr/cores/shardHandlerFactory";
    }

    public ConfigSolrXmlOld(Config config, String originalXML) {
        super(config);
        try {
            this.checkForIllegalConfig();
            this.fillPropMap();
            this.initCoreList();
            this.persistor = this.isPersistent() ? new SolrXMLCoresLocator(originalXML, this) : new SolrXMLCoresLocator.NonPersistingLocator(originalXML, this);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    public CoresLocator getCoresLocator() {
        return this.persistor;
    }

    private void checkForIllegalConfig() throws IOException {
        this.failIfFound("solr/str[@name='adminHandler']");
        this.failIfFound("solr/int[@name='coreLoadThreads']");
        this.failIfFound("solr/str[@name='coreRootDirectory']");
        this.failIfFound("solr/solrcloud/int[@name='distribUpdateConnTimeout']");
        this.failIfFound("solr/solrcloud/int[@name='distribUpdateSoTimeout']");
        this.failIfFound("solr/solrcloud/str[@name='host']");
        this.failIfFound("solr/solrcloud/str[@name='hostContext']");
        this.failIfFound("solr/solrcloud/int[@name='hostPort']");
        this.failIfFound("solr/solrcloud/int[@name='leaderVoteWait']");
        this.failIfFound("solr/solrcloud/int[@name='genericCoreNodeNames']");
        this.failIfFound("solr/str[@name='managementPath']");
        this.failIfFound("solr/str[@name='sharedLib']");
        this.failIfFound("solr/str[@name='shareSchema']");
        this.failIfFound("solr/int[@name='transientCacheSize']");
        this.failIfFound("solr/solrcloud/int[@name='zkClientTimeout']");
        this.failIfFound("solr/solrcloud/int[@name='zkHost']");
        this.failIfFound("solr/logging/str[@name='class']");
        this.failIfFound("solr/logging/str[@name='enabled']");
        this.failIfFound("solr/logging/watcher/int[@name='size']");
        this.failIfFound("solr/logging/watcher/int[@name='threshold']");
    }

    private void failIfFound(String xPath) {
        if (this.config.getVal(xPath, false) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Should not have found " + xPath + " solr.xml may be a mix of old and new style formats.");
        }
    }

    @Override
    public boolean isPersistent() {
        return this.config.getBool("solr/@persistent", false);
    }

    @Override
    public String getDefaultCoreName() {
        return this.get(ConfigSolr.CfgProp.SOLR_CORES_DEFAULT_CORE_NAME, DEFAULT_DEFAULT_CORE_NAME);
    }

    private void fillPropMap() {
        this.storeConfigPropertyAsInt(ConfigSolr.CfgProp.SOLR_CORELOADTHREADS, "solr/@coreLoadThreads");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_SHAREDLIB, "solr/@sharedLib");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_ZKHOST, "solr/@zkHost");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_LOGGING_CLASS, "solr/logging/@class");
        this.storeConfigPropertyAsBoolean(ConfigSolr.CfgProp.SOLR_LOGGING_ENABLED, "solr/logging/@enabled");
        this.storeConfigPropertyAsInt(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_SIZE, "solr/logging/watcher/@size");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, "solr/logging/watcher/@threshold");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_ADMINHANDLER, "solr/cores/@adminHandler");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_COLLECTIONSHANDLER, "solr/cores/@collectionsHandler");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_INFOHANDLER, "solr/cores/@infoHandler");
        this.storeConfigPropertyAsInt(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, "solr/cores/@distribUpdateConnTimeout");
        this.storeConfigPropertyAsInt(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, "solr/cores/@distribUpdateSoTimeout");
        this.storeConfigPropertyAsInt(ConfigSolr.CfgProp.SOLR_MAXUPDATECONNECTIONS, "solr/cores/@maxUpdateConnections");
        this.storeConfigPropertyAsInt(ConfigSolr.CfgProp.SOLR_MAXUPDATECONNECTIONSPERHOST, "solr/cores/@maxUpdateConnectionsPerHost");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_HOST, "solr/cores/@host");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_HOSTCONTEXT, "solr/cores/@hostContext");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_HOSTPORT, "solr/cores/@hostPort");
        this.storeConfigPropertyAsInt(ConfigSolr.CfgProp.SOLR_LEADERVOTEWAIT, "solr/cores/@leaderVoteWait");
        this.storeConfigPropertyAsBoolean(ConfigSolr.CfgProp.SOLR_GENERICCORENODENAMES, "solr/cores/@genericCoreNodeNames");
        this.storeConfigPropertyAsBoolean(ConfigSolr.CfgProp.SOLR_AUTOREPLICAFAILOVERBADNODEEXPIRATION, "solr/cores/@autoReplicaFailoverBadNodeExpiration");
        this.storeConfigPropertyAsBoolean(ConfigSolr.CfgProp.SOLR_AUTOREPLICAFAILOVERWAITAFTEREXPIRATION, "solr/cores/@autoReplicaFailoverWaitAfterExpiration");
        this.storeConfigPropertyAsBoolean(ConfigSolr.CfgProp.SOLR_AUTOREPLICAFAILOVERWORKLOOPDELAY, "solr/cores/@autoReplicaFailoverWorkLoopDelay");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_MANAGEMENTPATH, "solr/cores/@managementPath");
        this.storeConfigPropertyAsBoolean(ConfigSolr.CfgProp.SOLR_SHARESCHEMA, "solr/cores/@shareSchema");
        this.storeConfigPropertyAsInt(ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, "solr/cores/@transientCacheSize");
        this.storeConfigPropertyAsInt(ConfigSolr.CfgProp.SOLR_ZKCLIENTTIMEOUT, "solr/cores/@zkClientTimeout");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_CONFIGSETBASEDIR, "solr/cores/@configSetBaseDir");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_CORES_DEFAULT_CORE_NAME, "solr/cores/@defaultCoreName");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_PERSISTENT, "solr/@persistent");
        this.storeConfigPropertyAsString(ConfigSolr.CfgProp.SOLR_ADMINPATH, "solr/cores/@adminPath");
    }

    private void storeConfigPropertyAsInt(ConfigSolr.CfgProp key, String xmlPath) {
        String valueAsString = this.config.getVal(xmlPath, false);
        if (StringUtils.isNotBlank(valueAsString)) {
            this.propMap.put(key, Integer.parseInt(valueAsString));
        } else {
            this.propMap.put(key, null);
        }
    }

    private void storeConfigPropertyAsBoolean(ConfigSolr.CfgProp key, String xmlPath) {
        String valueAsString = this.config.getVal(xmlPath, false);
        if (StringUtils.isNotBlank(valueAsString)) {
            this.propMap.put(key, Boolean.parseBoolean(valueAsString));
        } else {
            this.propMap.put(key, null);
        }
    }

    private void storeConfigPropertyAsString(ConfigSolr.CfgProp key, String xmlPath) {
        this.propMap.put(key, this.config.getVal(xmlPath, false));
    }

    private void initCoreList() throws IOException {
        this.coreNodes = (NodeList)this.config.evaluate("solr/cores/core", XPathConstants.NODESET);
        HashSet<String> names = new HashSet<String>();
        HashMap<String, String> dirs = new HashMap<String, String>();
        for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
            Node node = this.coreNodes.item(idx);
            String name = DOMUtil.getAttr(node, "name", null);
            String dataDir = DOMUtil.getAttr(node, "dataDir", null);
            if (name != null) {
                if (!names.contains(name)) {
                    names.add(name);
                } else {
                    String msg = String.format(Locale.ROOT, "More than one core defined for core named %s", name);
                    log.error(msg);
                }
            }
            String instDir = DOMUtil.getAttr(node, "instanceDir", null);
            if (dataDir == null) continue;
            String absData = null;
            File dataFile = new File(dataDir);
            if (dataFile.isAbsolute()) {
                absData = dataFile.getCanonicalPath();
            } else if (instDir != null) {
                File instFile = new File(instDir);
                absData = new File(instFile, dataDir).getCanonicalPath();
            }
            if (absData == null) continue;
            if (!dirs.containsKey(absData)) {
                dirs.put(absData, name);
                continue;
            }
            String msg = String.format(Locale.ROOT, "More than one core points to data dir %s. They are in %s and %s", absData, dirs.get(absData), name);
            log.warn(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllCoreNames() {
        ArrayList<String> ret = new ArrayList<String>();
        NodeList nodeList = this.coreNodes;
        synchronized (nodeList) {
            for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                Node node = this.coreNodes.item(idx);
                ret.add(DOMUtil.getAttr(node, "name", null));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String coreName, String property, String defaultVal) {
        NodeList nodeList = this.coreNodes;
        synchronized (nodeList) {
            for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                Node node = this.coreNodes.item(idx);
                if (!coreName.equals(DOMUtil.getAttr(node, "name", null))) continue;
                String propVal = DOMUtil.getAttr(node, property);
                if (propVal == null) {
                    propVal = defaultVal;
                }
                return propVal;
            }
        }
        return defaultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getCoreProperties(String coreName) {
        NodeList nodeList = this.coreNodes;
        synchronized (nodeList) {
            for (int idx = 0; idx < this.coreNodes.getLength(); ++idx) {
                Node node = this.coreNodes.item(idx);
                if (!coreName.equals(DOMUtil.getAttr(node, "name", null))) continue;
                try {
                    return this.readProperties(node);
                }
                catch (XPathExpressionException e) {
                    SolrException.log(log, e);
                }
            }
        }
        return new Properties();
    }
}

