/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.cloud.CloudConfigSetService;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.Config;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.ConfigSolrXml;
import org.apache.solr.core.ConfigSolrXmlOld;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.ZkContainer;
import org.apache.solr.logging.LogWatcherConfig;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class ConfigSolr {
    protected static Logger log = LoggerFactory.getLogger(ConfigSolr.class);
    public static final String SOLR_XML_FILE = "solr.xml";
    private static final int DEFAULT_ZK_CLIENT_TIMEOUT = 15000;
    private static final int DEFAULT_LEADER_VOTE_WAIT = 180000;
    private static final int DEFAULT_LEADER_CONFLICT_RESOLVE_WAIT = 180000;
    private static final int DEFAULT_CORE_LOAD_THREADS = 3;
    private static final int DEFAULT_AUTO_REPLICA_FAILOVER_WAIT_AFTER_EXPIRATION = 30000;
    private static final int DEFAULT_AUTO_REPLICA_FAILOVER_WORKLOOP_DELAY = 10000;
    private static final int DEFAULT_AUTO_REPLICA_FAILOVER_BAD_NODE_EXPIRATION = 60000;
    protected static final String DEFAULT_CORE_ADMIN_PATH = "/admin/cores";
    protected Config config;
    protected Map<CfgProp, Object> propMap = new HashMap<CfgProp, Object>();

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfigSolr fromFile(SolrResourceLoader loader, File configFile) {
        ConfigSolr configSolr;
        log.info("Loading container configuration from {}", (Object)configFile.getAbsolutePath());
        InputStream inputStream = null;
        try {
            if (!configFile.exists()) {
                if (ZkContainer.isZkMode()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "solr.xml does not exist in " + configFile.getAbsolutePath() + " cannot start Solr");
                }
                log.info("{} does not exist, using default configuration", (Object)configFile.getAbsolutePath());
                inputStream = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<solr persistent=\"false\">\n  <cores adminPath=\"/admin/cores\" defaultCoreName=\"collection1\" host=\"${host:}\" hostPort=\"${hostPort:}\" hostContext=\"${hostContext:}\" zkClientTimeout=\"${zkClientTimeout:15000}\">\n    <core name=\"collection1\" shard=\"${shard:}\" collection=\"${collection:collection1}\" instanceDir=\"collection1\" />\n  </cores>\n</solr>".getBytes(StandardCharsets.UTF_8));
            } else {
                inputStream = new FileInputStream(configFile);
            }
            configSolr = ConfigSolr.fromInputStream(loader, inputStream);
        }
        catch (SolrException exc) {
            try {
                throw exc;
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load SOLR configuration", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return configSolr;
    }

    public static ConfigSolr fromString(SolrResourceLoader loader, String xml) {
        return ConfigSolr.fromInputStream(loader, new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConfigSolr fromInputStream(SolrResourceLoader loader, InputStream is) {
        try {
            byte[] buf = IOUtils.toByteArray(is);
            String originalXml = new String(buf, StandardCharsets.UTF_8);
            try (ByteArrayInputStream dup = new ByteArrayInputStream(buf);){
                Config config = new Config(loader, null, new InputSource(dup), null, false);
                ConfigSolr configSolr = ConfigSolr.fromConfig(config, originalXml);
                return configSolr;
            }
        }
        catch (SolrException exc) {
            throw exc;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public static ConfigSolr fromSolrHome(SolrResourceLoader loader, String solrHome) {
        return ConfigSolr.fromFile(loader, new File(solrHome, SOLR_XML_FILE));
    }

    public static ConfigSolr fromConfig(Config config, String originalXml) {
        boolean oldStyle = config.getNode("solr/cores", false) != null;
        return oldStyle ? new ConfigSolrXmlOld(config, originalXml) : new ConfigSolrXml(config);
    }

    public abstract CoresLocator getCoresLocator();

    public String getCoreRootDirectory() {
        return SolrResourceLoader.normalizeDir(this.get(CfgProp.SOLR_COREROOTDIRECTORY, this.config.getResourceLoader().getInstanceDir()));
    }

    public PluginInfo getShardHandlerFactoryPluginInfo() {
        Node node = this.config.getNode(this.getShardHandlerFactoryConfigPath(), false);
        return node == null ? null : new PluginInfo(node, "shardHandlerFactory", false, true);
    }

    protected abstract String getShardHandlerFactoryConfigPath();

    public String getZkHost() {
        String sysZkHost = System.getProperty("zkHost");
        if (sysZkHost != null) {
            return sysZkHost;
        }
        return this.get(CfgProp.SOLR_ZKHOST, null);
    }

    public int getZkClientTimeout() {
        String sysProp = System.getProperty("zkClientTimeout");
        if (sysProp != null) {
            return Integer.parseInt(sysProp);
        }
        return this.get(CfgProp.SOLR_ZKCLIENTTIMEOUT, 15000);
    }

    public String getZkHostPort() {
        return this.get(CfgProp.SOLR_HOSTPORT, null);
    }

    public String getZkHostContext() {
        return this.get(CfgProp.SOLR_HOSTCONTEXT, null);
    }

    public String getHost() {
        return this.get(CfgProp.SOLR_HOST, null);
    }

    public int getLeaderVoteWait() {
        return this.get(CfgProp.SOLR_LEADERVOTEWAIT, 180000);
    }

    public int getLeaderConflictResolveWait() {
        return this.get(CfgProp.SOLR_LEADERCONFLICTRESOLVEWAIT, 180000);
    }

    public int getAutoReplicaFailoverWaitAfterExpiration() {
        return this.get(CfgProp.SOLR_AUTOREPLICAFAILOVERWAITAFTEREXPIRATION, 30000);
    }

    public int getAutoReplicaFailoverWorkLoopDelay() {
        return this.get(CfgProp.SOLR_AUTOREPLICAFAILOVERWORKLOOPDELAY, 10000);
    }

    public int getAutoReplicaFailoverBadNodeExpiration() {
        return this.get(CfgProp.SOLR_AUTOREPLICAFAILOVERBADNODEEXPIRATION, 60000);
    }

    public boolean getGenericCoreNodeNames() {
        return this.get(CfgProp.SOLR_GENERICCORENODENAMES, false);
    }

    public int getDistributedConnectionTimeout() {
        return this.get(CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, 0);
    }

    public int getDistributedSocketTimeout() {
        return this.get(CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, 0);
    }

    public int getMaxUpdateConnections() {
        return this.get(CfgProp.SOLR_MAXUPDATECONNECTIONS, 10000);
    }

    public int getMaxUpdateConnectionsPerHost() {
        return this.get(CfgProp.SOLR_MAXUPDATECONNECTIONSPERHOST, 100);
    }

    public int getCoreLoadThreadCount() {
        return this.get(CfgProp.SOLR_CORELOADTHREADS, 3);
    }

    public String getSharedLibDirectory() {
        return this.get(CfgProp.SOLR_SHAREDLIB, null);
    }

    public String getDefaultCoreName() {
        return this.get(CfgProp.SOLR_CORES_DEFAULT_CORE_NAME, null);
    }

    public abstract boolean isPersistent();

    public String getAdminPath() {
        return this.get(CfgProp.SOLR_ADMINPATH, DEFAULT_CORE_ADMIN_PATH);
    }

    public String getCoreAdminHandlerClass() {
        return this.get(CfgProp.SOLR_ADMINHANDLER, "org.apache.solr.handler.admin.CoreAdminHandler");
    }

    public String getCollectionsHandlerClass() {
        return this.get(CfgProp.SOLR_COLLECTIONSHANDLER, "org.apache.solr.handler.admin.CollectionsHandler");
    }

    public String getInfoHandlerClass() {
        return this.get(CfgProp.SOLR_INFOHANDLER, "org.apache.solr.handler.admin.InfoHandler");
    }

    public boolean hasSchemaCache() {
        return this.get(CfgProp.SOLR_SHARESCHEMA, false);
    }

    public String getManagementPath() {
        return this.get(CfgProp.SOLR_MANAGEMENTPATH, null);
    }

    public String getConfigSetBaseDirectory() {
        return this.get(CfgProp.SOLR_CONFIGSETBASEDIR, "configsets");
    }

    public LogWatcherConfig getLogWatcherConfig() {
        String loggingClass = this.get(CfgProp.SOLR_LOGGING_CLASS, null);
        String loggingWatcherThreshold = this.get(CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, null);
        return new LogWatcherConfig(this.get(CfgProp.SOLR_LOGGING_ENABLED, true), loggingClass, loggingWatcherThreshold, this.get(CfgProp.SOLR_LOGGING_WATCHER_SIZE, 50));
    }

    public int getTransientCacheSize() {
        return this.get(CfgProp.SOLR_TRANSIENTCACHESIZE, Integer.MAX_VALUE);
    }

    public ConfigSetService createCoreConfigService(SolrResourceLoader loader, ZkController zkController) {
        if (this.getZkHost() != null || System.getProperty("zkRun") != null) {
            return new CloudConfigSetService(loader, zkController);
        }
        if (this.hasSchemaCache()) {
            return new ConfigSetService.SchemaCaching(loader, this.getConfigSetBaseDirectory());
        }
        return new ConfigSetService.Default(loader, this.getConfigSetBaseDirectory());
    }

    public ConfigSolr(Config config) {
        this.config = config;
        config.substituteProperties();
    }

    protected ConfigSolr() {
    }

    public Config getConfig() {
        return this.config;
    }

    public <T> T get(CfgProp key, T defaultValue) {
        if (this.propMap.containsKey((Object)key) && this.propMap.get((Object)key) != null) {
            return (T)this.propMap.get((Object)key);
        }
        return defaultValue;
    }

    public Properties getSolrProperties(String path) {
        try {
            return this.readProperties(((NodeList)this.config.evaluate(path, XPathConstants.NODESET)).item(0));
        }
        catch (Exception e) {
            SolrException.log(log, null, e);
            return null;
        }
    }

    protected Properties readProperties(Node node) throws XPathExpressionException {
        XPath xpath = this.config.getXPath();
        NodeList props = (NodeList)xpath.evaluate("property", node, XPathConstants.NODESET);
        Properties properties = new Properties();
        for (int i = 0; i < props.getLength(); ++i) {
            Node prop = props.item(i);
            properties.setProperty(DOMUtil.getAttr(prop, "name"), PropertiesUtil.substituteProperty(DOMUtil.getAttr(prop, "value"), null));
        }
        return properties;
    }

    protected static enum CfgProp {
        SOLR_ADMINHANDLER,
        SOLR_COLLECTIONSHANDLER,
        SOLR_CORELOADTHREADS,
        SOLR_COREROOTDIRECTORY,
        SOLR_DISTRIBUPDATECONNTIMEOUT,
        SOLR_DISTRIBUPDATESOTIMEOUT,
        SOLR_MAXUPDATECONNECTIONS,
        SOLR_MAXUPDATECONNECTIONSPERHOST,
        SOLR_HOST,
        SOLR_HOSTCONTEXT,
        SOLR_HOSTPORT,
        SOLR_INFOHANDLER,
        SOLR_LEADERVOTEWAIT,
        SOLR_LOGGING_CLASS,
        SOLR_LOGGING_ENABLED,
        SOLR_LOGGING_WATCHER_SIZE,
        SOLR_LOGGING_WATCHER_THRESHOLD,
        SOLR_MANAGEMENTPATH,
        SOLR_SHAREDLIB,
        SOLR_SHARESCHEMA,
        SOLR_TRANSIENTCACHESIZE,
        SOLR_GENERICCORENODENAMES,
        SOLR_ZKCLIENTTIMEOUT,
        SOLR_ZKHOST,
        SOLR_LEADERCONFLICTRESOLVEWAIT,
        SOLR_CONFIGSETBASEDIR,
        SOLR_AUTOREPLICAFAILOVERWAITAFTEREXPIRATION,
        SOLR_AUTOREPLICAFAILOVERWORKLOOPDELAY,
        SOLR_AUTOREPLICAFAILOVERBADNODEEXPIRATION,
        SOLR_PERSISTENT,
        SOLR_CORES_DEFAULT_CORE_NAME,
        SOLR_ADMINPATH;

    }
}

