/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.CloudUtil;
import org.apache.solr.cloud.CurrentCoreDescriptorProvider;
import org.apache.solr.cloud.DistributedMap;
import org.apache.solr.cloud.DistributedQueue;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerElectionContext;
import org.apache.solr.cloud.ShardLeaderElectionContext;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.BeforeReconnect;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.ClusterStateUtil;
import org.apache.solr.common.cloud.DefaultConnectionStrategy;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.URLUtil;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZkController {
    private static Logger log = LoggerFactory.getLogger(ZkController.class);
    static final String NEWL = System.getProperty("line.separator");
    private final boolean SKIP_AUTO_RECOVERY = Boolean.getBoolean("solrcloud.skip.autorecovery");
    private final DistributedQueue overseerJobQueue;
    private final DistributedQueue overseerCollectionQueue;
    private final DistributedMap overseerRunningMap;
    private final DistributedMap overseerCompletedMap;
    private final DistributedMap overseerFailureMap;
    public static final String CONFIGS_ZKNODE = "/configs";
    public static final String COLLECTION_PARAM_PREFIX = "collection.";
    public static final String CONFIGNAME_PROP = "configName";
    private final Map<ContextKey, ElectionContext> electionContexts = Collections.synchronizedMap(new HashMap());
    private final SolrZkClient zkClient;
    private final ZkCmdExecutor cmdExecutor;
    private final ZkStateReader zkStateReader;
    private final LeaderElector leaderElector;
    private final String zkServerAddress;
    private final String localHostPort;
    private final String localHostContext;
    private final String hostName;
    private final String nodeName;
    private final String baseURL;
    private LeaderElector overseerElector;
    private CoreContainer cc;
    protected volatile Overseer overseer;
    private int leaderVoteWait;
    private int leaderConflictResolveWait;
    private boolean genericCoreNodeNames;
    private int clientTimeout;
    private volatile boolean isClosed;
    private Map<String, String> replicasInLeaderInitiatedRecovery = new HashMap<String, String>();
    private boolean zkRunOnly = Boolean.getBoolean("zkRunOnly");

    public ZkController(final CoreContainer cc, String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout, String localHost, String locaHostPort, String localHostContext, int leaderVoteWait, int leaderConflictResolveWait, boolean genericCoreNodeNames, final CurrentCoreDescriptorProvider registerOnReconnect) throws InterruptedException, TimeoutException, IOException {
        if (cc == null) {
            throw new IllegalArgumentException("CoreContainer cannot be null.");
        }
        this.cc = cc;
        this.genericCoreNodeNames = genericCoreNodeNames;
        localHostContext = ZkController.trimLeadingAndTrailingSlashes(localHostContext);
        this.zkServerAddress = zkServerAddress;
        this.localHostPort = locaHostPort;
        this.localHostContext = localHostContext;
        this.hostName = this.normalizeHostName(localHost);
        this.nodeName = ZkController.generateNodeName(this.hostName, this.localHostPort, this.localHostContext);
        this.leaderVoteWait = leaderVoteWait;
        this.leaderConflictResolveWait = leaderConflictResolveWait;
        this.clientTimeout = zkClientTimeout;
        this.zkClient = new SolrZkClient(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, new DefaultConnectionStrategy(), new OnReconnect(){

            @Override
            public void command() {
                try {
                    cc.cancelCoreRecoveries();
                    ZkController.this.registerAllCoresAsDown(registerOnReconnect, false);
                    if (!ZkController.this.zkRunOnly) {
                        OverseerElectionContext context = new OverseerElectionContext(ZkController.this.zkClient, ZkController.this.overseer, ZkController.this.getNodeName());
                        ElectionContext prevContext = ZkController.this.overseerElector.getContext();
                        if (prevContext != null) {
                            prevContext.cancelElection();
                        }
                        ZkController.this.overseerElector.setup(context);
                        ZkController.this.overseerElector.joinElection(context, true);
                    }
                    ZkController.this.zkStateReader.createClusterStateWatchersAndUpdate();
                    ZkController.this.createEphemeralLiveNode();
                    List<CoreDescriptor> descriptors = registerOnReconnect.getCurrentDescriptors();
                    if (descriptors != null) {
                        for (CoreDescriptor descriptor : descriptors) {
                            try {
                                ZkController.this.throwErrorIfReplicaReplaced(descriptor);
                                ZkController.this.register(descriptor.getName(), descriptor, true, true);
                            }
                            catch (Exception e) {
                                SolrException.log(log, "Error registering SolrCore", e);
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                catch (Exception e) {
                    SolrException.log(log, "", e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
            }
        }, new BeforeReconnect(){

            @Override
            public void command() {
                try {
                    ZkController.this.overseer.close();
                }
                catch (Exception e) {
                    log.error("Error trying to stop any Overseer threads", e);
                }
                ZkController.this.markAllAsNotLeader(registerOnReconnect);
            }
        });
        this.overseerJobQueue = Overseer.getInQueue(this.zkClient);
        this.overseerCollectionQueue = Overseer.getCollectionQueue(this.zkClient);
        this.overseerRunningMap = Overseer.getRunningMap(this.zkClient);
        this.overseerCompletedMap = Overseer.getCompletedMap(this.zkClient);
        this.overseerFailureMap = Overseer.getFailureMap(this.zkClient);
        this.cmdExecutor = new ZkCmdExecutor(zkClientTimeout);
        this.leaderElector = new LeaderElector(this.zkClient);
        this.zkStateReader = new ZkStateReader(this.zkClient);
        this.baseURL = this.zkStateReader.getBaseUrlForNodeName(this.nodeName);
        this.init(registerOnReconnect);
    }

    public int getLeaderVoteWait() {
        return this.leaderVoteWait;
    }

    public int getLeaderConflictResolveWait() {
        return this.leaderConflictResolveWait;
    }

    private void registerAllCoresAsDown(CurrentCoreDescriptorProvider registerOnReconnect, boolean updateLastPublished) {
        List<CoreDescriptor> descriptors = registerOnReconnect.getCurrentDescriptors();
        if (this.isClosed) {
            return;
        }
        if (descriptors != null) {
            for (CoreDescriptor descriptor : descriptors) {
                try {
                    descriptor.getCloudDescriptor().setLeader(false);
                    this.publish(descriptor, "down", updateLastPublished);
                }
                catch (Exception e) {
                    if (this.isClosed) {
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    try {
                        this.publish(descriptor, "down");
                    }
                    catch (Exception e2) {
                        SolrException.log(log, "", e2);
                    }
                }
            }
            for (CoreDescriptor descriptor : descriptors) {
                CloudDescriptor cloudDesc = descriptor.getCloudDescriptor();
                String collection = cloudDesc.getCollectionName();
                String slice = cloudDesc.getShardId();
                try {
                    int children = this.zkStateReader.getZkClient().getChildren("/collections/" + collection + "/leader_elect/" + slice + "/election", null, true).size();
                    if (children == 0) {
                        log.debug("looks like we are going to be the leader for collection {} shard {}", (Object)collection, (Object)slice);
                        continue;
                    }
                }
                catch (KeeperException.NoNodeException e) {
                    log.debug("looks like we are going to be the leader for collection {} shard {}", (Object)collection, (Object)slice);
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
                catch (KeeperException e) {
                    log.warn("", e);
                    Thread.currentThread().interrupt();
                }
                String coreZkNodeName = descriptor.getCloudDescriptor().getCoreNodeName();
                try {
                    log.debug("calling waitForLeaderToSeeDownState for coreZkNodeName={} collection={} shard={}", coreZkNodeName, collection, slice);
                    this.waitForLeaderToSeeDownState(descriptor, coreZkNodeName);
                }
                catch (Exception e) {
                    SolrException.log(log, "", e);
                    if (this.isClosed) {
                        return;
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    private void markAllAsNotLeader(CurrentCoreDescriptorProvider registerOnReconnect) {
        List<CoreDescriptor> descriptors = registerOnReconnect.getCurrentDescriptors();
        if (descriptors != null) {
            for (CoreDescriptor descriptor : descriptors) {
                descriptor.getCloudDescriptor().setLeader(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.isClosed = true;
        try {
            for (ElectionContext context : this.electionContexts.values()) {
                try {
                    context.close();
                }
                catch (Exception e) {
                    log.error("Error closing overseer", e);
                }
            }
        }
        finally {
            try {
                try {
                    this.overseer.close();
                }
                catch (Exception e) {
                    log.error("Error closing overseer", e);
                }
            }
            finally {
                try {
                    try {
                        this.zkStateReader.close();
                    }
                    catch (Exception e) {
                        log.error("Error closing zkStateReader", e);
                    }
                }
                finally {
                    try {
                        this.zkClient.close();
                    }
                    catch (Exception e) {
                        log.error("Error closing zkClient", e);
                    }
                }
            }
        }
    }

    public boolean configFileExists(String collection, String fileName) throws KeeperException, InterruptedException {
        Stat stat = this.zkClient.exists("/configs/" + collection + "/" + fileName, null, true);
        return stat != null;
    }

    public ClusterState getClusterState() {
        return this.zkStateReader.getClusterState();
    }

    public byte[] getConfigFileData(String zkConfigName, String fileName) throws KeeperException, InterruptedException {
        String zkPath = "/configs/" + zkConfigName + "/" + fileName;
        byte[] bytes = this.zkClient.getData(zkPath, null, null, true);
        if (bytes == null) {
            log.error("Config file contains no data:" + zkPath);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Config file contains no data:" + zkPath);
        }
        return bytes;
    }

    private String normalizeHostName(String host) throws IOException {
        if (host == null || host.length() == 0) {
            String hostaddress;
            try {
                hostaddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                hostaddress = "127.0.0.1";
            }
            if ("127.0.0.1".equals(hostaddress)) {
                Enumeration<NetworkInterface> netInterfaces = null;
                try {
                    netInterfaces = NetworkInterface.getNetworkInterfaces();
                    while (netInterfaces.hasMoreElements()) {
                        NetworkInterface ni = netInterfaces.nextElement();
                        Enumeration<InetAddress> ips = ni.getInetAddresses();
                        while (ips.hasMoreElements()) {
                            InetAddress ip = ips.nextElement();
                            if (!ip.isSiteLocalAddress()) continue;
                            hostaddress = ip.getHostAddress();
                        }
                    }
                }
                catch (Exception e) {
                    SolrException.log(log, "Error while looking for a better host name than 127.0.0.1", e);
                }
            }
            host = hostaddress;
        } else if (URLUtil.hasScheme(host)) {
            host = URLUtil.removeScheme(host);
        }
        return host;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostPort() {
        return this.localHostPort;
    }

    public SolrZkClient getZkClient() {
        return this.zkClient;
    }

    public String getZkServerAddress() {
        return this.zkServerAddress;
    }

    private void init(CurrentCoreDescriptorProvider registerOnReconnect) {
        try {
            boolean createdWatchesAndUpdated = false;
            Stat stat = this.zkClient.exists("/live_nodes", null, true);
            if (stat != null && stat.getNumChildren() > 0) {
                this.zkStateReader.createClusterStateWatchersAndUpdate();
                createdWatchesAndUpdated = true;
                this.publishAndWaitForDownStates();
            }
            this.cmdExecutor.ensureExists("/live_nodes", this.zkClient);
            this.createEphemeralLiveNode();
            this.cmdExecutor.ensureExists("/collections", this.zkClient);
            ShardHandler shardHandler = this.cc.getShardHandlerFactory().getShardHandler();
            UpdateShardHandler updateShardHandler = this.cc.getUpdateShardHandler();
            String adminPath = this.cc.getAdminPath();
            if (!this.zkRunOnly) {
                this.overseerElector = new LeaderElector(this.zkClient);
                this.overseer = new Overseer(shardHandler, updateShardHandler, adminPath, this.zkStateReader, this, this.cc.getConfig());
                OverseerElectionContext context = new OverseerElectionContext(this.zkClient, this.overseer, this.getNodeName());
                this.overseerElector.setup(context);
                this.overseerElector.joinElection(context, false);
            }
            if (!createdWatchesAndUpdated) {
                this.zkStateReader.createClusterStateWatchersAndUpdate();
            }
        }
        catch (IOException e) {
            log.error("", e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can't create ZooKeeperController", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (KeeperException e) {
            log.error("", e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
    }

    public void publishAndWaitForDownStates() throws KeeperException, InterruptedException {
        ClusterState clusterState = this.zkStateReader.getClusterState();
        Set<String> collections = clusterState.getCollections();
        ArrayList<String> updatedNodes = new ArrayList<String>();
        for (String collectionName : collections) {
            DocCollection collection = clusterState.getCollection(collectionName);
            Collection<Slice> slices = collection.getSlices();
            for (Slice slice : slices) {
                Collection<Replica> replicas = slice.getReplicas();
                for (Replica replica : replicas) {
                    if (!this.getNodeName().equals(replica.getNodeName()) || replica.getStr("state").equals("down")) continue;
                    ZkNodeProps m = new ZkNodeProps("operation", "state", "state", "down", "base_url", this.getBaseUrl(), "core", replica.getStr("core"), "roles", replica.getStr("roles"), "node_name", this.getNodeName(), "shard", replica.getStr("shard"), "collection", collectionName, "core_node_name", replica.getName());
                    updatedNodes.add(replica.getStr("core"));
                    this.overseerJobQueue.offer(ZkStateReader.toJSON(m));
                }
            }
        }
        long now = System.nanoTime();
        long timeout = now + TimeUnit.NANOSECONDS.convert(60L, TimeUnit.SECONDS);
        boolean foundStates = false;
        while (System.nanoTime() < timeout) {
            clusterState = this.zkStateReader.getClusterState();
            collections = clusterState.getCollections();
            for (String collectionName : collections) {
                DocCollection collection = clusterState.getCollection(collectionName);
                Collection<Slice> slices = collection.getSlices();
                for (Slice slice : slices) {
                    Collection<Replica> replicas = slice.getReplicas();
                    for (Replica replica : replicas) {
                        if (!replica.getStr("state").equals("down")) continue;
                        updatedNodes.remove(replica.getStr("core"));
                    }
                }
            }
            if (updatedNodes.size() == 0) {
                foundStates = true;
                Thread.sleep(1000L);
                break;
            }
            Thread.sleep(1000L);
        }
        if (!foundStates) {
            log.warn("Timed out waiting to see all nodes published as DOWN in our cluster state.");
        }
    }

    public static boolean checkChrootPath(String zkHost, boolean create) throws KeeperException, InterruptedException {
        if (!ZkController.containsChroot(zkHost)) {
            return true;
        }
        log.info("zkHost includes chroot");
        String chrootPath = zkHost.substring(zkHost.indexOf("/"), zkHost.length());
        SolrZkClient tmpClient = new SolrZkClient(zkHost.substring(0, zkHost.indexOf("/")), 60000);
        boolean exists = tmpClient.exists(chrootPath, true);
        if (!exists && create) {
            tmpClient.makePath(chrootPath, false, true);
            exists = true;
        }
        tmpClient.close();
        return exists;
    }

    private static boolean containsChroot(String zkHost) {
        return zkHost.contains("/");
    }

    public boolean isConnected() {
        return this.zkClient.isConnected();
    }

    private void createEphemeralLiveNode() throws KeeperException, InterruptedException {
        block6: {
            if (this.zkRunOnly) {
                return;
            }
            String nodeName = this.getNodeName();
            String nodePath = "/live_nodes/" + nodeName;
            log.info("Register node as live in ZooKeeper:" + nodePath);
            try {
                boolean nodeDeleted = true;
                try {
                    this.zkClient.delete(nodePath, -1, true);
                }
                catch (KeeperException.NoNodeException e) {
                    nodeDeleted = false;
                }
                if (nodeDeleted) {
                    log.info("Found a previous node that still exists while trying to register a new live node " + nodePath + " - removing existing node to create another.");
                }
                this.zkClient.makePath(nodePath, CreateMode.EPHEMERAL, true);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) break block6;
                throw e;
            }
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean pathExists(String path) throws KeeperException, InterruptedException {
        return this.zkClient.exists(path, true);
    }

    public String register(String coreName, CoreDescriptor desc) throws Exception {
        return this.register(coreName, desc, false, false);
    }

    public String register(String coreName, CoreDescriptor desc, boolean recoverReloadedCores, boolean afterExpiration) throws Exception {
        String baseUrl = this.getBaseUrl();
        CloudDescriptor cloudDesc = desc.getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        String coreZkNodeName = desc.getCloudDescriptor().getCoreNodeName();
        assert (coreZkNodeName != null) : "we should have a coreNodeName by now";
        String shardId = cloudDesc.getShardId();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("base_url", baseUrl);
        props.put("core", coreName);
        props.put("node_name", this.getNodeName());
        if (log.isInfoEnabled()) {
            log.info("Register replica - core:" + coreName + " address:" + baseUrl + " collection:" + cloudDesc.getCollectionName() + " shard:" + shardId);
        }
        ZkNodeProps leaderProps = new ZkNodeProps(props);
        try {
            this.joinElection(desc, afterExpiration);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (IOException e) {
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        String leaderUrl = this.getLeader(cloudDesc, this.leaderVoteWait + 600000);
        String ourUrl = ZkCoreNodeProps.getCoreUrl(baseUrl, coreName);
        log.info("We are " + ourUrl + " and leader is " + leaderUrl);
        boolean isLeader = leaderUrl.equals(ourUrl);
        try (SolrCore core = this.cc.getCore(desc.getName());){
            UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
            if (!core.isReloaded() && ulog != null) {
                boolean didRecovery;
                Slice slice = this.getClusterState().getSlice(collection, shardId);
                if (!Slice.CONSTRUCTION.equals(slice.getState()) || !isLeader) {
                    Future<UpdateLog.RecoveryInfo> recoveryFuture = core.getUpdateHandler().getUpdateLog().recoverFromLog();
                    if (recoveryFuture != null) {
                        log.info("Replaying tlog for " + ourUrl + " during startup... NOTE: This can take a while.");
                        recoveryFuture.get();
                    } else {
                        log.info("No LogReplay needed for core=" + core.getName() + " baseURL=" + baseUrl);
                    }
                }
                if (!(didRecovery = this.checkRecovery(coreName, desc, recoverReloadedCores, isLeader, cloudDesc, collection, coreZkNodeName, shardId, leaderProps, core, this.cc))) {
                    this.publish(desc, "active");
                }
            }
        }
        this.zkStateReader.updateClusterState(true);
        return shardId;
    }

    private String getLeader(CloudDescriptor cloudDesc, int timeoutms) {
        String leaderUrl;
        String collection = cloudDesc.getCollectionName();
        String shardId = cloudDesc.getShardId();
        try {
            leaderUrl = this.getLeaderProps(collection, cloudDesc.getShardId(), timeoutms).getCoreUrl();
            String clusterStateLeaderUrl = this.zkStateReader.getLeaderUrl(collection, shardId, timeoutms * 2);
            int tries = 0;
            long msInSec = 1000L;
            int maxTries = (int)Math.floor((long)this.leaderConflictResolveWait / 1000L);
            while (!leaderUrl.equals(clusterStateLeaderUrl)) {
                if (tries > maxTries) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There is conflicting information about the leader of shard: " + cloudDesc.getShardId() + " our state says:" + clusterStateLeaderUrl + " but zookeeper says:" + leaderUrl);
                }
                if (++tries % 30 == 0) {
                    String warnMsg = String.format(Locale.ENGLISH, "Still seeing conflicting information about the leader of shard %s for collection %s after %d seconds; our state says %s, but ZooKeeper says %s", cloudDesc.getShardId(), collection, tries, clusterStateLeaderUrl, leaderUrl);
                    log.warn(warnMsg);
                }
                Thread.sleep(1000L);
                clusterStateLeaderUrl = this.zkStateReader.getLeaderUrl(collection, shardId, timeoutms);
                leaderUrl = this.getLeaderProps(collection, cloudDesc.getShardId(), timeoutms).getCoreUrl();
            }
        }
        catch (Exception e) {
            log.error("Error getting leader from zk", e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error getting leader from zk for shard " + shardId, (Throwable)e);
        }
        return leaderUrl;
    }

    public ZkCoreNodeProps getLeaderProps(String collection, String slice, int timeoutms) throws InterruptedException {
        return this.getLeaderProps(collection, slice, timeoutms, false);
    }

    public ZkCoreNodeProps getLeaderProps(String collection, String slice, int timeoutms, boolean failImmediatelyOnExpiration) throws InterruptedException {
        int iterCount = timeoutms / 1000;
        Exception exp = null;
        while (iterCount-- > 0) {
            try {
                byte[] data = this.zkClient.getData(ZkStateReader.getShardLeadersPath(collection, slice), null, null, true);
                ZkCoreNodeProps leaderProps = new ZkCoreNodeProps(ZkNodeProps.load(data));
                return leaderProps;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (KeeperException.SessionExpiredException e) {
                if (failImmediatelyOnExpiration) {
                    throw new RuntimeException("Session has expired - could not get leader props", exp);
                }
                exp = e;
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                exp = e;
                Thread.sleep(1000L);
            }
            if (!this.cc.isShutDown()) continue;
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "CoreContainer is shutdown");
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Could not get leader props", (Throwable)exp);
    }

    private void joinElection(CoreDescriptor cd, boolean afterExpiration) throws InterruptedException, KeeperException, IOException {
        String coreNodeName;
        String collection = cd.getCloudDescriptor().getCollectionName();
        ContextKey contextKey = new ContextKey(collection, coreNodeName = cd.getCloudDescriptor().getCoreNodeName());
        ElectionContext prevContext = this.electionContexts.get(contextKey);
        if (prevContext != null) {
            prevContext.cancelElection();
        }
        String shardId = cd.getCloudDescriptor().getShardId();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("base_url", this.getBaseUrl());
        props.put("core", cd.getName());
        props.put("node_name", this.getNodeName());
        ZkNodeProps ourProps = new ZkNodeProps(props);
        ShardLeaderElectionContext context = new ShardLeaderElectionContext(this.leaderElector, shardId, collection, coreNodeName, ourProps, this, this.cc);
        this.leaderElector.setup(context);
        this.electionContexts.put(contextKey, context);
        this.leaderElector.joinElection(context, false);
    }

    private boolean checkRecovery(String coreName, CoreDescriptor desc, boolean recoverReloadedCores, boolean isLeader, CloudDescriptor cloudDesc, String collection, String shardZkNodeName, String shardId, ZkNodeProps leaderProps, SolrCore core, CoreContainer cc) {
        if (this.SKIP_AUTO_RECOVERY) {
            log.warn("Skipping recovery according to sys prop solrcloud.skip.autorecovery");
            return false;
        }
        boolean doRecovery = true;
        if (!isLeader) {
            if (core.isReloaded() && !recoverReloadedCores) {
                doRecovery = false;
            }
            if (doRecovery) {
                log.info("Core needs to recover:" + core.getName());
                core.getUpdateHandler().getSolrCoreState().doRecovery(cc, core.getCoreDescriptor());
                return true;
            }
            String lirState = this.getLeaderInitiatedRecoveryState(collection, shardId, core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
            if ("down".equals(lirState)) {
                log.info("Leader marked core " + core.getName() + " down; starting recovery process");
                core.getUpdateHandler().getSolrCoreState().doRecovery(cc, core.getCoreDescriptor());
                return true;
            }
        } else {
            log.info("I am the leader, no recovery necessary");
        }
        return false;
    }

    public String getBaseUrl() {
        return this.baseURL;
    }

    public void publish(CoreDescriptor cd, String state) throws KeeperException, InterruptedException {
        this.publish(cd, state, true);
    }

    public void publish(CoreDescriptor cd, String state, boolean updateLastState) throws KeeperException, InterruptedException {
        this.publish(cd, state, true, false);
    }

    public void publish(CoreDescriptor cd, String state, boolean updateLastState, boolean forcePublish) throws KeeperException, InterruptedException {
        String lirState;
        if (!forcePublish) {
            try (SolrCore core = this.cc.getCore(cd.getName());){
                if (core == null || core.isClosed()) {
                    return;
                }
            }
        }
        String collection = cd.getCloudDescriptor().getCollectionName();
        log.info("publishing core={} state={} collection={}", cd.getName(), state, collection);
        Integer numShards = cd.getCloudDescriptor().getNumShards();
        if (numShards == null) {
            log.info("numShards not found on descriptor - reading it from system property");
            numShards = Integer.getInteger("numShards");
        }
        assert (collection != null && collection.length() > 0);
        String shardId = cd.getCloudDescriptor().getShardId();
        String coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
        if (!"down".equals(state) && (lirState = this.getLeaderInitiatedRecoveryState(collection, shardId, coreNodeName)) != null) {
            if ("active".equals(state)) {
                if ("recovering".equals(lirState)) {
                    this.updateLeaderInitiatedRecoveryState(collection, shardId, coreNodeName, "active");
                } else if ("down".equals(lirState)) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot publish state of core '" + cd.getName() + "' as active without recovering first!");
                }
            } else if ("recovering".equals(state) && "down".equals(lirState)) {
                this.updateLeaderInitiatedRecoveryState(collection, shardId, coreNodeName, "recovering");
            }
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("operation", "state");
        props.put("state", state);
        props.put("base_url", this.getBaseUrl());
        props.put("core", cd.getName());
        props.put("roles", cd.getCloudDescriptor().getRoles());
        props.put("node_name", this.getNodeName());
        props.put("shard", cd.getCloudDescriptor().getShardId());
        props.put("collection", collection);
        if (numShards != null) {
            props.put("numShards", numShards.toString());
        }
        if (coreNodeName != null) {
            props.put("core_node_name", coreNodeName);
        }
        if (ClusterStateUtil.isAutoAddReplicas(this.getZkStateReader(), collection)) {
            try (SolrCore core = this.cc.getCore(cd.getName());){
                if (core != null && core.getDirectoryFactory().isSharedStorage()) {
                    props.put("dataDir", core.getDataDir());
                    UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
                    if (ulog != null) {
                        props.put("ulogDir", ulog.getLogDir());
                    }
                }
            }
        }
        ZkNodeProps m = new ZkNodeProps(props);
        if (updateLastState) {
            cd.getCloudDescriptor().lastPublished = state;
        }
        this.overseerJobQueue.offer(ZkStateReader.toJSON(m));
    }

    private boolean needsToBeAssignedShardId(CoreDescriptor desc, ClusterState state, String coreNodeName) {
        CloudDescriptor cloudDesc = desc.getCloudDescriptor();
        String shardId = state.getShardId(this.getNodeName(), desc.getName());
        if (shardId != null) {
            cloudDesc.setShardId(shardId);
            return false;
        }
        return true;
    }

    public void unregister(String coreName, CoreDescriptor cd) throws InterruptedException, KeeperException {
        String coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
        String collection = cd.getCloudDescriptor().getCollectionName();
        assert (collection != null);
        if (collection == null || collection.trim().length() == 0) {
            log.error("No collection was specified.");
            return;
        }
        ElectionContext context = this.electionContexts.remove(new ContextKey(collection, coreNodeName));
        if (context != null) {
            context.cancelElection();
        }
        CloudDescriptor cloudDescriptor = cd.getCloudDescriptor();
        ZkNodeProps m = new ZkNodeProps("operation", "deletecore", "core", coreName, "node_name", this.getNodeName(), "collection", cloudDescriptor.getCollectionName(), "core_node_name", coreNodeName);
        this.overseerJobQueue.offer(ZkStateReader.toJSON(m));
    }

    public void createCollection(String collection) throws KeeperException, InterruptedException {
        ZkNodeProps m = new ZkNodeProps("operation", "createcollection", "node_name", this.getNodeName(), "collection", collection);
        this.overseerJobQueue.offer(ZkStateReader.toJSON(m));
    }

    public void uploadToZK(File dir, String zkPath) throws IOException, KeeperException, InterruptedException {
        ZkController.uploadToZK(this.zkClient, dir, zkPath);
    }

    public void uploadConfigDir(File dir, String configName) throws IOException, KeeperException, InterruptedException {
        ZkController.uploadToZK(this.zkClient, dir, "/configs/" + configName);
    }

    void printLayoutToStdOut() throws KeeperException, InterruptedException {
        this.zkClient.printLayoutToStdOut();
    }

    public void createCollectionZkNode(CloudDescriptor cd) {
        block18: {
            String collection = cd.getCollectionName();
            log.info("Check for collection zkNode:" + collection);
            String collectionPath = "/collections/" + collection;
            try {
                if (!this.zkClient.exists(collectionPath, true).booleanValue()) {
                    log.info("Creating collection in ZooKeeper:" + collection);
                    SolrParams params = cd.getParams();
                    try {
                        HashMap<String, Object> collectionProps = new HashMap<String, Object>();
                        String defaultConfigName = System.getProperty("collection.configName", collection);
                        if (params != null) {
                            Iterator<String> iter = params.getParameterNamesIterator();
                            while (iter.hasNext()) {
                                String paramName = iter.next();
                                if (!paramName.startsWith(COLLECTION_PARAM_PREFIX)) continue;
                                collectionProps.put(paramName.substring(COLLECTION_PARAM_PREFIX.length()), params.get(paramName));
                            }
                            if (!collectionProps.containsKey(CONFIGNAME_PROP)) {
                                this.getConfName(collection, collectionPath, collectionProps);
                            }
                        } else if (System.getProperty("bootstrap_confdir") != null) {
                            log.info("Setting config for collection:" + collection + " to " + defaultConfigName);
                            Properties sysProps = System.getProperties();
                            for (String sprop : System.getProperties().stringPropertyNames()) {
                                if (!sprop.startsWith(COLLECTION_PARAM_PREFIX)) continue;
                                collectionProps.put(sprop.substring(COLLECTION_PARAM_PREFIX.length()), sysProps.getProperty(sprop));
                            }
                            if (!collectionProps.containsKey(CONFIGNAME_PROP)) {
                                collectionProps.put(CONFIGNAME_PROP, defaultConfigName);
                            }
                        } else if (Boolean.getBoolean("bootstrap_conf")) {
                            collectionProps.put(CONFIGNAME_PROP, cd.getCollectionName());
                        } else {
                            this.getConfName(collection, collectionPath, collectionProps);
                        }
                        collectionProps.remove("numShards");
                        ZkNodeProps zkProps = new ZkNodeProps(collectionProps);
                        this.zkClient.makePath(collectionPath, ZkStateReader.toJSON(zkProps), CreateMode.PERSISTENT, null, true);
                        break block18;
                    }
                    catch (KeeperException e) {
                        if (e.code() != KeeperException.Code.NODEEXISTS) {
                            throw e;
                        }
                        break block18;
                    }
                }
                log.info("Collection zkNode exists");
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) {
                    return;
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error creating collection node in Zookeeper", (Throwable)e);
            }
        }
    }

    private void getConfName(String collection, String collectionPath, Map<String, Object> collectionProps) throws KeeperException, InterruptedException {
        ZkNodeProps cProps;
        int retry;
        log.info("Looking for collection configName");
        List<String> configNames = null;
        int retryLimt = 6;
        for (retry = 1; !(retry >= retryLimt || this.zkClient.exists(collectionPath, true).booleanValue() && (cProps = ZkNodeProps.load(this.zkClient.getData(collectionPath, null, null, true))).containsKey(CONFIGNAME_PROP)); ++retry) {
            try {
                configNames = this.zkClient.getChildren(CONFIGS_ZKNODE, null, true);
            }
            catch (KeeperException.NoNodeException e) {
                // empty catch block
            }
            if (configNames != null && configNames.size() == 1) {
                log.info("Only one config set found in zk - using it:" + configNames.get(0));
                collectionProps.put(CONFIGNAME_PROP, configNames.get(0));
                break;
            }
            if (configNames != null && configNames.contains(collection)) {
                log.info("Could not find explicit collection configName, but found config name matching collection name - using that set.");
                collectionProps.put(CONFIGNAME_PROP, collection);
                break;
            }
            log.info("Could not find collection configName - pausing for 3 seconds and trying again - try: " + retry);
            Thread.sleep(3000L);
        }
        if (retry == retryLimt) {
            log.error("Could not find configName for collection " + collection);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find configName for collection " + collection + " found:" + configNames);
        }
    }

    public ZkStateReader getZkStateReader() {
        return this.zkStateReader;
    }

    private void doGetShardIdAndNodeNameProcess(CoreDescriptor cd) {
        String coreNodeName = cd.getCloudDescriptor().getCoreNodeName();
        if (coreNodeName != null) {
            this.waitForShardId(cd);
        } else {
            this.waitForCoreNodeName(cd);
            this.waitForShardId(cd);
        }
    }

    private void waitForCoreNodeName(CoreDescriptor descriptor) {
        int retryCount = 320;
        log.info("look for our core node name");
        while (retryCount-- > 0) {
            Map<String, Slice> slicesMap = this.zkStateReader.getClusterState().getSlicesMap(descriptor.getCloudDescriptor().getCollectionName());
            if (slicesMap != null) {
                for (Slice slice : slicesMap.values()) {
                    for (Replica replica : slice.getReplicas()) {
                        String nodeName = replica.getStr("node_name");
                        String core = replica.getStr("core");
                        String msgNodeName = this.getNodeName();
                        String msgCore = descriptor.getName();
                        if (!msgNodeName.equals(nodeName) || !core.equals(msgCore)) continue;
                        descriptor.getCloudDescriptor().setCoreNodeName(replica.getName());
                        return;
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void waitForShardId(CoreDescriptor cd) {
        log.info("waiting to find shard id in clusterstate for " + cd.getName());
        int retryCount = 320;
        while (retryCount-- > 0) {
            String shardId = this.zkStateReader.getClusterState().getShardId(this.getNodeName(), cd.getName());
            if (shardId != null) {
                cd.getCloudDescriptor().setShardId(shardId);
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not get shard id for core: " + cd.getName());
    }

    public static void uploadToZK(SolrZkClient zkClient, File dir, String zkPath) throws IOException, KeeperException, InterruptedException {
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("Illegal directory: " + dir);
        }
        for (File file : files) {
            if (file.getName().startsWith(".")) continue;
            if (!file.isDirectory()) {
                zkClient.makePath(zkPath + "/" + file.getName(), file, false, true);
                continue;
            }
            ZkController.uploadToZK(zkClient, file, zkPath + "/" + file.getName());
        }
    }

    public static void downloadFromZK(SolrZkClient zkClient, String zkPath, File dir) throws IOException, KeeperException, InterruptedException {
        List<String> files = zkClient.getChildren(zkPath, null, true);
        for (String file : files) {
            List<String> children = zkClient.getChildren(zkPath + "/" + file, null, true);
            if (children.size() == 0) {
                byte[] data = zkClient.getData(zkPath + "/" + file, null, null, true);
                dir.mkdirs();
                log.info("Write file " + new File(dir, file));
                FileUtils.writeByteArrayToFile(new File(dir, file), data);
                continue;
            }
            ZkController.downloadFromZK(zkClient, zkPath + "/" + file, new File(dir, file));
        }
    }

    public String getCoreNodeName(CoreDescriptor descriptor) {
        String coreNodeName = descriptor.getCloudDescriptor().getCoreNodeName();
        if (coreNodeName == null && !this.genericCoreNodeNames) {
            return this.getNodeName() + "_" + descriptor.getName();
        }
        return coreNodeName;
    }

    public static void uploadConfigDir(SolrZkClient zkClient, File dir, String configName) throws IOException, KeeperException, InterruptedException {
        ZkController.uploadToZK(zkClient, dir, "/configs/" + configName);
    }

    public static void downloadConfigDir(SolrZkClient zkClient, String configName, File dir) throws IOException, KeeperException, InterruptedException {
        ZkController.downloadFromZK(zkClient, "/configs/" + configName, dir);
    }

    public void preRegister(CoreDescriptor cd) {
        String coreNodeName = this.getCoreNodeName(cd);
        try {
            this.checkStateInZk(cd);
            CloudDescriptor cloudDesc = cd.getCloudDescriptor();
            if (cloudDesc.getCoreNodeName() == null) {
                cloudDesc.setCoreNodeName(coreNodeName);
            }
            this.publish(cd, "down", false, true);
        }
        catch (KeeperException e) {
            log.error("", e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        if (cd.getCloudDescriptor().getShardId() == null && this.needsToBeAssignedShardId(cd, this.zkStateReader.getClusterState(), coreNodeName)) {
            this.doGetShardIdAndNodeNameProcess(cd);
        } else {
            this.doGetShardIdAndNodeNameProcess(cd);
        }
    }

    private void checkStateInZk(CoreDescriptor cd) throws InterruptedException {
        if (!Overseer.isLegacy(this.zkStateReader.getClusterProps())) {
            CloudDescriptor cloudDesc = cd.getCloudDescriptor();
            String coreNodeName = cloudDesc.getCoreNodeName();
            assert (coreNodeName != null);
            if (cloudDesc.getShardId() == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No shard id for :" + cd);
            }
            long endTime = System.nanoTime() + TimeUnit.NANOSECONDS.convert(3L, TimeUnit.SECONDS);
            String errMessage = null;
            while (System.nanoTime() < endTime) {
                Thread.sleep(100L);
                errMessage = null;
                Slice slice = this.zkStateReader.getClusterState().getSlice(cd.getCollectionName(), cloudDesc.getShardId());
                if (slice == null) {
                    errMessage = "Invalid slice : " + cloudDesc.getShardId();
                    continue;
                }
                if (slice.getReplica(coreNodeName) == null) continue;
                return;
            }
            if (errMessage == null) {
                errMessage = " no_such_replica in clusterstate ,replicaName :  " + coreNodeName;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errMessage + "state : " + this.zkStateReader.getClusterState().getCollection(cd.getCollectionName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZkCoreNodeProps waitForLeaderToSeeDownState(CoreDescriptor descriptor, String coreZkNodeName) {
        CloudDescriptor cloudDesc = descriptor.getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        String shard = cloudDesc.getShardId();
        ZkCoreNodeProps leaderProps = null;
        int retries = 6;
        for (int i = 0; i < retries; ++i) {
            try {
                if (this.isClosed) {
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "We have been closed");
                }
                leaderProps = this.getLeaderProps(collection, shard, 30000);
                break;
            }
            catch (Exception e) {
                SolrException.log(log, "There was a problem finding the leader in zk", e);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                if (i != retries - 1) continue;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There was a problem finding the leader in zk");
            }
        }
        String leaderBaseUrl = leaderProps.getBaseUrl();
        String leaderCoreName = leaderProps.getCoreName();
        String myCoreNodeName = cloudDesc.getCoreNodeName();
        String myCoreName = descriptor.getName();
        String ourUrl = ZkCoreNodeProps.getCoreUrl(this.getBaseUrl(), myCoreName);
        boolean isLeader = leaderProps.getCoreUrl().equals(ourUrl);
        if (!isLeader && !this.SKIP_AUTO_RECOVERY) {
            String lirState = null;
            try {
                lirState = this.getLeaderInitiatedRecoveryState(collection, shard, myCoreNodeName);
            }
            catch (Exception exc) {
                log.error("Failed to determine if replica " + myCoreNodeName + " is in leader-initiated recovery due to: " + exc, exc);
            }
            if (lirState != null) {
                log.info("Replica " + myCoreNodeName + " is already in leader-initiated recovery, so not waiting for leader to see down state.");
            } else {
                log.info("Replica " + myCoreNodeName + " NOT in leader-initiated recovery, need to wait for leader to see down state.");
                HttpSolrServer server = null;
                server = new HttpSolrServer(leaderBaseUrl);
                try {
                    server.setConnectionTimeout(15000);
                    server.setSoTimeout(120000);
                    CoreAdminRequest.WaitForState prepCmd = new CoreAdminRequest.WaitForState();
                    prepCmd.setCoreName(leaderCoreName);
                    prepCmd.setNodeName(this.getNodeName());
                    prepCmd.setCoreNodeName(coreZkNodeName);
                    prepCmd.setState("down");
                    retries = 6;
                    for (int i = 0; i < retries; ++i) {
                        if (this.isClosed) {
                            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "We have been closed");
                        }
                        try {
                            server.request(prepCmd);
                            break;
                        }
                        catch (Exception e) {
                            SolrException.log(log, "There was a problem making a request to the leader", e);
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException e1) {
                                Thread.currentThread().interrupt();
                            }
                            if (i != retries - 1) continue;
                            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There was a problem making a request to the leader");
                        }
                    }
                }
                finally {
                    server.shutdown();
                }
            }
        }
        return leaderProps;
    }

    public static void linkConfSet(SolrZkClient zkClient, String collection, String confSetName) throws KeeperException, InterruptedException {
        byte[] data;
        String path = "/collections/" + collection;
        if (log.isInfoEnabled()) {
            log.info("Load collection config from:" + path);
        }
        try {
            data = zkClient.getData(path, null, null, true);
        }
        catch (KeeperException.NoNodeException e) {
            ZkNodeProps props = new ZkNodeProps(CONFIGNAME_PROP, confSetName);
            try {
                zkClient.makePath(path, ZkStateReader.toJSON(props), CreateMode.PERSISTENT, null, true);
            }
            catch (KeeperException e2) {
                if (e2.code() != KeeperException.Code.NODEEXISTS) {
                    throw e;
                }
                zkClient.setData(path, ZkStateReader.toJSON(props), true);
            }
            return;
        }
        ZkNodeProps props = null;
        if (data != null) {
            props = ZkNodeProps.load(data);
            HashMap<String, Object> newProps = new HashMap<String, Object>();
            newProps.putAll(props.getProperties());
            newProps.put(CONFIGNAME_PROP, confSetName);
            props = new ZkNodeProps(newProps);
        } else {
            props = new ZkNodeProps(CONFIGNAME_PROP, confSetName);
        }
        zkClient.setData(path, ZkStateReader.toJSON(props), true);
    }

    public static void bootstrapConf(SolrZkClient zkClient, CoreContainer cc, String solrHome) throws IOException, KeeperException, InterruptedException {
        List<CoreDescriptor> cds = cc.getCoresLocator().discover(cc);
        log.info("bootstrapping config for " + cds.size() + " cores into ZooKeeper using solr.xml from " + solrHome);
        for (CoreDescriptor cd : cds) {
            String coreName = cd.getName();
            String confName = cd.getCollectionName();
            if (StringUtils.isEmpty(confName)) {
                confName = coreName;
            }
            String instanceDir = cd.getInstanceDir();
            File udir = new File(instanceDir, "conf");
            log.info("Uploading directory " + udir + " with name " + confName + " for SolrCore " + coreName);
            ZkController.uploadConfigDir(zkClient, udir, confName);
        }
    }

    public DistributedQueue getOverseerJobQueue() {
        return this.overseerJobQueue;
    }

    public DistributedQueue getOverseerCollectionQueue() {
        return this.overseerCollectionQueue;
    }

    public DistributedMap getOverseerRunningMap() {
        return this.overseerRunningMap;
    }

    public DistributedMap getOverseerCompletedMap() {
        return this.overseerCompletedMap;
    }

    public DistributedMap getOverseerFailureMap() {
        return this.overseerFailureMap;
    }

    public int getClientTimeout() {
        return this.clientTimeout;
    }

    public Overseer getOverseer() {
        return this.overseer;
    }

    public LeaderElector getOverseerElector() {
        return this.overseerElector;
    }

    static String generateNodeName(String hostName, String hostPort, String hostContext) {
        try {
            return hostName + ':' + hostPort + '_' + URLEncoder.encode(ZkController.trimLeadingAndTrailingSlashes(hostContext), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("JVM Does not seem to support UTF-8", e);
        }
    }

    public static String trimLeadingAndTrailingSlashes(String in) {
        if (null == in) {
            return in;
        }
        String out = in;
        if (out.startsWith("/")) {
            out = out.substring(1);
        }
        if (out.endsWith("/")) {
            out = out.substring(0, out.length() - 1);
        }
        return out;
    }

    public void rejoinOverseerElection(String electionNode, boolean joinAtHead) {
        try {
            if (electionNode != null) {
                if (this.overseerElector.getContext() == null || this.overseerElector.getContext().leaderSeqPath == null) {
                    this.overseerElector.retryElection(new OverseerElectionContext(this.zkClient, this.overseer, this.getNodeName()), joinAtHead);
                    return;
                }
                if (!this.overseerElector.getContext().leaderSeqPath.endsWith(electionNode)) {
                    log.warn("Asked to rejoin with wrong election node : {}, current node is {}", (Object)electionNode, (Object)this.overseerElector.getContext().leaderSeqPath);
                    if (electionNode.startsWith(this.getNodeName())) {
                        try {
                            this.zkClient.delete("/overseer_elect/election/" + electionNode, -1, true);
                        }
                        catch (KeeperException.NoNodeException e) {
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception e) {
                            log.warn("Old election node exists , could not be removed ", e);
                        }
                    }
                }
            } else {
                this.overseerElector.retryElection(this.overseerElector.getContext(), joinAtHead);
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rejoin election", (Throwable)e);
        }
    }

    public void checkOverseerDesignate() {
        try {
            byte[] data = this.zkClient.getData("/roles.json", null, new Stat(), true);
            if (data == null) {
                return;
            }
            Map roles = (Map)ZkStateReader.fromJSON(data);
            if (roles == null) {
                return;
            }
            List nodeList = (List)roles.get("overseer");
            if (nodeList == null) {
                return;
            }
            if (nodeList.contains(this.getNodeName())) {
                ZkNodeProps props = new ZkNodeProps("operation", CollectionParams.CollectionAction.ADDROLE.toString().toLowerCase(Locale.ROOT), "node", this.getNodeName(), "role", "overseer");
                log.info("Going to add role {} ", (Object)props);
                this.getOverseerCollectionQueue().offer(ZkStateReader.toJSON(props));
            }
        }
        catch (KeeperException.NoNodeException nne) {
            return;
        }
        catch (Exception e) {
            log.warn("could not readd the overseer designate ", e);
        }
    }

    CoreContainer getCoreContainer() {
        return this.cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ensureReplicaInLeaderInitiatedRecovery(String collection, String shardId, String replicaUrl, ZkCoreNodeProps replicaCoreProps, boolean forcePublishState) throws KeeperException, InterruptedException {
        if (collection == null) {
            throw new IllegalArgumentException("collection parameter cannot be null for starting leader-initiated recovery for replica: " + replicaUrl);
        }
        if (shardId == null) {
            throw new IllegalArgumentException("shard parameter cannot be null for starting leader-initiated recovery for replica: " + replicaUrl);
        }
        if (replicaUrl == null) {
            throw new IllegalArgumentException("replicaUrl parameter cannot be null for starting leader-initiated recovery");
        }
        boolean nodeIsLive = true;
        boolean publishDownState = false;
        String replicaNodeName = replicaCoreProps.getNodeName();
        String replicaCoreNodeName = ((Replica)replicaCoreProps.getNodeProps()).getName();
        assert (replicaCoreNodeName != null) : "No core name for replica " + replicaNodeName;
        Map<String, String> map = this.replicasInLeaderInitiatedRecovery;
        synchronized (map) {
            if (this.replicasInLeaderInitiatedRecovery.containsKey(replicaUrl) && !forcePublishState) {
                log.debug("Replica {} already in leader-initiated recovery handling.", (Object)replicaUrl);
                return false;
            }
            if (this.getZkStateReader().getClusterState().liveNodesContain(replicaNodeName)) {
                this.replicasInLeaderInitiatedRecovery.put(replicaUrl, this.getLeaderInitiatedRecoveryZnodePath(collection, shardId, replicaCoreNodeName));
                this.updateLeaderInitiatedRecoveryState(collection, shardId, replicaCoreNodeName, "down");
                log.info("Put replica core={} coreNodeName={} on " + replicaNodeName + " into leader-initiated recovery.", (Object)replicaCoreProps.getCoreName(), (Object)replicaCoreNodeName);
                publishDownState = true;
            } else {
                nodeIsLive = false;
                log.info("Node " + replicaNodeName + " is not live, so skipping leader-initiated recovery for replica: core={} coreNodeName={}", (Object)replicaCoreProps.getCoreName(), (Object)replicaCoreNodeName);
            }
        }
        if (publishDownState || forcePublishState) {
            String replicaCoreName = replicaCoreProps.getCoreName();
            ZkNodeProps m = new ZkNodeProps("operation", "state", "state", "down", "base_url", replicaCoreProps.getBaseUrl(), "core", replicaCoreProps.getCoreName(), "node_name", replicaCoreProps.getNodeName(), "shard", shardId, "collection", collection);
            log.warn("Leader is publishing core={} coreNodeName ={} state={} on behalf of un-reachable replica {}; forcePublishState? " + forcePublishState, replicaCoreName, replicaCoreNodeName, "down", replicaUrl);
            this.overseerJobQueue.offer(ZkStateReader.toJSON(m));
        }
        return nodeIsLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplicaInRecoveryHandling(String replicaUrl) {
        boolean exists = false;
        Map<String, String> map = this.replicasInLeaderInitiatedRecovery;
        synchronized (map) {
            exists = this.replicasInLeaderInitiatedRecovery.containsKey(replicaUrl);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReplicaFromLeaderInitiatedRecoveryHandling(String replicaUrl) {
        Map<String, String> map = this.replicasInLeaderInitiatedRecovery;
        synchronized (map) {
            this.replicasInLeaderInitiatedRecovery.remove(replicaUrl);
        }
    }

    public String getLeaderInitiatedRecoveryState(String collection, String shardId, String coreNodeName) {
        Map<String, Object> stateObj = this.getLeaderInitiatedRecoveryStateObject(collection, shardId, coreNodeName);
        return stateObj != null ? (String)stateObj.get("state") : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Object> getLeaderInitiatedRecoveryStateObject(String collection, String shardId, String coreNodeName) {
        if (collection == null) return null;
        if (shardId == null) return null;
        if (coreNodeName == null) {
            return null;
        }
        String znodePath = this.getLeaderInitiatedRecoveryZnodePath(collection, shardId, coreNodeName);
        byte[] stateData = null;
        try {
            stateData = this.zkClient.getData(znodePath, null, new Stat(), false);
        }
        catch (KeeperException.NoNodeException ignoreMe) {
        }
        catch (KeeperException.ConnectionLossException cle) {
            log.warn("Unable to read " + znodePath + " due to: " + cle);
        }
        catch (KeeperException.SessionExpiredException see) {
            log.warn("Unable to read " + znodePath + " due to: " + see);
        }
        catch (Exception exc) {
            log.error("Failed to read data from znode " + znodePath + " due to: " + exc);
            if (!(exc instanceof SolrException)) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to read data from znodePath: " + znodePath, (Throwable)exc);
            throw (SolrException)exc;
        }
        Map<String, Object> stateObj = null;
        if (stateData == null) return stateObj;
        if (stateData.length <= 0) return stateObj;
        if (stateData[0] != 123) return ZkNodeProps.makeMap("state", new String(stateData, StandardCharsets.UTF_8));
        Object parsedJson = ZkStateReader.fromJSON(stateData);
        if (!(parsedJson instanceof Map)) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Leader-initiated recovery state data is invalid! " + parsedJson);
        return (Map<String, Object>)parsedJson;
    }

    private void updateLeaderInitiatedRecoveryState(String collection, String shardId, String coreNodeName, String state) {
        if (collection == null || shardId == null || coreNodeName == null) {
            log.warn("Cannot set leader-initiated recovery state znode to " + state + " using: collection=" + collection + "; shardId=" + shardId + "; coreNodeName=" + coreNodeName);
            return;
        }
        String znodePath = this.getLeaderInitiatedRecoveryZnodePath(collection, shardId, coreNodeName);
        if ("active".equals(state)) {
            try {
                this.zkClient.delete(znodePath, -1, false);
            }
            catch (Exception justLogIt) {
                log.warn("Failed to delete znode " + znodePath + " due to: " + justLogIt);
            }
            return;
        }
        Map<String, Object> stateObj = null;
        try {
            stateObj = this.getLeaderInitiatedRecoveryStateObject(collection, shardId, coreNodeName);
        }
        catch (Exception exc) {
            log.warn(exc.getMessage(), exc);
        }
        if (stateObj == null) {
            stateObj = ZkNodeProps.makeMap(new Object[0]);
        }
        stateObj.put("state", state);
        if (stateObj.get("createdByNodeName") == null) {
            stateObj.put("createdByNodeName", String.valueOf(this.nodeName));
        }
        byte[] znodeData = ZkStateReader.toJSON(stateObj);
        boolean retryOnConnLoss = true;
        try {
            if (this.zkClient.exists(znodePath, retryOnConnLoss).booleanValue()) {
                this.zkClient.setData(znodePath, znodeData, retryOnConnLoss);
            } else {
                this.zkClient.makePath(znodePath, znodeData, retryOnConnLoss);
            }
            log.info("Wrote " + state + " to " + znodePath);
        }
        catch (Exception exc) {
            if (exc instanceof SolrException) {
                throw (SolrException)exc;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to update data to " + state + " for znode: " + znodePath, (Throwable)exc);
        }
    }

    public String getLeaderInitiatedRecoveryZnodePath(String collection, String shardId) {
        return "/collections/" + collection + "/leader_initiated_recovery/" + shardId;
    }

    public String getLeaderInitiatedRecoveryZnodePath(String collection, String shardId, String coreNodeName) {
        return this.getLeaderInitiatedRecoveryZnodePath(collection, shardId) + "/" + coreNodeName;
    }

    public void throwErrorIfReplicaReplaced(CoreDescriptor desc) {
        boolean autoAddReplicas;
        DocCollection collection;
        ClusterState clusterState = this.getZkStateReader().getClusterState();
        if (clusterState != null && (collection = clusterState.getCollectionOrNull(desc.getCloudDescriptor().getCollectionName())) != null && (autoAddReplicas = ClusterStateUtil.isAutoAddReplicas(this.getZkStateReader(), collection.getName()))) {
            CloudUtil.checkSharedFSFailoverReplaced(this.cc, desc);
        }
    }

    static class ContextKey {
        private String collection;
        private String coreNodeName;

        public ContextKey(String collection, String coreNodeName) {
            this.collection = collection;
            this.coreNodeName = coreNodeName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
            result = 31 * result + (this.coreNodeName == null ? 0 : this.coreNodeName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContextKey other = (ContextKey)obj;
            if (this.collection == null ? other.collection != null : !this.collection.equals(other.collection)) {
                return false;
            }
            return !(this.coreNodeName == null ? other.coreNodeName != null : !this.coreNodeName.equals(other.coreNodeName));
        }
    }
}

