/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.cloud.LeaderInitiatedRecoveryThread;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.ShardLeaderElectionContextBase;
import org.apache.solr.cloud.SyncStrategy;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RefCounted;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ShardLeaderElectionContext
extends ShardLeaderElectionContextBase {
    private static Logger log = LoggerFactory.getLogger(ShardLeaderElectionContext.class);
    private final ZkController zkController;
    private final CoreContainer cc;
    private final SyncStrategy syncStrategy;
    private volatile boolean isClosed = false;

    public ShardLeaderElectionContext(LeaderElector leaderElector, String shardId, String collection, String coreNodeName, ZkNodeProps props, ZkController zkController, CoreContainer cc) {
        super(leaderElector, shardId, collection, coreNodeName, props, zkController.getZkStateReader());
        this.zkController = zkController;
        this.cc = cc;
        this.syncStrategy = new SyncStrategy(cc);
    }

    @Override
    public void close() {
        super.close();
        this.isClosed = true;
        this.syncStrategy.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void runLeaderProcess(boolean weAreReplacement, int pauseBeforeStart) throws KeeperException, InterruptedException, IOException {
        log.info("Running the leader process for shard " + this.shardId);
        String coreName = this.leaderProps.getStr("core");
        ZkNodeProps m = new ZkNodeProps("operation", "leader", "shard", this.shardId, "collection", this.collection);
        Overseer.getInQueue(this.zkClient).offer(ZkStateReader.toJSON(m));
        int leaderVoteWait = this.cc.getZkController().getLeaderVoteWait();
        if (!weAreReplacement) {
            this.waitForReplicasToComeUp(weAreReplacement, leaderVoteWait);
        }
        try (SolrCore core = this.cc.getCore(coreName);){
            if (core == null) {
                this.cancelElection();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Fatal Error, SolrCore not found:" + coreName + " in " + this.cc.getCoreNames());
            }
            if (weAreReplacement && !this.shouldIBeLeader(this.leaderProps, core, weAreReplacement)) {
                this.rejoinLeaderElection(this.leaderSeqPath, core);
                return;
            }
            log.info("I may be the new leader - try and sync");
            core.getUpdateHandler().getSolrCoreState().cancelRecovery();
            if (weAreReplacement) {
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, (Throwable)e);
                }
            }
            boolean success = false;
            try {
                success = this.syncStrategy.sync(this.zkController, core, this.leaderProps, weAreReplacement);
            }
            catch (Exception e) {
                SolrException.log(log, "Exception while trying to sync", e);
                success = false;
            }
            UpdateLog ulog = core.getUpdateHandler().getUpdateLog();
            if (!success) {
                boolean hasRecentUpdates = false;
                if (ulog != null) {
                    try (UpdateLog.RecentUpdates recentUpdates = ulog.getRecentUpdates();){
                        hasRecentUpdates = !recentUpdates.getVersions(1).isEmpty();
                    }
                }
                if (!hasRecentUpdates) {
                    log.info("We failed sync, but we have no versions - we can't sync in that case - we were active before, so become leader anyway");
                    success = true;
                }
            }
            if (log.isDebugEnabled()) {
                try {
                    RefCounted<SolrIndexSearcher> searchHolder = core.getNewestSearcher(false);
                    SolrIndexSearcher searcher = searchHolder.get();
                    try {
                        log.debug(core.getCoreDescriptor().getCoreContainer().getZkController().getNodeName() + " synched " + searcher.search((Query)new MatchAllDocsQuery(), (int)1).totalHits);
                    }
                    finally {
                        searchHolder.decref();
                    }
                }
                catch (Exception e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
                }
            }
            if (!success) {
                this.rejoinLeaderElection(this.leaderSeqPath, core);
                return;
            }
            log.info("I am the new leader: " + ZkCoreNodeProps.getCoreUrl(this.leaderProps) + " " + this.shardId);
            core.getCoreDescriptor().getCloudDescriptor().setLeader(true);
        }
        boolean isLeader = true;
        try {
            super.runLeaderProcess(weAreReplacement, 0);
        }
        catch (Exception e) {
            isLeader = false;
            SolrException.log(log, "There was a problem trying to register as the leader", e);
            try (SolrCore core = this.cc.getCore(coreName);){
                if (core == null) {
                    log.debug("SolrCore not found:" + coreName + " in " + this.cc.getCoreNames());
                    return;
                }
                core.getCoreDescriptor().getCloudDescriptor().setLeader(false);
                this.rejoinLeaderElection(this.leaderSeqPath, core);
            }
        }
        if (isLeader) {
            try {
                this.startLeaderInitiatedRecoveryOnReplicas(coreName);
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
    }

    private void startLeaderInitiatedRecoveryOnReplicas(String coreName) throws Exception {
        try (SolrCore core = this.cc.getCore(coreName);){
            CloudDescriptor cloudDesc = core.getCoreDescriptor().getCloudDescriptor();
            String coll = cloudDesc.getCollectionName();
            String shardId = cloudDesc.getShardId();
            String coreNodeName = cloudDesc.getCoreNodeName();
            if (coll == null || shardId == null) {
                log.error("Cannot start leader-initiated recovery on new leader (core=" + coreName + ",coreNodeName=" + coreNodeName + ") because collection and/or shard is null!");
                return;
            }
            String znodePath = this.zkController.getLeaderInitiatedRecoveryZnodePath(coll, shardId);
            List<String> replicas = null;
            try {
                replicas = this.zkClient.getChildren(znodePath, null, false);
            }
            catch (KeeperException.NoNodeException nne) {
                // empty catch block
            }
            if (replicas != null && replicas.size() > 0) {
                for (String replicaCoreNodeName : replicas) {
                    String lirState;
                    if (coreNodeName.equals(replicaCoreNodeName) || !"down".equals(lirState = this.zkController.getLeaderInitiatedRecoveryState(coll, shardId, replicaCoreNodeName)) && !"recovery_failed".equals(lirState)) continue;
                    log.info("After core={} coreNodeName={} was elected leader, a replica coreNodeName={} was found in state: " + lirState + " and needing recovery.", coreName, coreNodeName, replicaCoreNodeName);
                    List<ZkCoreNodeProps> replicaProps = this.zkController.getZkStateReader().getReplicaProps(this.collection, shardId, coreNodeName);
                    if (replicaProps == null || replicaProps.size() <= 0) continue;
                    ZkCoreNodeProps coreNodeProps = null;
                    for (ZkCoreNodeProps p : replicaProps) {
                        if (!((Replica)p.getNodeProps()).getName().equals(replicaCoreNodeName)) continue;
                        coreNodeProps = p;
                        break;
                    }
                    LeaderInitiatedRecoveryThread lirThread = new LeaderInitiatedRecoveryThread(this.zkController, this.cc, this.collection, shardId, coreNodeProps, 120, coreNodeName);
                    this.zkController.ensureReplicaInLeaderInitiatedRecovery(this.collection, shardId, coreNodeProps.getCoreUrl(), coreNodeProps, false);
                    ExecutorService executor = this.cc.getUpdateShardHandler().getUpdateExecutor();
                    executor.execute(lirThread);
                }
            }
        }
    }

    private void waitForReplicasToComeUp(boolean weAreReplacement, int timeoutms) throws InterruptedException {
        long timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutms, TimeUnit.MILLISECONDS);
        String shardsElectZkPath = this.electionPath + "/election";
        Slice slices = this.zkController.getClusterState().getSlice(this.collection, this.shardId);
        int cnt = 0;
        while (!this.isClosed && !this.cc.isShutDown()) {
            if (slices != null) {
                int found = 0;
                try {
                    found = this.zkClient.getChildren(shardsElectZkPath, null, true).size();
                }
                catch (KeeperException e) {
                    SolrException.log(log, "Error checking for the number of election participants", e);
                }
                if (found >= slices.getReplicasMap().size()) {
                    log.info("Enough replicas found to continue.");
                    return;
                }
                if (cnt % 40 == 0) {
                    log.info("Waiting until we see more replicas up for shard " + this.shardId + ": total=" + slices.getReplicasMap().size() + " found=" + found + " timeoutin=" + ((float)timeoutAt - (float)System.nanoTime() / 3.0f) + "ms");
                }
                if (System.nanoTime() > timeoutAt) {
                    log.info("Was waiting for replicas to come up, but they are taking too long - assuming they won't come back till later");
                    return;
                }
            } else {
                log.warn("Shard not found: " + this.shardId + " for collection " + this.collection);
                return;
            }
            Thread.sleep(500L);
            slices = this.zkController.getClusterState().getSlice(this.collection, this.shardId);
            ++cnt;
        }
    }

    private void rejoinLeaderElection(String leaderSeqPath, SolrCore core) throws InterruptedException, KeeperException, IOException {
        if (this.cc.isShutDown()) {
            log.info("Not rejoining election because CoreContainer is shutdown");
            return;
        }
        log.info("There may be a better leader candidate than us - going back into recovery");
        this.cancelElection();
        core.getUpdateHandler().getSolrCoreState().doRecovery(this.cc, core.getCoreDescriptor());
        this.leaderElector.joinElection(this, true);
    }

    private boolean shouldIBeLeader(ZkNodeProps leaderProps, SolrCore core, boolean weAreReplacement) {
        log.info("Checking if I (core={},coreNodeName={}) should try and be the leader.", (Object)core.getName(), (Object)core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
        if (this.isClosed) {
            log.info("Bailing on leader process because we have been closed");
            return false;
        }
        if (!weAreReplacement) {
            return true;
        }
        if (core.getCoreDescriptor().getCloudDescriptor().getLastPublished().equals("active")) {
            String lirState = this.zkController.getLeaderInitiatedRecoveryState(this.collection, this.shardId, core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
            if ("down".equals(lirState) || "recovering".equals(lirState)) {
                log.warn("Although my last published state is Active, the previous leader marked me " + core.getName() + " as " + lirState + " and I haven't recovered yet, so I shouldn't be the leader.");
                return false;
            }
            log.info("My last published State was Active, it's okay to be the leader.");
            return true;
        }
        log.info("My last published State was " + core.getCoreDescriptor().getCloudDescriptor().getLastPublished() + ", I won't be the leader.");
        return false;
    }
}

