/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

final class OverseerElectionContext
extends ElectionContext {
    private final SolrZkClient zkClient;
    private Overseer overseer;
    public static final String PATH = "/overseer_elect";

    public OverseerElectionContext(SolrZkClient zkClient, Overseer overseer, String zkNodeName) {
        super(zkNodeName, PATH, "/overseer_elect/leader", null, zkClient);
        this.overseer = overseer;
        this.zkClient = zkClient;
        try {
            new ZkCmdExecutor(zkClient.getZkClientTimeout()).ensureExists(PATH, zkClient);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    @Override
    void runLeaderProcess(boolean weAreReplacement, int pauseBeforeStartMs) throws KeeperException, InterruptedException {
        log.info("I am going to be the leader {}", (Object)this.id);
        String id = this.leaderSeqPath.substring(this.leaderSeqPath.lastIndexOf("/") + 1);
        ZkNodeProps myProps = new ZkNodeProps("id", id);
        this.zkClient.makePath(this.leaderPath, ZkStateReader.toJSON(myProps), CreateMode.EPHEMERAL, true);
        if (pauseBeforeStartMs > 0) {
            try {
                Thread.sleep(pauseBeforeStartMs);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                log.warn("Wait interrupted ", e);
            }
        }
        this.overseer.start(id);
    }

    @Override
    public void cancelElection() throws InterruptedException, KeeperException {
        super.cancelElection();
        this.overseer.close();
    }

    @Override
    public ElectionContext copy() {
        return new OverseerElectionContext(this.zkClient, this.overseer, this.id);
    }

    @Override
    public void joinedElectionFired() {
        this.overseer.close();
    }

    @Override
    public void checkIfIamLeaderFired() {
        this.overseer.close();
    }
}

