/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.cloud.ElectionContext;
import org.apache.solr.cloud.OverseerCollectionProcessor;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElector {
    private static Logger log = LoggerFactory.getLogger(LeaderElector.class);
    static final String ELECTION_NODE = "/election";
    public static final Pattern LEADER_SEQ = Pattern.compile(".*?/?.*?-n_(\\d+)");
    private static final Pattern SESSION_ID = Pattern.compile(".*?/?(.*?-.*?)-n_\\d+");
    private static final Pattern NODE_NAME = Pattern.compile(".*?/?(.*?-)(.*?)-n_\\d+");
    protected SolrZkClient zkClient;
    private ZkCmdExecutor zkCmdExecutor;
    private volatile ElectionContext context;
    private ElectionWatcher watcher;

    public LeaderElector(SolrZkClient zkClient) {
        this.zkClient = zkClient;
        this.zkCmdExecutor = new ZkCmdExecutor(zkClient.getZkClientTimeout());
    }

    public ElectionContext getContext() {
        return this.context;
    }

    private void checkIfIamLeader(int seq, ElectionContext context, boolean replacement) throws KeeperException, InterruptedException, IOException {
        int s;
        int i;
        context.checkIfIamLeaderFired();
        String holdElectionPath = context.electionPath + ELECTION_NODE;
        List<String> seqs = this.zkClient.getChildren(holdElectionPath, null, true);
        LeaderElector.sortSeqs(seqs);
        List<Integer> intSeqs = this.getSeqs(seqs);
        if (intSeqs.size() == 0) {
            log.warn("Our node is no longer in line to be leader");
            return;
        }
        if (seq <= intSeqs.get(0)) {
            if (seq == intSeqs.get(0) && !context.leaderSeqPath.equals(holdElectionPath + "/" + seqs.get(0))) {
                log.info("was going be leader {} , seq(0) {}", (Object)context.leaderSeqPath, (Object)(holdElectionPath + "/" + seqs.get(0)));
                this.retryElection(context, false);
                return;
            }
            try {
                this.zkClient.delete(context.leaderPath, -1, true);
            }
            catch (KeeperException.NoNodeException nne) {
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("leader elect delete error", e);
                this.retryElection(context, false);
                return;
            }
            try {
                this.runIamLeaderProcess(context, replacement);
            }
            catch (KeeperException.NodeExistsException e) {
                log.error("node exists", e);
                this.retryElection(context, false);
                return;
            }
        }
        for (i = 1; i < intSeqs.size() && seq >= (s = intSeqs.get(i).intValue()); ++i) {
        }
        int index = i - 2;
        if (index < 0) {
            log.warn("Our node is no longer in line to be leader");
            return;
        }
        try {
            String watchedNode = holdElectionPath + "/" + seqs.get(index);
            this.watcher = new ElectionWatcher(context.leaderSeqPath, watchedNode, seq, context);
            this.zkClient.getData(watchedNode, this.watcher, null, true);
        }
        catch (KeeperException.SessionExpiredException e) {
            throw e;
        }
        catch (KeeperException e) {
            log.warn("Failed setting watch", e);
            this.checkIfIamLeader(seq, context, true);
        }
    }

    protected void runIamLeaderProcess(ElectionContext context, boolean weAreReplacement) throws KeeperException, InterruptedException, IOException {
        context.runLeaderProcess(weAreReplacement, 0);
    }

    public static int getSeq(String nStringSequence) {
        int seq = 0;
        Matcher m = LEADER_SEQ.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        seq = Integer.parseInt(m.group(1));
        return seq;
    }

    private String getNodeId(String nStringSequence) {
        Matcher m = SESSION_ID.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        String id = m.group(1);
        return id;
    }

    public static String getNodeName(String nStringSequence) {
        Matcher m = NODE_NAME.matcher(nStringSequence);
        if (!m.matches()) {
            throw new IllegalStateException("Could not find regex match in:" + nStringSequence);
        }
        String result = m.group(2);
        return result;
    }

    private List<Integer> getSeqs(List<String> seqs) {
        ArrayList<Integer> intSeqs = new ArrayList<Integer>(seqs.size());
        for (String seq : seqs) {
            intSeqs.add(LeaderElector.getSeq(seq));
        }
        return intSeqs;
    }

    public int joinElection(ElectionContext context, boolean replacement) throws KeeperException, InterruptedException, IOException {
        return this.joinElection(context, replacement, false);
    }

    public int joinElection(ElectionContext context, boolean replacement, boolean joinAtHead) throws KeeperException, InterruptedException, IOException {
        context.joinedElectionFired();
        String shardsElectZkPath = context.electionPath + ELECTION_NODE;
        long sessionId = this.zkClient.getSolrZooKeeper().getSessionId();
        String id = sessionId + "-" + context.id;
        String leaderSeqPath = null;
        boolean cont = true;
        int tries = 0;
        while (cont) {
            try {
                if (joinAtHead) {
                    log.info("node {} Trying to join election at the head ", (Object)id);
                    List<String> nodes = OverseerCollectionProcessor.getSortedElectionNodes(this.zkClient);
                    if (nodes.size() < 2) {
                        leaderSeqPath = this.zkClient.create(shardsElectZkPath + "/" + id + "-n_", null, CreateMode.EPHEMERAL_SEQUENTIAL, false);
                    } else {
                        String firstInLine = nodes.get(1);
                        log.info("The current head: {}", (Object)firstInLine);
                        Matcher m = LEADER_SEQ.matcher(firstInLine);
                        if (!m.matches()) {
                            throw new IllegalStateException("Could not find regex match in:" + firstInLine);
                        }
                        leaderSeqPath = shardsElectZkPath + "/" + id + "-n_" + m.group(1);
                        this.zkClient.create(leaderSeqPath, null, CreateMode.EPHEMERAL, false);
                        log.info("Joined at the head  {}", (Object)leaderSeqPath);
                    }
                } else {
                    leaderSeqPath = this.zkClient.create(shardsElectZkPath + "/" + id + "-n_", null, CreateMode.EPHEMERAL_SEQUENTIAL, false);
                }
                context.leaderSeqPath = leaderSeqPath;
                cont = false;
            }
            catch (KeeperException.ConnectionLossException e) {
                List<String> entries = this.zkClient.getChildren(shardsElectZkPath, null, true);
                boolean foundId = false;
                for (String entry : entries) {
                    String nodeId = this.getNodeId(entry);
                    if (!id.equals(nodeId)) continue;
                    foundId = true;
                    break;
                }
                if (foundId) continue;
                cont = true;
                if (tries++ > 20) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (KeeperException.NoNodeException e) {
                if (tries++ > 20) {
                    context = null;
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                cont = true;
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        int seq = LeaderElector.getSeq(leaderSeqPath);
        this.checkIfIamLeader(seq, context, replacement);
        return seq;
    }

    public void setup(ElectionContext context) throws InterruptedException, KeeperException {
        String electZKPath = context.electionPath + ELECTION_NODE;
        this.zkCmdExecutor.ensureExists(electZKPath, this.zkClient);
        this.context = context;
    }

    public static void sortSeqs(List<String> seqs) {
        Collections.sort(seqs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i = Integer.valueOf(LeaderElector.getSeq(o1)).compareTo(LeaderElector.getSeq(o2));
                return i == 0 ? o1.compareTo(o2) : i;
            }
        });
    }

    void retryElection(ElectionContext context, boolean joinAtHead) throws KeeperException, InterruptedException, IOException {
        ElectionWatcher watcher = this.watcher;
        ElectionContext ctx = context.copy();
        if (watcher != null) {
            watcher.cancel(this.context.leaderSeqPath);
        }
        this.context.cancelElection();
        this.context = ctx;
        this.joinElection(ctx, true, joinAtHead);
    }

    private class ElectionWatcher
    implements Watcher {
        final String myNode;
        final String watchedNode;
        final int seq;
        final ElectionContext context;
        private boolean canceled = false;

        private ElectionWatcher(String myNode, String watchedNode, int seq, ElectionContext context) {
            this.myNode = myNode;
            this.watchedNode = watchedNode;
            this.seq = seq;
            this.context = context;
        }

        void cancel(String leaderSeqPath) {
            this.canceled = true;
        }

        @Override
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            if (this.canceled) {
                log.info("This watcher is not active anymore {}", (Object)this.myNode);
                try {
                    LeaderElector.this.zkClient.delete(this.myNode, -1, true);
                }
                catch (KeeperException.NoNodeException nne) {
                }
                catch (Exception e) {
                    log.warn("My watched node still exists and can't remove " + this.myNode, e);
                }
                return;
            }
            try {
                LeaderElector.this.checkIfIamLeader(this.seq, this.context, true);
            }
            catch (Exception e) {
                log.warn("", e);
            }
        }
    }
}

