/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrLogFormatter
extends Formatter {
    long startTime;
    long lastTime;
    Map<Method, String> methodAlias;
    public boolean shorterFormat;
    Map<SolrCore, CoreInfo> coreInfoMap;
    public Map<String, String> classAliases;
    private Method classAndMethod;
    static ThreadLocal<String> threadLocal = new ThreadLocal();

    public SolrLogFormatter() {
        this.lastTime = this.startTime = System.currentTimeMillis();
        this.methodAlias = new HashMap<Method, String>();
        this.shorterFormat = false;
        this.coreInfoMap = new WeakHashMap<SolrCore, CoreInfo>();
        this.classAliases = new HashMap<String, String>();
        this.classAndMethod = new Method(null, null);
        this.methodAlias.put(new Method("org.apache.solr.update.processor.LogUpdateProcessor", "finish"), "UPDATE");
        this.methodAlias.put(new Method("org.apache.solr.core.SolrCore", "execute"), "REQ");
    }

    public void setShorterFormat() {
        this.shorterFormat = true;
        this.methodAlias.put(new Method("org.apache.solr.update.processor.LogUpdateProcessor", "finish"), "");
    }

    @Override
    public String format(LogRecord record) {
        try {
            return this._format(record);
        }
        catch (Exception e) {
            return "ERROR IN SolrLogFormatter! original message:" + record.getMessage() + "\n\tException: " + SolrException.toStr(e);
        }
    }

    public void appendThread(StringBuilder sb, LogRecord record) {
        Thread th = Thread.currentThread();
        sb.append(" T");
        sb.append(th.getId());
    }

    public String _format(LogRecord record) {
        String message = record.getMessage();
        StringBuilder sb = new StringBuilder(message.length() + 80);
        long now = record.getMillis();
        long timeFromStart = now - this.startTime;
        long timeSinceLast = now - this.lastTime;
        this.lastTime = now;
        String shortClassName = this.getShortClassName(record.getSourceClassName(), record.getSourceMethodName());
        SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
        SolrQueryRequest req = requestInfo == null ? null : requestInfo.getReq();
        SolrCore core = req == null ? null : req.getCore();
        ZkController zkController = null;
        CoreInfo info = null;
        if (core != null) {
            info = this.coreInfoMap.get(core);
            if (info == null) {
                info = new CoreInfo();
                info.shortId = "C" + Integer.toString(CoreInfo.maxCoreNum++);
                this.coreInfoMap.put(core, info);
                if (sb.length() == 0) {
                    sb.append("ASYNC ");
                }
                sb.append(" NEW_CORE " + info.shortId);
                sb.append(" name=" + core.getName());
                sb.append(" " + core);
            }
            if (zkController == null) {
                zkController = core.getCoreDescriptor().getCoreContainer().getZkController();
            }
            if (zkController != null) {
                if (info.url == null) {
                    info.url = zkController.getBaseUrl() + "/" + core.getName();
                    sb.append(" url=" + info.url + " node=" + zkController.getNodeName());
                }
                Map<String, Object> coreProps = this.getReplicaProps(zkController, core);
                if (info.coreProps == null || !coreProps.equals(info.coreProps)) {
                    info.coreProps = coreProps;
                    String corePropsString = "coll:" + core.getCoreDescriptor().getCloudDescriptor().getCollectionName() + " core:" + core.getName() + " props:" + coreProps;
                    sb.append(" " + info.shortId + "_STATE=" + corePropsString);
                }
            }
        }
        if (sb.length() > 0) {
            sb.append('\n');
        }
        sb.append(timeFromStart);
        this.appendThread(sb, record);
        if (info != null) {
            sb.append(' ').append(info.shortId);
        }
        if (zkController != null) {
            sb.append(" P").append(zkController.getHostPort());
        }
        if (shortClassName.length() > 0) {
            sb.append(' ').append(shortClassName);
        }
        if (record.getLevel() != Level.INFO) {
            sb.append(' ').append(record.getLevel());
        }
        sb.append(' ');
        this.appendMultiLineString(sb, message);
        Throwable th = record.getThrown();
        if (th != null) {
            sb.append(' ');
            String err = SolrException.toStr(th);
            String ignoredMsg = SolrException.doIgnore(th, err);
            if (ignoredMsg != null) {
                sb.append(ignoredMsg);
            } else {
                sb.append(err);
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    private Map<String, Object> getReplicaProps(ZkController zkController, SolrCore core) {
        String collection = core.getCoreDescriptor().getCloudDescriptor().getCollectionName();
        Replica replica = zkController.getClusterState().getReplica(collection, core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
        if (replica != null) {
            return replica.getProperties();
        }
        return Collections.EMPTY_MAP;
    }

    private String getShortClassName(String name, String method) {
        int idx;
        this.classAndMethod.className = name;
        this.classAndMethod.methodName = method;
        String out = this.methodAlias.get(this.classAndMethod);
        if (out != null) {
            return out;
        }
        StringBuilder sb = new StringBuilder();
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return name + '.' + method;
        }
        int prevIndex = -1;
        while (true) {
            char ch = name.charAt(prevIndex + 1);
            sb.append(ch);
            idx = name.indexOf(46, prevIndex + 1);
            ch = name.charAt(idx + 1);
            if (idx >= lastDot || Character.isUpperCase(ch)) break;
            prevIndex = idx;
        }
        sb.append(name.substring(idx));
        return sb.toString() + '.' + method;
    }

    private void addFirstLine(StringBuilder sb, String msg) {
        if (!this.shorterFormat || !msg.startsWith("[")) {
            sb.append(msg);
            return;
        }
        int idx = msg.indexOf(93);
        if (idx < 0 || !msg.startsWith(" webapp=", idx + 1)) {
            sb.append(msg);
            return;
        }
        if ((idx = msg.indexOf(32, idx + 8)) < 0) {
            sb.append(msg);
            return;
        }
        if ((idx = msg.indexOf(61, idx + 1)) < 0) {
            sb.append(msg);
            return;
        }
        int idx2 = msg.indexOf(32, idx + 1);
        if (idx2 < 0) {
            sb.append(msg);
            return;
        }
        sb.append(msg.substring(idx + 1, idx2 + 1));
        idx = msg.indexOf("params=", idx2);
        if (idx < 0) {
            sb.append(msg.substring(idx2));
        } else {
            sb.append(msg.substring(idx + 7));
        }
    }

    private void appendMultiLineString(StringBuilder sb, String msg) {
        int idx = msg.indexOf(10);
        if (idx < 0) {
            this.addFirstLine(sb, msg);
            return;
        }
        int lastIdx = -1;
        while (true) {
            if (idx < 0) {
                if (lastIdx == -1) {
                    this.addFirstLine(sb, msg.substring(lastIdx + 1));
                    break;
                }
                sb.append(msg.substring(lastIdx + 1));
                break;
            }
            if (lastIdx == -1) {
                this.addFirstLine(sb, msg.substring(lastIdx + 1, idx));
            } else {
                sb.append(msg.substring(lastIdx + 1, idx));
            }
            sb.append("\n\t");
            lastIdx = idx;
            idx = msg.indexOf(10, lastIdx + 1);
        }
    }

    @Override
    public String getHead(Handler h) {
        return super.getHead(h);
    }

    @Override
    public String getTail(Handler h) {
        return super.getTail(h);
    }

    @Override
    public String formatMessage(LogRecord record) {
        return this.format(record);
    }

    public static void main(String[] args) throws Exception {
        Handler[] handlers = java.util.logging.Logger.getLogger("").getHandlers();
        boolean foundConsoleHandler = false;
        for (int index = 0; index < handlers.length; ++index) {
            if (!(handlers[index] instanceof ConsoleHandler)) continue;
            handlers[index].setLevel(Level.ALL);
            handlers[index].setFormatter(new SolrLogFormatter());
            foundConsoleHandler = true;
        }
        if (!foundConsoleHandler) {
            System.err.println("No consoleHandler found, adding one.");
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            consoleHandler.setFormatter(new SolrLogFormatter());
            java.util.logging.Logger.getLogger("").addHandler(consoleHandler);
        }
        Logger log = LoggerFactory.getLogger(SolrLogFormatter.class);
        log.error("HELLO");
        MyThreadGroup tg = new MyThreadGroup("YCS");
        Thread th = new Thread((ThreadGroup)tg, "NEW_THREAD"){

            @Override
            public void run() {
                try {
                    SolrLogFormatter.go();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        th.start();
        th.join();
    }

    public static void go() throws Exception {
        final Logger log = LoggerFactory.getLogger(SolrLogFormatter.class);
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                threadLocal.set("from thread1");
                log.error("[] webapp=/solr path=/select params={hello} wow");
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                threadLocal.set("from thread2");
                log.error("InThread2");
            }
        };
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
    }

    static class MyThreadGroup
    extends ThreadGroup
    implements TG {
        public MyThreadGroup(String name) {
            super(name);
        }

        @Override
        public String getTag() {
            return "HELLO";
        }
    }

    public static class CoreInfo {
        static int maxCoreNum;
        String shortId;
        String url;
        Map<String, Object> coreProps;
    }

    public static class Method {
        public String className;
        public String methodName;

        public Method(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        public int hashCode() {
            return this.className.hashCode() + this.methodName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Method)) {
                return false;
            }
            Method other = (Method)obj;
            return this.className.equals(other.className) && this.methodName.equals(other.methodName);
        }

        public String toString() {
            return this.className + '.' + this.methodName;
        }
    }

    public static interface TG {
        public String getTag();
    }
}

