/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.serialized;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.io.BinaryCodec;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Shape;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.util.DistanceToShapeValueSource;
import org.apache.lucene.spatial.util.ShapePredicateValueSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class SerializedDVStrategy
extends SpatialStrategy {
    private volatile int indexLastBufSize = 8192;

    public SerializedDVStrategy(SpatialContext ctx, String fieldName) {
        super(ctx, fieldName);
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        int bufSize = Math.max(128, (int)((double)this.indexLastBufSize * 1.5));
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(bufSize);
        final BytesRef bytesRef = new BytesRef();
        try {
            this.ctx.getBinaryCodec().writeShape(new DataOutputStream(byteStream), shape);
            byteStream.writeTo(new FilterOutputStream(null){

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    bytesRef.bytes = b;
                    bytesRef.offset = off;
                    bytesRef.length = len;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.indexLastBufSize = bytesRef.length;
        return new Field[]{new BinaryDocValuesField(this.getFieldName(), bytesRef)};
    }

    @Override
    public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        return new DistanceToShapeValueSource(this.makeShapeValueSource(), queryPoint, multiplier, this.ctx);
    }

    @Override
    public Query makeQuery(SpatialArgs args) {
        throw new UnsupportedOperationException("This strategy can't return a query that operates efficiently. Instead try a Filter or ValueSource.");
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        ValueSource shapeValueSource = this.makeShapeValueSource();
        ShapePredicateValueSource predicateValueSource = new ShapePredicateValueSource(shapeValueSource, args.getOperation(), args.getShape());
        return new PredicateValueSourceFilter(predicateValueSource);
    }

    public ValueSource makeShapeValueSource() {
        return new ShapeDocValueSource(this.getFieldName(), this.ctx.getBinaryCodec());
    }

    static class ShapeDocValueSource
    extends ValueSource {
        private final String fieldName;
        private final BinaryCodec binaryCodec;

        private ShapeDocValueSource(String fieldName, BinaryCodec binaryCodec) {
            this.fieldName = fieldName;
            this.binaryCodec = binaryCodec;
        }

        @Override
        public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
            final BinaryDocValues docValues = readerContext.reader().getBinaryDocValues(this.fieldName);
            return new FunctionValues(){
                int bytesRefDoc = -1;
                BytesRef bytesRef = new BytesRef();

                boolean fillBytes(int doc) {
                    if (this.bytesRefDoc != doc) {
                        this.bytesRef.copyBytes(docValues.get(doc));
                        this.bytesRefDoc = doc;
                    }
                    return this.bytesRef.length != 0;
                }

                @Override
                public boolean exists(int doc) {
                    return this.fillBytes(doc);
                }

                @Override
                public boolean bytesVal(int doc, BytesRef target) {
                    if (this.fillBytes(doc)) {
                        target.bytes = this.bytesRef.bytes;
                        target.offset = this.bytesRef.offset;
                        target.length = this.bytesRef.length;
                        return true;
                    }
                    target.length = 0;
                    return false;
                }

                @Override
                public Object objectVal(int docId) {
                    if (!this.fillBytes(docId)) {
                        return null;
                    }
                    DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(this.bytesRef.bytes, this.bytesRef.offset, this.bytesRef.length));
                    try {
                        return ShapeDocValueSource.this.binaryCodec.readShape(dataInput);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public Explanation explain(int doc) {
                    return new Explanation(Float.NaN, this.toString(doc));
                }

                @Override
                public String toString(int doc) {
                    return ShapeDocValueSource.this.description() + "=" + this.objectVal(doc);
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShapeDocValueSource that = (ShapeDocValueSource)o;
            return this.fieldName.equals(that.fieldName);
        }

        @Override
        public int hashCode() {
            int result = this.fieldName.hashCode();
            return result;
        }

        @Override
        public String description() {
            return "shapeDocVal(" + this.fieldName + ")";
        }
    }

    static class PredicateValueSourceFilter
    extends Filter {
        private final ValueSource predicateValueSource;

        public PredicateValueSourceFilter(ValueSource predicateValueSource) {
            this.predicateValueSource = predicateValueSource;
        }

        @Override
        public DocIdSet getDocIdSet(final AtomicReaderContext context, final Bits acceptDocs) throws IOException {
            return new DocIdSet(){

                @Override
                public DocIdSetIterator iterator() throws IOException {
                    throw new UnsupportedOperationException("Iteration is too slow; instead try FilteredQuery.QUERY_FIRST_FILTER_STRATEGY");
                }

                @Override
                public Bits bits() throws IOException {
                    final FunctionValues predFuncValues = PredicateValueSourceFilter.this.predicateValueSource.getValues(null, context);
                    return new Bits(){

                        @Override
                        public boolean get(int index) {
                            if (acceptDocs != null && !acceptDocs.get(index)) {
                                return false;
                            }
                            return predFuncValues.boolVal(index);
                        }

                        @Override
                        public int length() {
                            return context.reader().maxDoc();
                        }
                    };
                }
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateValueSourceFilter that = (PredicateValueSourceFilter)o;
            return this.predicateValueSource.equals(that.predicateValueSource);
        }

        public int hashCode() {
            return this.predicateValueSource.hashCode();
        }
    }
}

