/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.bbox;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.spatial.SpatialStrategy;
import org.apache.lucene.spatial.bbox.BBoxOverlapRatioValueSource;
import org.apache.lucene.spatial.bbox.BBoxValueSource;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.apache.lucene.spatial.util.DistanceToShapeValueSource;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;

public class BBoxStrategy
extends SpatialStrategy {
    public static final String SUFFIX_MINX = "__minX";
    public static final String SUFFIX_MAXX = "__maxX";
    public static final String SUFFIX_MINY = "__minY";
    public static final String SUFFIX_MAXY = "__maxY";
    public static final String SUFFIX_XDL = "__xdl";
    protected final String field_bbox;
    protected final String field_minX;
    protected final String field_minY;
    protected final String field_maxX;
    protected final String field_maxY;
    protected final String field_xdl;
    protected FieldType fieldType;
    protected FieldType xdlFieldType;

    public BBoxStrategy(SpatialContext ctx, String fieldNamePrefix) {
        super(ctx, fieldNamePrefix);
        this.field_bbox = fieldNamePrefix;
        this.field_minX = fieldNamePrefix + SUFFIX_MINX;
        this.field_maxX = fieldNamePrefix + SUFFIX_MAXX;
        this.field_minY = fieldNamePrefix + SUFFIX_MINY;
        this.field_maxY = fieldNamePrefix + SUFFIX_MAXY;
        this.field_xdl = fieldNamePrefix + SUFFIX_XDL;
        FieldType fieldType = new FieldType(DoubleField.TYPE_NOT_STORED);
        fieldType.setNumericPrecisionStep(8);
        fieldType.setDocValueType(FieldInfo.DocValuesType.NUMERIC);
        this.setFieldType(fieldType);
    }

    private int getPrecisionStep() {
        return this.fieldType.numericPrecisionStep();
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        fieldType.freeze();
        this.fieldType = fieldType;
        if (fieldType.numericType() != FieldType.NumericType.DOUBLE) {
            throw new IllegalArgumentException("BBoxStrategy only supports doubles at this time.");
        }
        this.xdlFieldType = new FieldType(StringField.TYPE_NOT_STORED);
        this.xdlFieldType.setStored(fieldType.stored());
        this.xdlFieldType.setIndexed(fieldType.indexed());
        this.xdlFieldType.freeze();
    }

    @Override
    public Field[] createIndexableFields(Shape shape) {
        return this.createIndexableFields(shape.getBoundingBox());
    }

    public Field[] createIndexableFields(Rectangle bbox) {
        Field[] fields = new Field[]{new ComboField(this.field_minX, bbox.getMinX(), this.fieldType), new ComboField(this.field_maxX, bbox.getMaxX(), this.fieldType), new ComboField(this.field_minY, bbox.getMinY(), this.fieldType), new ComboField(this.field_maxY, bbox.getMaxY(), this.fieldType), new ComboField(this.field_xdl, (Object)(bbox.getCrossesDateLine() ? "T" : "F"), this.xdlFieldType)};
        return fields;
    }

    public ValueSource makeShapeValueSource() {
        return new BBoxValueSource(this);
    }

    @Override
    public ValueSource makeDistanceValueSource(Point queryPoint, double multiplier) {
        return new DistanceToShapeValueSource(this.makeShapeValueSource(), queryPoint, multiplier, this.ctx);
    }

    public ValueSource makeOverlapRatioValueSource(Rectangle queryBox, double queryTargetProportion) {
        return new BBoxOverlapRatioValueSource(this.makeShapeValueSource(), this.ctx.isGeo(), queryBox, queryTargetProportion, 0.0);
    }

    @Override
    public Filter makeFilter(SpatialArgs args) {
        return new QueryWrapperFilter(this.makeSpatialQuery(args));
    }

    @Override
    public ConstantScoreQuery makeQuery(SpatialArgs args) {
        return new ConstantScoreQuery(this.makeSpatialQuery(args));
    }

    private Query makeSpatialQuery(SpatialArgs args) {
        Query spatial;
        Shape shape = args.getShape();
        if (!(shape instanceof Rectangle)) {
            throw new UnsupportedOperationException("Can only query by Rectangle, not " + shape);
        }
        Rectangle bbox = (Rectangle)shape;
        SpatialOperation op = args.getOperation();
        if (op == SpatialOperation.BBoxIntersects) {
            spatial = this.makeIntersects(bbox);
        } else if (op == SpatialOperation.BBoxWithin) {
            spatial = this.makeWithin(bbox);
        } else if (op == SpatialOperation.Contains) {
            spatial = this.makeContains(bbox);
        } else if (op == SpatialOperation.Intersects) {
            spatial = this.makeIntersects(bbox);
        } else if (op == SpatialOperation.IsEqualTo) {
            spatial = this.makeEquals(bbox);
        } else if (op == SpatialOperation.IsDisjointTo) {
            spatial = this.makeDisjoint(bbox);
        } else if (op == SpatialOperation.IsWithin) {
            spatial = this.makeWithin(bbox);
        } else {
            throw new UnsupportedSpatialOperation(op);
        }
        return spatial;
    }

    Query makeContains(Rectangle bbox) {
        Query xConditions;
        NumericRangeQuery<Double> qMinY = NumericRangeQuery.newDoubleRange(this.field_minY, this.getPrecisionStep(), null, bbox.getMinY(), false, true);
        NumericRangeQuery<Double> qMaxY = NumericRangeQuery.newDoubleRange(this.field_maxY, this.getPrecisionStep(), bbox.getMaxY(), null, true, false);
        BooleanQuery yConditions = this.makeQuery(BooleanClause.Occur.MUST, qMinY, qMaxY);
        if (!bbox.getCrossesDateLine()) {
            NumericRangeQuery<Double> qMinX = NumericRangeQuery.newDoubleRange(this.field_minX, this.getPrecisionStep(), null, bbox.getMinX(), false, true);
            NumericRangeQuery<Double> qMaxX = NumericRangeQuery.newDoubleRange(this.field_maxX, this.getPrecisionStep(), bbox.getMaxX(), null, true, false);
            BooleanQuery qMinMax = this.makeQuery(BooleanClause.Occur.MUST, qMinX, qMaxX);
            Query qNonXDL = this.makeXDL(false, qMinMax);
            if (!this.ctx.isGeo()) {
                xConditions = qNonXDL;
            } else {
                NumericRangeQuery<Double> qXDLLeft = NumericRangeQuery.newDoubleRange(this.field_minX, this.getPrecisionStep(), null, bbox.getMinX(), false, true);
                NumericRangeQuery<Double> qXDLRight = NumericRangeQuery.newDoubleRange(this.field_maxX, this.getPrecisionStep(), bbox.getMaxX(), null, true, false);
                BooleanQuery qXDLLeftRight = this.makeQuery(BooleanClause.Occur.SHOULD, qXDLLeft, qXDLRight);
                Query qXDL = this.makeXDL(true, qXDLLeftRight);
                BooleanQuery qEdgeDL = null;
                if (bbox.getMinX() == bbox.getMaxX() && Math.abs(bbox.getMinX()) == 180.0) {
                    double edge = bbox.getMinX() * -1.0;
                    qEdgeDL = this.makeQuery(BooleanClause.Occur.SHOULD, this.makeNumberTermQuery(this.field_minX, edge), this.makeNumberTermQuery(this.field_maxX, edge));
                }
                xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qNonXDL, qXDL, qEdgeDL);
            }
        } else {
            NumericRangeQuery<Double> qXDLLeft = NumericRangeQuery.newDoubleRange(this.field_minX, this.getPrecisionStep(), null, bbox.getMinX(), false, true);
            NumericRangeQuery<Double> qXDLRight = NumericRangeQuery.newDoubleRange(this.field_maxX, this.getPrecisionStep(), bbox.getMaxX(), null, true, false);
            Query qXDLLeftRight = this.makeXDL(true, this.makeQuery(BooleanClause.Occur.MUST, qXDLLeft, qXDLRight));
            BooleanQuery qWorld = this.makeQuery(BooleanClause.Occur.MUST, this.makeNumberTermQuery(this.field_minX, -180.0), this.makeNumberTermQuery(this.field_maxX, 180.0));
            xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qXDLLeftRight, qWorld);
        }
        return this.makeQuery(BooleanClause.Occur.MUST, xConditions, yConditions);
    }

    Query makeDisjoint(Rectangle bbox) {
        Query xConditions;
        NumericRangeQuery<Double> qMinY = NumericRangeQuery.newDoubleRange(this.field_minY, this.getPrecisionStep(), bbox.getMaxY(), null, false, false);
        NumericRangeQuery<Double> qMaxY = NumericRangeQuery.newDoubleRange(this.field_maxY, this.getPrecisionStep(), null, bbox.getMinY(), false, false);
        BooleanQuery yConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qMinY, qMaxY);
        if (!bbox.getCrossesDateLine()) {
            Query qMinX = NumericRangeQuery.newDoubleRange(this.field_minX, this.getPrecisionStep(), bbox.getMaxX(), null, false, false);
            if (bbox.getMinX() == -180.0 && this.ctx.isGeo()) {
                BooleanQuery bq = new BooleanQuery();
                bq.add(qMinX, BooleanClause.Occur.MUST);
                bq.add(this.makeNumberTermQuery(this.field_maxX, 180.0), BooleanClause.Occur.MUST_NOT);
                qMinX = bq;
            }
            Query qMaxX = NumericRangeQuery.newDoubleRange(this.field_maxX, this.getPrecisionStep(), null, bbox.getMinX(), false, false);
            if (bbox.getMaxX() == 180.0 && this.ctx.isGeo()) {
                BooleanQuery bq = new BooleanQuery();
                bq.add(qMaxX, BooleanClause.Occur.MUST);
                bq.add(this.makeNumberTermQuery(this.field_minX, -180.0), BooleanClause.Occur.MUST_NOT);
                qMaxX = bq;
            }
            BooleanQuery qMinMax = this.makeQuery(BooleanClause.Occur.SHOULD, qMinX, qMaxX);
            Query qNonXDL = this.makeXDL(false, qMinMax);
            if (!this.ctx.isGeo()) {
                xConditions = qNonXDL;
            } else {
                NumericRangeQuery<Double> qMinXLeft = NumericRangeQuery.newDoubleRange(this.field_minX, this.getPrecisionStep(), bbox.getMaxX(), null, false, false);
                NumericRangeQuery<Double> qMaxXRight = NumericRangeQuery.newDoubleRange(this.field_maxX, this.getPrecisionStep(), null, bbox.getMinX(), false, false);
                BooleanQuery qLeftRight = this.makeQuery(BooleanClause.Occur.MUST, qMinXLeft, qMaxXRight);
                Query qXDL = this.makeXDL(true, qLeftRight);
                xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qNonXDL, qXDL);
            }
        } else {
            NumericRangeQuery<Double> qMinXLeft = NumericRangeQuery.newDoubleRange(this.field_minX, this.getPrecisionStep(), 180.0, null, false, false);
            NumericRangeQuery<Double> qMaxXLeft = NumericRangeQuery.newDoubleRange(this.field_maxX, this.getPrecisionStep(), null, bbox.getMinX(), false, false);
            NumericRangeQuery<Double> qMinXRight = NumericRangeQuery.newDoubleRange(this.field_minX, this.getPrecisionStep(), bbox.getMaxX(), null, false, false);
            NumericRangeQuery<Double> qMaxXRight = NumericRangeQuery.newDoubleRange(this.field_maxX, this.getPrecisionStep(), null, -180.0, false, false);
            BooleanQuery qLeft = this.makeQuery(BooleanClause.Occur.SHOULD, qMinXLeft, qMaxXLeft);
            BooleanQuery qRight = this.makeQuery(BooleanClause.Occur.SHOULD, qMinXRight, qMaxXRight);
            BooleanQuery qLeftRight = this.makeQuery(BooleanClause.Occur.MUST, qLeft, qRight);
            xConditions = this.makeXDL(false, qLeftRight);
        }
        return this.makeQuery(BooleanClause.Occur.SHOULD, xConditions, yConditions);
    }

    Query makeEquals(Rectangle bbox) {
        Query qMinX = this.makeNumberTermQuery(this.field_minX, bbox.getMinX());
        Query qMinY = this.makeNumberTermQuery(this.field_minY, bbox.getMinY());
        Query qMaxX = this.makeNumberTermQuery(this.field_maxX, bbox.getMaxX());
        Query qMaxY = this.makeNumberTermQuery(this.field_maxY, bbox.getMaxY());
        return this.makeQuery(BooleanClause.Occur.MUST, qMinX, qMinY, qMaxX, qMaxY);
    }

    Query makeIntersects(Rectangle bbox) {
        Query qHasEnv;
        if (this.ctx.isGeo()) {
            Query qIsNonXDL = this.makeXDL(false);
            Query qIsXDL = this.ctx.isGeo() ? this.makeXDL(true) : null;
            qHasEnv = this.makeQuery(BooleanClause.Occur.SHOULD, qIsNonXDL, qIsXDL);
        } else {
            qHasEnv = this.makeXDL(false);
        }
        BooleanQuery qNotDisjoint = new BooleanQuery();
        qNotDisjoint.add(qHasEnv, BooleanClause.Occur.MUST);
        Query qDisjoint = this.makeDisjoint(bbox);
        qNotDisjoint.add(qDisjoint, BooleanClause.Occur.MUST_NOT);
        return qNotDisjoint;
    }

    BooleanQuery makeQuery(BooleanClause.Occur occur, Query ... queries) {
        BooleanQuery bq = new BooleanQuery();
        for (Query query : queries) {
            if (query == null) continue;
            bq.add(query, occur);
        }
        return bq;
    }

    Query makeWithin(Rectangle bbox) {
        Query xConditions;
        NumericRangeQuery<Double> qMinY = NumericRangeQuery.newDoubleRange(this.field_minY, this.getPrecisionStep(), bbox.getMinY(), null, true, false);
        NumericRangeQuery<Double> qMaxY = NumericRangeQuery.newDoubleRange(this.field_maxY, this.getPrecisionStep(), null, bbox.getMaxY(), false, true);
        BooleanQuery yConditions = this.makeQuery(BooleanClause.Occur.MUST, qMinY, qMaxY);
        if (this.ctx.isGeo() && bbox.getMinX() == -180.0 && bbox.getMaxX() == 180.0) {
            return yConditions;
        }
        if (!bbox.getCrossesDateLine()) {
            NumericRangeQuery<Double> qMinX = NumericRangeQuery.newDoubleRange(this.field_minX, this.getPrecisionStep(), bbox.getMinX(), null, true, false);
            NumericRangeQuery<Double> qMaxX = NumericRangeQuery.newDoubleRange(this.field_maxX, this.getPrecisionStep(), null, bbox.getMaxX(), false, true);
            BooleanQuery qMinMax = this.makeQuery(BooleanClause.Occur.MUST, qMinX, qMaxX);
            double edge = 0.0;
            if (bbox.getMinX() == -180.0) {
                edge = 180.0;
            } else if (bbox.getMaxX() == 180.0) {
                edge = -180.0;
            }
            if (edge != 0.0 && this.ctx.isGeo()) {
                BooleanQuery edgeQ = this.makeQuery(BooleanClause.Occur.MUST, this.makeNumberTermQuery(this.field_minX, edge), this.makeNumberTermQuery(this.field_maxX, edge));
                qMinMax = this.makeQuery(BooleanClause.Occur.SHOULD, qMinMax, edgeQ);
            }
            xConditions = this.makeXDL(false, qMinMax);
        } else {
            NumericRangeQuery<Double> qMinXLeft = NumericRangeQuery.newDoubleRange(this.field_minX, this.getPrecisionStep(), bbox.getMinX(), null, true, false);
            NumericRangeQuery<Double> qMaxXLeft = NumericRangeQuery.newDoubleRange(this.field_maxX, this.getPrecisionStep(), null, 180.0, false, true);
            BooleanQuery qLeft = this.makeQuery(BooleanClause.Occur.MUST, qMinXLeft, qMaxXLeft);
            NumericRangeQuery<Double> qMinXRight = NumericRangeQuery.newDoubleRange(this.field_minX, this.getPrecisionStep(), -180.0, null, true, false);
            NumericRangeQuery<Double> qMaxXRight = NumericRangeQuery.newDoubleRange(this.field_maxX, this.getPrecisionStep(), null, bbox.getMaxX(), false, true);
            BooleanQuery qRight = this.makeQuery(BooleanClause.Occur.MUST, qMinXRight, qMaxXRight);
            BooleanQuery qLeftRight = this.makeQuery(BooleanClause.Occur.SHOULD, qLeft, qRight);
            Query qNonXDL = this.makeXDL(false, qLeftRight);
            NumericRangeQuery<Double> qXDLLeft = NumericRangeQuery.newDoubleRange(this.field_minX, this.getPrecisionStep(), bbox.getMinX(), null, true, false);
            NumericRangeQuery<Double> qXDLRight = NumericRangeQuery.newDoubleRange(this.field_maxX, this.getPrecisionStep(), null, bbox.getMaxX(), false, true);
            BooleanQuery qXDLLeftRight = this.makeQuery(BooleanClause.Occur.MUST, qXDLLeft, qXDLRight);
            Query qXDL = this.makeXDL(true, qXDLLeftRight);
            xConditions = this.makeQuery(BooleanClause.Occur.SHOULD, qNonXDL, qXDL);
        }
        return this.makeQuery(BooleanClause.Occur.MUST, xConditions, yConditions);
    }

    private Query makeXDL(boolean crossedDateLine) {
        return new TermQuery(new Term(this.field_xdl, crossedDateLine ? "T" : "F"));
    }

    private Query makeXDL(boolean crossedDateLine, Query query) {
        if (!this.ctx.isGeo()) {
            assert (!crossedDateLine);
            return query;
        }
        BooleanQuery bq = new BooleanQuery();
        bq.add(this.makeXDL(crossedDateLine), BooleanClause.Occur.MUST);
        bq.add(query, BooleanClause.Occur.MUST);
        return bq;
    }

    private Query makeNumberTermQuery(String field, double number) {
        BytesRefBuilder bytes = new BytesRefBuilder();
        NumericUtils.longToPrefixCodedBytes(NumericUtils.doubleToSortableLong(number), 0, bytes);
        return new TermQuery(new Term(field, bytes.get()));
    }

    private static class ComboField
    extends Field {
        private ComboField(String name, Object value, FieldType type) {
            super(name, type);
            this.fieldsData = value;
        }

        @Override
        public Number numericValue() {
            Number number = super.numericValue();
            if (number == null) {
                return null;
            }
            if (this.fieldType().numericType() == FieldType.NumericType.DOUBLE) {
                return Double.doubleToLongBits(number.doubleValue());
            }
            if (this.fieldType().numericType() == FieldType.NumericType.FLOAT) {
                return Float.floatToIntBits(number.floatValue());
            }
            return number.longValue();
        }
    }
}

