/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.postingshighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanPositionCheckQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.LevenshteinAutomata;
import org.apache.lucene.util.automaton.Operations;

class MultiTermHighlighting {
    MultiTermHighlighting() {
    }

    static CharacterRunAutomaton[] extractAutomata(Query query, String field) {
        TermRangeQuery tq;
        ArrayList<CharacterRunAutomaton> list = new ArrayList<CharacterRunAutomaton>();
        if (query instanceof BooleanQuery) {
            BooleanClause[] clauses;
            for (BooleanClause clause : clauses = ((BooleanQuery)query).getClauses()) {
                if (clause.isProhibited()) continue;
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(clause.getQuery(), field)));
            }
        } else if (query instanceof FilteredQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((FilteredQuery)query).getQuery(), field)));
        } else if (query instanceof ConstantScoreQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((ConstantScoreQuery)query).getQuery(), field)));
        } else if (query instanceof DisjunctionMaxQuery) {
            for (Query sub : ((DisjunctionMaxQuery)query).getDisjuncts()) {
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(sub, field)));
            }
        } else if (query instanceof SpanOrQuery) {
            for (SpanQuery sub : ((SpanOrQuery)query).getClauses()) {
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(sub, field)));
            }
        } else if (query instanceof SpanNearQuery) {
            for (SpanQuery sub : ((SpanNearQuery)query).getClauses()) {
                list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(sub, field)));
            }
        } else if (query instanceof SpanNotQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((SpanNotQuery)query).getInclude(), field)));
        } else if (query instanceof SpanPositionCheckQuery) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((SpanPositionCheckQuery)query).getMatch(), field)));
        } else if (query instanceof SpanMultiTermQueryWrapper) {
            list.addAll(Arrays.asList(MultiTermHighlighting.extractAutomata(((SpanMultiTermQueryWrapper)query).getWrappedQuery(), field)));
        } else if (query instanceof AutomatonQuery) {
            final AutomatonQuery aq = (AutomatonQuery)query;
            if (aq.getField().equals(field)) {
                list.add(new CharacterRunAutomaton(aq.getAutomaton()){

                    @Override
                    public String toString() {
                        return aq.toString();
                    }
                });
            }
        } else if (query instanceof PrefixQuery) {
            final PrefixQuery pq = (PrefixQuery)query;
            Term prefix = pq.getPrefix();
            if (prefix.field().equals(field)) {
                list.add(new CharacterRunAutomaton(Operations.concatenate(Automata.makeString(prefix.text()), Automata.makeAnyString())){

                    @Override
                    public String toString() {
                        return pq.toString();
                    }
                });
            }
        } else if (query instanceof FuzzyQuery) {
            final FuzzyQuery fq = (FuzzyQuery)query;
            if (fq.getField().equals(field)) {
                int cp;
                String utf16 = fq.getTerm().text();
                int[] termText = new int[utf16.codePointCount(0, utf16.length())];
                int j = 0;
                for (int i = 0; i < utf16.length(); i += Character.charCount(cp)) {
                    termText[j++] = cp = utf16.codePointAt(i);
                }
                int termLength = termText.length;
                int prefixLength = Math.min(fq.getPrefixLength(), termLength);
                String suffix = UnicodeUtil.newString(termText, prefixLength, termText.length - prefixLength);
                LevenshteinAutomata builder = new LevenshteinAutomata(suffix, fq.getTranspositions());
                String prefix = UnicodeUtil.newString(termText, 0, prefixLength);
                Automaton automaton = builder.toAutomaton(fq.getMaxEdits(), prefix);
                list.add(new CharacterRunAutomaton(automaton){

                    @Override
                    public String toString() {
                        return fq.toString();
                    }
                });
            }
        } else if (query instanceof TermRangeQuery && (tq = (TermRangeQuery)query).getField().equals(field)) {
            final CharsRef lowerBound = tq.getLowerTerm() == null ? null : new CharsRef(tq.getLowerTerm().utf8ToString());
            final CharsRef upperBound = tq.getUpperTerm() == null ? null : new CharsRef(tq.getUpperTerm().utf8ToString());
            final boolean includeLower = tq.includesLower();
            final boolean includeUpper = tq.includesUpper();
            final CharsRef scratch = new CharsRef();
            final Comparator<CharsRef> comparator = CharsRef.getUTF16SortedAsUTF8Comparator();
            list.add(new CharacterRunAutomaton(Automata.makeEmpty()){

                @Override
                public boolean run(char[] s, int offset, int length) {
                    int cmp;
                    scratch.chars = s;
                    scratch.offset = offset;
                    scratch.length = length;
                    if (lowerBound != null && ((cmp = comparator.compare(scratch, lowerBound)) < 0 || !includeLower && cmp == 0)) {
                        return false;
                    }
                    return upperBound == null || (cmp = comparator.compare(scratch, upperBound)) <= 0 && (includeUpper || cmp != 0);
                }

                @Override
                public String toString() {
                    return tq.toString();
                }
            });
        }
        return list.toArray(new CharacterRunAutomaton[list.size()]);
    }

    static DocsAndPositionsEnum getDocsEnum(final TokenStream ts, final CharacterRunAutomaton[] matchers) throws IOException {
        final CharTermAttribute charTermAtt = ts.addAttribute(CharTermAttribute.class);
        final OffsetAttribute offsetAtt = ts.addAttribute(OffsetAttribute.class);
        ts.reset();
        return new DocsAndPositionsEnum(){
            int currentDoc = -1;
            int currentMatch = -1;
            int currentStartOffset = -1;
            int currentEndOffset = -1;
            TokenStream stream = ts;
            final BytesRef[] matchDescriptions = new BytesRef[matchers.length];

            @Override
            public int nextPosition() throws IOException {
                if (this.stream != null) {
                    while (this.stream.incrementToken()) {
                        for (int i = 0; i < matchers.length; ++i) {
                            if (!matchers[i].run(charTermAtt.buffer(), 0, charTermAtt.length())) continue;
                            this.currentStartOffset = offsetAtt.startOffset();
                            this.currentEndOffset = offsetAtt.endOffset();
                            this.currentMatch = i;
                            return 0;
                        }
                    }
                    this.stream.end();
                    this.stream.close();
                    this.stream = null;
                }
                this.currentEndOffset = Integer.MAX_VALUE;
                this.currentStartOffset = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public int freq() throws IOException {
                return Integer.MAX_VALUE;
            }

            @Override
            public int startOffset() throws IOException {
                assert (this.currentStartOffset >= 0);
                return this.currentStartOffset;
            }

            @Override
            public int endOffset() throws IOException {
                assert (this.currentEndOffset >= 0);
                return this.currentEndOffset;
            }

            @Override
            public BytesRef getPayload() throws IOException {
                if (this.matchDescriptions[this.currentMatch] == null) {
                    this.matchDescriptions[this.currentMatch] = new BytesRef(matchers[this.currentMatch].toString());
                }
                return this.matchDescriptions[this.currentMatch];
            }

            @Override
            public int docID() {
                return this.currentDoc;
            }

            @Override
            public int nextDoc() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int advance(int target) throws IOException {
                this.currentDoc = target;
                return this.currentDoc;
            }

            @Override
            public long cost() {
                return 0L;
            }
        };
    }
}

