/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.grouping.AbstractAllGroupsCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;

public class TermAllGroupsCollector
extends AbstractAllGroupsCollector<BytesRef> {
    private static final int DEFAULT_INITIAL_SIZE = 128;
    private final String groupField;
    private final SentinelIntSet ordSet;
    private final List<BytesRef> groups;
    private SortedDocValues index;

    public TermAllGroupsCollector(String groupField, int initialSize) {
        this.ordSet = new SentinelIntSet(initialSize, -2);
        this.groups = new ArrayList<BytesRef>(initialSize);
        this.groupField = groupField;
    }

    public TermAllGroupsCollector(String groupField) {
        this(groupField, 128);
    }

    @Override
    public void collect(int doc) throws IOException {
        int key = this.index.getOrd(doc);
        if (!this.ordSet.exists(key)) {
            this.ordSet.put(key);
            BytesRef term = key == -1 ? null : BytesRef.deepCopyOf(this.index.lookupOrd(key));
            this.groups.add(term);
        }
    }

    @Override
    public Collection<BytesRef> getGroups() {
        return this.groups;
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.index = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.groupField);
        this.ordSet.clear();
        for (BytesRef countedGroup : this.groups) {
            if (countedGroup == null) {
                this.ordSet.put(-1);
                continue;
            }
            int ord = this.index.lookupTerm(countedGroup);
            if (ord < 0) continue;
            this.ordSet.put(ord);
        }
    }
}

