/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.sorter;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.FixedBitSet;

public class BlockJoinComparatorSource
extends FieldComparatorSource {
    final Filter parentsFilter;
    final Sort parentSort;
    final Sort childSort;

    public BlockJoinComparatorSource(Filter parentsFilter, Sort parentSort) {
        this(parentsFilter, parentSort, new Sort(SortField.FIELD_DOC));
    }

    public BlockJoinComparatorSource(Filter parentsFilter, Sort parentSort, Sort childSort) {
        this.parentsFilter = parentsFilter;
        this.parentSort = parentSort;
        this.childSort = childSort;
    }

    public FieldComparator<Integer> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        final int[] parentSlots = new int[numHits];
        final int[] childSlots = new int[numHits];
        SortField[] parentFields = this.parentSort.getSort();
        final int[] parentReverseMul = new int[parentFields.length];
        final FieldComparator[] parentComparators = new FieldComparator[parentFields.length];
        for (int i = 0; i < parentFields.length; ++i) {
            parentReverseMul[i] = parentFields[i].getReverse() ? -1 : 1;
            parentComparators[i] = parentFields[i].getComparator(1, i);
        }
        SortField[] childFields = this.childSort.getSort();
        final int[] childReverseMul = new int[childFields.length];
        final FieldComparator[] childComparators = new FieldComparator[childFields.length];
        for (int i = 0; i < childFields.length; ++i) {
            childReverseMul[i] = childFields[i].getReverse() ? -1 : 1;
            childComparators[i] = childFields[i].getComparator(1, i);
        }
        return new FieldComparator<Integer>(){
            int bottomParent;
            int bottomChild;
            FixedBitSet parentBits;

            @Override
            public int compare(int slot1, int slot2) {
                try {
                    return this.compare(childSlots[slot1], parentSlots[slot1], childSlots[slot2], parentSlots[slot2]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void setBottom(int slot) {
                this.bottomParent = parentSlots[slot];
                this.bottomChild = childSlots[slot];
            }

            @Override
            public void setTopValue(Integer value) {
                throw new UnsupportedOperationException("this comparator cannot be used with deep paging");
            }

            @Override
            public int compareBottom(int doc) throws IOException {
                return this.compare(this.bottomChild, this.bottomParent, doc, this.parent(doc));
            }

            @Override
            public int compareTop(int doc) throws IOException {
                throw new UnsupportedOperationException("this comparator cannot be used with deep paging");
            }

            @Override
            public void copy(int slot, int doc) throws IOException {
                childSlots[slot] = doc;
                parentSlots[slot] = this.parent(doc);
            }

            @Override
            public FieldComparator<Integer> setNextReader(AtomicReaderContext context) throws IOException {
                int i;
                DocIdSet parents = BlockJoinComparatorSource.this.parentsFilter.getDocIdSet(context, null);
                if (parents == null) {
                    throw new IllegalStateException("AtomicReader " + context.reader() + " contains no parents!");
                }
                if (!(parents instanceof FixedBitSet)) {
                    throw new IllegalStateException("parentFilter must return FixedBitSet; got " + parents);
                }
                this.parentBits = (FixedBitSet)parents;
                for (i = 0; i < parentComparators.length; ++i) {
                    parentComparators[i] = parentComparators[i].setNextReader(context);
                }
                for (i = 0; i < childComparators.length; ++i) {
                    childComparators[i] = childComparators[i].setNextReader(context);
                }
                return this;
            }

            @Override
            public Integer value(int slot) {
                throw new UnsupportedOperationException("filling sort field values is not yet supported");
            }

            @Override
            public void setScorer(Scorer scorer) {
                super.setScorer(scorer);
                for (FieldComparator comp : parentComparators) {
                    comp.setScorer(scorer);
                }
                for (FieldComparator comp : childComparators) {
                    comp.setScorer(scorer);
                }
            }

            int parent(int doc) {
                return this.parentBits.nextSetBit(doc);
            }

            int compare(int docID1, int parent1, int docID2, int parent2) throws IOException {
                if (parent1 == parent2) {
                    if (docID1 == parent1 || docID2 == parent2) {
                        return docID1 - docID2;
                    }
                    return this.compare(docID1, docID2, childComparators, childReverseMul);
                }
                int cmp = this.compare(parent1, parent2, parentComparators, parentReverseMul);
                if (cmp == 0) {
                    return parent1 - parent2;
                }
                return cmp;
            }

            int compare(int docID1, int docID2, FieldComparator<?>[] comparators, int[] reverseMul) throws IOException {
                for (int i = 0; i < comparators.length; ++i) {
                    comparators[i].copy(0, docID1);
                    comparators[i].setBottom(0);
                    int comp = reverseMul[i] * comparators[i].compareBottom(docID2);
                    if (comp == 0) continue;
                    return comp;
                }
                return 0;
            }
        };
    }

    public String toString() {
        return "blockJoin(parentSort=" + this.parentSort + ",childSort=" + this.childSort + ")";
    }
}

