/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;

public class IndexGate {
    static HashMap<String, String> knownExtensions = new HashMap();
    public static final int OLD_FORMAT = -1;
    public static final int FORMAT_LOCKLESS = -2;
    public static final int FORMAT_SINGLE_NORM_FILE = -3;
    public static final int FORMAT_SHARED_DOC_STORE = -4;
    public static final int FORMAT_CHECKSUM = -5;
    public static final int FORMAT_DEL_COUNT = -6;
    public static final int FORMAT_HAS_PROX = -7;
    public static final int FORMAT_USER_DATA = -8;
    public static final int FORMAT_DIAGNOSTICS = -9;
    public static final int FORMAT_HAS_VECTORS = -10;
    public static final int FORMAT_3_1 = -11;
    public static final int FORMAT_PRE_4 = -12;

    public static String getFileFunction(String file) {
        if (file == null || file.trim().length() == 0) {
            return file;
        }
        String res = null;
        file = file.trim();
        int idx = file.indexOf(46);
        String suffix = null;
        if (idx != -1) {
            suffix = file.substring(idx + 1);
        }
        if (suffix == null) {
            if (file.startsWith("segments_")) {
                return knownExtensions.get("segments");
            }
        } else {
            res = knownExtensions.get(suffix);
            if (res != null) {
                return res;
            }
            if (suffix.length() == 2) {
                res = knownExtensions.get(suffix.substring(0, 1));
            }
        }
        return res;
    }

    private static void detectOldFormats(FormatDetails res, int format) {
        switch (format) {
            case -1: {
                res.capabilities = "old plain";
                res.genericName = "Lucene Pre-2.1";
                res.version = "2.0?";
                break;
            }
            case -2: {
                res.capabilities = "lock-less";
                res.genericName = "Lucene 2.1";
                res.version = "2.1";
                break;
            }
            case -3: {
                res.capabilities = "lock-less, single norms file";
                res.genericName = "Lucene 2.2";
                res.version = "2.2";
                break;
            }
            case -4: {
                res.capabilities = "lock-less, single norms file, shared doc store";
                res.genericName = "Lucene 2.3";
                res.version = "2.3";
                break;
            }
            case -5: {
                res.capabilities = "lock-less, single norms, shared doc store, checksum";
                res.genericName = "Lucene 2.4";
                res.version = "2.4";
                break;
            }
            case -6: {
                res.capabilities = "lock-less, single norms, shared doc store, checksum, del count";
                res.genericName = "Lucene 2.4";
                res.version = "2.4";
                break;
            }
            case -7: {
                res.capabilities = "lock-less, single norms, shared doc store, checksum, del count, omitTf";
                res.genericName = "Lucene 2.4";
                res.version = "2.4";
                break;
            }
            case -8: {
                res.capabilities = "lock-less, single norms, shared doc store, checksum, del count, omitTf, user data";
                res.genericName = "Lucene 2.9-dev";
                res.version = "2.9-dev";
                break;
            }
            case -9: {
                res.capabilities = "lock-less, single norms, shared doc store, checksum, del count, omitTf, user data, diagnostics";
                res.genericName = "Lucene 2.9";
                res.version = "2.9";
                break;
            }
            case -10: {
                res.capabilities = "lock-less, single norms, shared doc store, checksum, del count, omitTf, user data, diagnostics, hasVectors";
                res.genericName = "Lucene 2.9";
                res.version = "2.9";
                break;
            }
            case -11: {
                res.capabilities = "lock-less, single norms, shared doc store, checksum, del count, omitTf, user data, diagnostics, hasVectors";
                res.genericName = "Lucene 3.1";
                res.version = "3.1";
                break;
            }
            case -12: {
                res.capabilities = "flexible, unreleased 4.0 pre-alpha";
                res.genericName = "Lucene 4.0-dev";
                res.version = "4.0-dev";
                break;
            }
            default: {
                if (format < -12) {
                    res.capabilities = "flexible, unreleased 4.0 pre-alpha";
                    res.genericName = "Lucene 4.0-dev";
                    res.version = "4.0-dev";
                    break;
                }
                res.capabilities = "unknown";
                res.genericName = "Lucene 1.3 or earlier, or unreleased";
                res.version = "1.3?";
            }
        }
        res.genericName = res.genericName + " (" + format + ")";
    }

    public static FormatDetails getIndexFormat(final Directory dir) throws Exception {
        SegmentInfos.FindSegmentsFile fsf = new SegmentInfos.FindSegmentsFile(dir){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object doBody(String segmentsFile) throws IOException {
                FormatDetails res;
                block8: {
                    res = new FormatDetails();
                    res.capabilities = "unknown";
                    res.genericName = "unknown";
                    IndexInput in = dir.openInput(segmentsFile, IOContext.READ);
                    try {
                        int indexFormat = in.readInt();
                        if (indexFormat == 1071082519) {
                            res.genericName = "Lucene 4.x";
                            res.capabilities = "flexible, codec-specific";
                            int actualVersion = 0;
                            try {
                                actualVersion = CodecUtil.checkHeaderNoMagic(in, "segments", 0, Integer.MAX_VALUE);
                                if (actualVersion > 1) {
                                    res.capabilities = res.capabilities + " (WARNING: newer version of Lucene than this tool)";
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                res.capabilities = res.capabilities + " (error reading: " + e.getMessage() + ")";
                            }
                            res.genericName = "Lucene 4." + actualVersion;
                            res.version = "4." + actualVersion;
                            break block8;
                        }
                        res.genericName = "Lucene 3.x or prior";
                        IndexGate.detectOldFormats(res, indexFormat);
                        if (res.version.compareTo("3") < 0) {
                            res.capabilities = res.capabilities + " (UNSUPPORTED)";
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                return res;
            }
        };
        return (FormatDetails)fsf.run();
    }

    public static boolean preferCompoundFormat(Directory dir) throws Exception {
        SegmentInfos infos = new SegmentInfos();
        infos.read(dir);
        int compound = 0;
        int nonCompound = 0;
        for (int i = 0; i < infos.size(); ++i) {
            if (infos.info((int)i).info.getUseCompoundFile()) {
                ++compound;
                continue;
            }
            ++nonCompound;
        }
        return compound > nonCompound;
    }

    public static List<String> getDeletableFiles(Directory dir) throws Exception {
        List<String> known = IndexGate.getIndexFiles(dir);
        HashSet<String> dirFiles = new HashSet<String>(Arrays.asList(dir.listAll()));
        dirFiles.removeAll(known);
        return new ArrayList<String>(dirFiles);
    }

    public static List<String> getIndexFiles(Directory dir) throws Exception {
        List<IndexCommit> commits = null;
        try {
            commits = DirectoryReader.listCommits(dir);
        }
        catch (IndexNotFoundException e) {
            return Collections.emptyList();
        }
        HashSet<String> known = new HashSet<String>();
        for (IndexCommit ic : commits) {
            known.addAll(ic.getFileNames());
        }
        if (dir.fileExists("segments.gen")) {
            known.add("segments.gen");
        }
        ArrayList<String> names = new ArrayList<String>(known);
        Collections.sort(names);
        return names;
    }

    static {
        knownExtensions.put("cfs", "compound file with various index data");
        knownExtensions.put("cfe", "compound file entries list");
        knownExtensions.put("gen", "generation number - global file");
        knownExtensions.put("segments", "per-commit list of segments and user data");
    }

    public static class FormatDetails {
        public String genericName = "N/A";
        public String capabilities = "N/A";
        public String version = "N/A";
    }
}

