/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortRescorer;
import org.apache.lucene.search.Weight;

class ExpressionRescorer
extends SortRescorer {
    private final Expression expression;
    private final Bindings bindings;

    public ExpressionRescorer(Expression expression, Bindings bindings) {
        super(new Sort(expression.getSortField(bindings, true)));
        this.expression = expression;
        this.bindings = bindings;
    }

    @Override
    public Explanation explain(IndexSearcher searcher, Explanation firstPassExplanation, int docID) throws IOException {
        Explanation result = super.explain(searcher, firstPassExplanation, docID);
        List<AtomicReaderContext> leaves = searcher.getIndexReader().leaves();
        int subReader = ReaderUtil.subIndex(docID, leaves);
        AtomicReaderContext readerContext = leaves.get(subReader);
        int docIDInSegment = docID - readerContext.docBase;
        HashMap<String, FakeScorer> context = new HashMap<String, FakeScorer>();
        FakeScorer fakeScorer = new FakeScorer();
        fakeScorer.score = firstPassExplanation.getValue();
        fakeScorer.doc = docIDInSegment;
        context.put("scorer", fakeScorer);
        for (String variable : this.expression.variables) {
            result.addDetail(new Explanation((float)this.bindings.getValueSource(variable).getValues(context, readerContext).doubleVal(docIDInSegment), "variable \"" + variable + "\""));
        }
        return result;
    }

    private static class FakeScorer
    extends Scorer {
        float score;
        int doc = -1;
        int freq = 1;

        public FakeScorer() {
            super(null);
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException("FakeScorer doesn't support advance(int)");
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int freq() {
            return this.freq;
        }

        @Override
        public int nextDoc() {
            throw new UnsupportedOperationException("FakeScorer doesn't support nextDoc()");
        }

        @Override
        public float score() {
            return this.score;
        }

        @Override
        public long cost() {
            return 1L;
        }

        @Override
        public Weight getWeight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            throw new UnsupportedOperationException();
        }
    }
}

