/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;

public class SimpleTextStoredFieldsWriter
extends StoredFieldsWriter {
    private int numDocsWritten = 0;
    private final Directory directory;
    private final String segment;
    private IndexOutput out;
    static final String FIELDS_EXTENSION = "fld";
    static final BytesRef TYPE_STRING = new BytesRef("string");
    static final BytesRef TYPE_BINARY = new BytesRef("binary");
    static final BytesRef TYPE_INT = new BytesRef("int");
    static final BytesRef TYPE_LONG = new BytesRef("long");
    static final BytesRef TYPE_FLOAT = new BytesRef("float");
    static final BytesRef TYPE_DOUBLE = new BytesRef("double");
    static final BytesRef END = new BytesRef("END");
    static final BytesRef DOC = new BytesRef("doc ");
    static final BytesRef FIELD = new BytesRef("  field ");
    static final BytesRef NAME = new BytesRef("    name ");
    static final BytesRef TYPE = new BytesRef("    type ");
    static final BytesRef VALUE = new BytesRef("    value ");
    private final BytesRefBuilder scratch = new BytesRefBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTextStoredFieldsWriter(Directory directory, String segment, IOContext context) throws IOException {
        this.directory = directory;
        this.segment = segment;
        boolean success = false;
        try {
            this.out = directory.createOutput(IndexFileNames.segmentFileName(segment, "", FIELDS_EXTENSION), context);
            success = true;
        }
        finally {
            if (!success) {
                this.abort();
            }
        }
    }

    @Override
    public void startDocument() throws IOException {
        this.write(DOC);
        this.write(Integer.toString(this.numDocsWritten));
        this.newLine();
        ++this.numDocsWritten;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeField(FieldInfo info, IndexableField field) throws IOException {
        this.write(FIELD);
        this.write(Integer.toString(info.number));
        this.newLine();
        this.write(NAME);
        this.write(field.name());
        this.newLine();
        this.write(TYPE);
        Number n = field.numericValue();
        if (n != null) {
            if (n instanceof Byte || n instanceof Short || n instanceof Integer) {
                this.write(TYPE_INT);
                this.newLine();
                this.write(VALUE);
                this.write(Integer.toString(n.intValue()));
                this.newLine();
                return;
            } else if (n instanceof Long) {
                this.write(TYPE_LONG);
                this.newLine();
                this.write(VALUE);
                this.write(Long.toString(n.longValue()));
                this.newLine();
                return;
            } else if (n instanceof Float) {
                this.write(TYPE_FLOAT);
                this.newLine();
                this.write(VALUE);
                this.write(Float.toString(n.floatValue()));
                this.newLine();
                return;
            } else {
                if (!(n instanceof Double)) throw new IllegalArgumentException("cannot store numeric type " + n.getClass());
                this.write(TYPE_DOUBLE);
                this.newLine();
                this.write(VALUE);
                this.write(Double.toString(n.doubleValue()));
                this.newLine();
            }
            return;
        } else {
            BytesRef bytes = field.binaryValue();
            if (bytes != null) {
                this.write(TYPE_BINARY);
                this.newLine();
                this.write(VALUE);
                this.write(bytes);
                this.newLine();
                return;
            } else {
                if (field.stringValue() == null) {
                    throw new IllegalArgumentException("field " + field.name() + " is stored but does not have binaryValue, stringValue nor numericValue");
                }
                this.write(TYPE_STRING);
                this.newLine();
                this.write(VALUE);
                this.write(field.stringValue());
                this.newLine();
            }
        }
    }

    @Override
    public void abort() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        IOUtils.deleteFilesIgnoringExceptions(this.directory, IndexFileNames.segmentFileName(this.segment, "", FIELDS_EXTENSION));
    }

    @Override
    public void finish(FieldInfos fis, int numDocs) throws IOException {
        if (this.numDocsWritten != numDocs) {
            throw new RuntimeException("mergeFields produced an invalid result: docCount is " + numDocs + " but only saw " + this.numDocsWritten + " file=" + this.out.toString() + "; now aborting this merge to prevent index corruption");
        }
        this.write(END);
        this.newLine();
        SimpleTextUtil.writeChecksum(this.out, this.scratch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.out);
        }
        finally {
            this.out = null;
        }
    }

    private void write(String s) throws IOException {
        SimpleTextUtil.write(this.out, s, this.scratch);
    }

    private void write(BytesRef bytes) throws IOException {
        SimpleTextUtil.write(this.out, bytes);
    }

    private void newLine() throws IOException {
        SimpleTextUtil.writeNewline(this.out);
    }
}

