/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.codecs.SegmentInfoReader;
import org.apache.lucene.codecs.simpletext.SimpleTextSegmentInfoWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public class SimpleTextSegmentInfoReader
extends SegmentInfoReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory directory, String segmentName, IOContext context) throws IOException {
        SegmentInfo segmentInfo;
        block17: {
            ChecksumIndexInput input;
            block16: {
                BytesRefBuilder scratch = new BytesRefBuilder();
                String segFileName = IndexFileNames.segmentFileName(segmentName, "", "si");
                input = directory.openChecksumInput(segFileName, context);
                boolean success = false;
                try {
                    Version version;
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextSegmentInfoWriter.SI_VERSION));
                    try {
                        version = Version.parse(this.readString(SimpleTextSegmentInfoWriter.SI_VERSION.length, scratch));
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("unable to parse version string (resource=" + input + "): " + pe.getMessage(), pe);
                    }
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextSegmentInfoWriter.SI_DOCCOUNT));
                    int docCount = Integer.parseInt(this.readString(SimpleTextSegmentInfoWriter.SI_DOCCOUNT.length, scratch));
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextSegmentInfoWriter.SI_USECOMPOUND));
                    boolean isCompoundFile = Boolean.parseBoolean(this.readString(SimpleTextSegmentInfoWriter.SI_USECOMPOUND.length, scratch));
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextSegmentInfoWriter.SI_NUM_DIAG));
                    int numDiag = Integer.parseInt(this.readString(SimpleTextSegmentInfoWriter.SI_NUM_DIAG.length, scratch));
                    HashMap<String, String> diagnostics = new HashMap<String, String>();
                    for (int i = 0; i < numDiag; ++i) {
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), SimpleTextSegmentInfoWriter.SI_DIAG_KEY));
                        String key = this.readString(SimpleTextSegmentInfoWriter.SI_DIAG_KEY.length, scratch);
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), SimpleTextSegmentInfoWriter.SI_DIAG_VALUE));
                        String value = this.readString(SimpleTextSegmentInfoWriter.SI_DIAG_VALUE.length, scratch);
                        diagnostics.put(key, value);
                    }
                    SimpleTextUtil.readLine(input, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextSegmentInfoWriter.SI_NUM_FILES));
                    int numFiles = Integer.parseInt(this.readString(SimpleTextSegmentInfoWriter.SI_NUM_FILES.length, scratch));
                    HashSet<String> files = new HashSet<String>();
                    for (int i = 0; i < numFiles; ++i) {
                        SimpleTextUtil.readLine(input, scratch);
                        assert (StringHelper.startsWith(scratch.get(), SimpleTextSegmentInfoWriter.SI_FILE));
                        String fileName = this.readString(SimpleTextSegmentInfoWriter.SI_FILE.length, scratch);
                        files.add(fileName);
                    }
                    SimpleTextUtil.checkFooter(input);
                    SegmentInfo info = new SegmentInfo(directory, version, segmentName, docCount, isCompoundFile, null, diagnostics);
                    info.setFiles(files);
                    success = true;
                    segmentInfo = info;
                    if (success) break block16;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(input);
                    } else {
                        input.close();
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(input);
                break block17;
            }
            input.close();
        }
        return segmentInfo;
    }

    private String readString(int offset, BytesRefBuilder scratch) {
        return new String(scratch.bytes(), offset, scratch.length() - offset, StandardCharsets.UTF_8);
    }
}

