/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextDocValuesWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;

class SimpleTextDocValuesReader
extends DocValuesProducer {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SimpleTextDocValuesReader.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    final int maxDoc;
    final IndexInput data;
    final BytesRefBuilder scratch;
    final Map<String, OneField> fields;

    public SimpleTextDocValuesReader(SegmentReadState state, String ext) throws IOException {
        block15: {
            this.scratch = new BytesRefBuilder();
            this.fields = new HashMap<String, OneField>();
            this.data = state.directory.openInput(IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, ext), state.context);
            this.maxDoc = state.segmentInfo.getDocCount();
            while (true) {
                this.readLine();
                if (this.scratch.get().equals(SimpleTextDocValuesWriter.END)) break block15;
                assert (this.startsWith(SimpleTextDocValuesWriter.FIELD)) : this.scratch.get().utf8ToString();
                String fieldName = this.stripPrefix(SimpleTextDocValuesWriter.FIELD);
                OneField field = new OneField();
                this.fields.put(fieldName, field);
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.TYPE)) : this.scratch.get().utf8ToString();
                FieldInfo.DocValuesType dvType = FieldInfo.DocValuesType.valueOf(this.stripPrefix(SimpleTextDocValuesWriter.TYPE));
                assert (dvType != null);
                if (dvType == FieldInfo.DocValuesType.NUMERIC) {
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.MINVALUE)) : "got " + this.scratch.get().utf8ToString() + " field=" + fieldName + " ext=" + ext;
                    field.minValue = Long.parseLong(this.stripPrefix(SimpleTextDocValuesWriter.MINVALUE));
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                    field.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                    field.dataStartFilePointer = this.data.getFilePointer();
                    this.data.seek(this.data.getFilePointer() + (long)((1 + field.pattern.length() + 2) * this.maxDoc));
                    continue;
                }
                if (dvType == FieldInfo.DocValuesType.BINARY) {
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.MAXLENGTH));
                    field.maxLength = Integer.parseInt(this.stripPrefix(SimpleTextDocValuesWriter.MAXLENGTH));
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                    field.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                    field.dataStartFilePointer = this.data.getFilePointer();
                    this.data.seek(this.data.getFilePointer() + (long)((9 + field.pattern.length() + field.maxLength + 2) * this.maxDoc));
                    continue;
                }
                if (dvType != FieldInfo.DocValuesType.SORTED && dvType != FieldInfo.DocValuesType.SORTED_SET) break;
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.NUMVALUES));
                field.numValues = Long.parseLong(this.stripPrefix(SimpleTextDocValuesWriter.NUMVALUES));
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.MAXLENGTH));
                field.maxLength = Integer.parseInt(this.stripPrefix(SimpleTextDocValuesWriter.MAXLENGTH));
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                field.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.ORDPATTERN));
                field.ordPattern = this.stripPrefix(SimpleTextDocValuesWriter.ORDPATTERN);
                field.dataStartFilePointer = this.data.getFilePointer();
                this.data.seek(this.data.getFilePointer() + (long)(9 + field.pattern.length() + field.maxLength) * field.numValues + (long)((1 + field.ordPattern.length()) * this.maxDoc));
            }
            throw new AssertionError();
        }
        assert (!this.fields.isEmpty());
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        assert (field != null) : "field=" + fieldInfo.name + " fields=" + this.fields;
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        decoder.setParseBigDecimal(true);
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                try {
                    BigDecimal bd;
                    if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                        throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                    }
                    in.seek(field.dataStartFilePointer + (long)((1 + field.pattern.length() + 2) * docID));
                    SimpleTextUtil.readLine(in, scratch);
                    try {
                        bd = (BigDecimal)decoder.parse(scratch.get().utf8ToString());
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse BigDecimal value (resource=" + in + ")", pe);
                    }
                    SimpleTextUtil.readLine(in, scratch);
                    return BigInteger.valueOf(field.minValue).add(bd.toBigIntegerExact()).longValue();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
    }

    private Bits getNumericDocsWithField(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        return new Bits(){

            @Override
            public boolean get(int index) {
                try {
                    in.seek(field.dataStartFilePointer + (long)((1 + field.pattern.length() + 2) * index));
                    SimpleTextUtil.readLine(in, scratch);
                    SimpleTextUtil.readLine(in, scratch);
                    return scratch.byteAt(0) == 84;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int length() {
                return SimpleTextDocValuesReader.this.maxDoc;
            }
        };
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new BinaryDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();

            @Override
            public BytesRef get(int docID) {
                try {
                    int len;
                    if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                        throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                    }
                    in.seek(field.dataStartFilePointer + (long)((9 + field.pattern.length() + field.maxLength + 2) * docID));
                    SimpleTextUtil.readLine(in, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextDocValuesWriter.LENGTH));
                    try {
                        len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse int length (resource=" + in + ")", pe);
                    }
                    this.term.grow(len);
                    this.term.setLength(len);
                    in.readBytes(this.term.bytes(), 0, len);
                    return this.term.get();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
    }

    private Bits getBinaryDocsWithField(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new Bits(){

            @Override
            public boolean get(int index) {
                try {
                    int len;
                    in.seek(field.dataStartFilePointer + (long)((9 + field.pattern.length() + field.maxLength + 2) * index));
                    SimpleTextUtil.readLine(in, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextDocValuesWriter.LENGTH));
                    try {
                        len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse int length (resource=" + in + ")", pe);
                    }
                    byte[] bytes = new byte[len];
                    in.readBytes(bytes, 0, len);
                    SimpleTextUtil.readLine(in, scratch);
                    SimpleTextUtil.readLine(in, scratch);
                    return scratch.byteAt(0) == 84;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public int length() {
                return SimpleTextDocValuesReader.this.maxDoc;
            }
        };
    }

    @Override
    public SortedDocValues getSorted(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        final DecimalFormat ordDecoder = new DecimalFormat(field.ordPattern, new DecimalFormatSymbols(Locale.ROOT));
        return new SortedDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();

            @Override
            public int getOrd(int docID) {
                if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                    throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                }
                try {
                    in.seek(field.dataStartFilePointer + field.numValues * (long)(9 + field.pattern.length() + field.maxLength) + (long)(docID * (1 + field.ordPattern.length())));
                    SimpleTextUtil.readLine(in, scratch);
                    try {
                        return (int)ordDecoder.parse(scratch.get().utf8ToString()).longValue() - 1;
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse ord (resource=" + in + ")", pe);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                try {
                    int len;
                    if (ord < 0 || (long)ord >= field.numValues) {
                        throw new IndexOutOfBoundsException("ord must be 0 .. " + (field.numValues - 1L) + "; got " + ord);
                    }
                    in.seek(field.dataStartFilePointer + (long)(ord * (9 + field.pattern.length() + field.maxLength)));
                    SimpleTextUtil.readLine(in, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextDocValuesWriter.LENGTH)) : "got " + scratch.get().utf8ToString() + " in=" + in;
                    try {
                        len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse int length (resource=" + in + ")", pe);
                    }
                    this.term.grow(len);
                    this.term.setLength(len);
                    in.readBytes(this.term.bytes(), 0, len);
                    return this.term.get();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public int getValueCount() {
                return (int)field.numValues;
            }
        };
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        final BinaryDocValues binary = this.getBinary(field);
        return new SortedNumericDocValues(){
            long[] values;

            @Override
            public void setDocument(int doc) {
                String csv = binary.get(doc).utf8ToString();
                if (csv.length() == 0) {
                    this.values = new long[0];
                } else {
                    String[] s = csv.split(",");
                    this.values = new long[s.length];
                    for (int i = 0; i < this.values.length; ++i) {
                        this.values[i] = Long.parseLong(s[i]);
                    }
                }
            }

            @Override
            public long valueAt(int index) {
                return this.values[index];
            }

            @Override
            public int count() {
                return this.values.length;
            }
        };
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
        final OneField field = this.fields.get(fieldInfo.name);
        assert (field != null);
        final IndexInput in = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new SortedSetDocValues(){
            String[] currentOrds = new String[0];
            int currentIndex = 0;
            final BytesRefBuilder term = new BytesRefBuilder();

            @Override
            public long nextOrd() {
                if (this.currentIndex == this.currentOrds.length) {
                    return -1L;
                }
                return Long.parseLong(this.currentOrds[this.currentIndex++]);
            }

            @Override
            public void setDocument(int docID) {
                if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                    throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                }
                try {
                    in.seek(field.dataStartFilePointer + field.numValues * (long)(9 + field.pattern.length() + field.maxLength) + (long)(docID * (1 + field.ordPattern.length())));
                    SimpleTextUtil.readLine(in, scratch);
                    String ordList = scratch.get().utf8ToString().trim();
                    this.currentOrds = ordList.isEmpty() ? new String[0] : ordList.split(",");
                    this.currentIndex = 0;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                try {
                    int len;
                    if (ord < 0L || ord >= field.numValues) {
                        throw new IndexOutOfBoundsException("ord must be 0 .. " + (field.numValues - 1L) + "; got " + ord);
                    }
                    in.seek(field.dataStartFilePointer + ord * (long)(9 + field.pattern.length() + field.maxLength));
                    SimpleTextUtil.readLine(in, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextDocValuesWriter.LENGTH)) : "got " + scratch.get().utf8ToString() + " in=" + in;
                    try {
                        len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse int length (resource=" + in + ")", pe);
                    }
                    this.term.grow(len);
                    this.term.setLength(len);
                    in.readBytes(this.term.bytes(), 0, len);
                    return this.term.get();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public long getValueCount() {
                return field.numValues;
            }
        };
    }

    @Override
    public Bits getDocsWithField(FieldInfo field) throws IOException {
        switch (field.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue(this.getSortedSet(field), this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue(this.getSortedNumeric(field), this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue(this.getSorted(field), this.maxDoc);
            }
            case BINARY: {
                return this.getBinaryDocsWithField(field);
            }
            case NUMERIC: {
                return this.getNumericDocsWithField(field);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    private void readLine() throws IOException {
        SimpleTextUtil.readLine(this.data, this.scratch);
    }

    private boolean startsWith(BytesRef prefix) {
        return StringHelper.startsWith(this.scratch.get(), prefix);
    }

    private String stripPrefix(BytesRef prefix) throws IOException {
        return new String(this.scratch.bytes(), prefix.length, this.scratch.length() - prefix.length, StandardCharsets.UTF_8);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.scratch.bytes()) + (long)this.fields.size() * ((long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2L + OneField.BASE_RAM_BYTES_USED);
    }

    @Override
    public void checkIntegrity() throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        IndexInput clone = this.data.clone();
        clone.seek(0L);
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(clone);
        do {
            SimpleTextUtil.readLine(input, scratch);
        } while (!scratch.get().equals(SimpleTextDocValuesWriter.END));
        SimpleTextUtil.checkFooter(input);
    }

    static class OneField {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OneField.class);
        long dataStartFilePointer;
        String pattern;
        String ordPattern;
        int maxLength;
        boolean fixedLength;
        long minValue;
        long numValues;

        OneField() {
        }
    }
}

