/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.sep;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.sep.IntIndexInput;
import org.apache.lucene.codecs.sep.IntStreamFactory;
import org.apache.lucene.codecs.sep.SepSkipListReader;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.TermState;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

public class SepPostingsReader
extends PostingsReaderBase {
    private static final long RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SepPostingsReader.class);
    final IntIndexInput freqIn;
    final IntIndexInput docIn;
    final IntIndexInput posIn;
    final IndexInput payloadIn;
    final IndexInput skipIn;
    int skipInterval;
    int maxSkipLevels;
    int skipMinimum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SepPostingsReader(Directory dir, FieldInfos fieldInfos, SegmentInfo segmentInfo, IOContext context, IntStreamFactory intFactory, String segmentSuffix) throws IOException {
        boolean success = false;
        try {
            String docFileName = IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, "doc");
            this.docIn = intFactory.openInput(dir, docFileName, context);
            this.skipIn = dir.openInput(IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, "skp"), context);
            this.freqIn = fieldInfos.hasFreq() ? intFactory.openInput(dir, IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, "frq"), context) : null;
            if (fieldInfos.hasProx()) {
                this.posIn = intFactory.openInput(dir, IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, "pos"), context);
                this.payloadIn = dir.openInput(IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, "pyl"), context);
            } else {
                this.posIn = null;
                this.payloadIn = null;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    @Override
    public void init(IndexInput termsIn) throws IOException {
        CodecUtil.checkHeader(termsIn, "SepPostingsWriter", 0, 0);
        this.skipInterval = termsIn.readInt();
        this.maxSkipLevels = termsIn.readInt();
        this.skipMinimum = termsIn.readInt();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.freqIn, this.docIn, this.skipIn, this.posIn, this.payloadIn);
    }

    @Override
    public BlockTermState newTermState() throws IOException {
        SepTermState state = new SepTermState();
        state.docIndex = this.docIn.index();
        if (this.freqIn != null) {
            state.freqIndex = this.freqIn.index();
        }
        if (this.posIn != null) {
            state.posIndex = this.posIn.index();
        }
        return state;
    }

    @Override
    public void decodeTerm(long[] empty, DataInput in, FieldInfo fieldInfo, BlockTermState _termState, boolean absolute) throws IOException {
        SepTermState termState = (SepTermState)_termState;
        termState.docIndex.read(in, absolute);
        if (fieldInfo.getIndexOptions() != FieldInfo.IndexOptions.DOCS_ONLY) {
            termState.freqIndex.read(in, absolute);
            if (fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                termState.posIndex.read(in, absolute);
                if (fieldInfo.hasPayloads()) {
                    termState.payloadFP = absolute ? in.readVLong() : (termState.payloadFP += in.readVLong());
                }
            }
        }
        if (termState.docFreq >= this.skipMinimum) {
            termState.skipFP = absolute ? in.readVLong() : (termState.skipFP += in.readVLong());
        } else if (absolute) {
            termState.skipFP = 0L;
        }
    }

    @Override
    public DocsEnum docs(FieldInfo fieldInfo, BlockTermState _termState, Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
        SepDocsEnum docsEnum;
        SepTermState termState = (SepTermState)_termState;
        if (reuse == null || !(reuse instanceof SepDocsEnum)) {
            docsEnum = new SepDocsEnum();
        } else {
            docsEnum = (SepDocsEnum)reuse;
            if (docsEnum.startDocIn != this.docIn) {
                docsEnum = new SepDocsEnum();
            }
        }
        return docsEnum.init(fieldInfo, termState, liveDocs);
    }

    @Override
    public DocsAndPositionsEnum docsAndPositions(FieldInfo fieldInfo, BlockTermState _termState, Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
        SepDocsAndPositionsEnum postingsEnum;
        assert (fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        SepTermState termState = (SepTermState)_termState;
        if (reuse == null || !(reuse instanceof SepDocsAndPositionsEnum)) {
            postingsEnum = new SepDocsAndPositionsEnum();
        } else {
            postingsEnum = (SepDocsAndPositionsEnum)reuse;
            if (postingsEnum.startDocIn != this.docIn) {
                postingsEnum = new SepDocsAndPositionsEnum();
            }
        }
        return postingsEnum.init(fieldInfo, termState, liveDocs);
    }

    @Override
    public long ramBytesUsed() {
        return RAM_BYTES_USED;
    }

    @Override
    public void checkIntegrity() throws IOException {
    }

    class SepDocsAndPositionsEnum
    extends DocsAndPositionsEnum {
        int docFreq;
        int doc = -1;
        int accum;
        int count;
        int freq;
        long freqStart;
        private boolean storePayloads;
        private Bits liveDocs;
        private final IntIndexInput.Reader docReader;
        private final IntIndexInput.Reader freqReader;
        private final IntIndexInput.Reader posReader;
        private final IndexInput payloadIn;
        private long skipFP;
        private final IntIndexInput.Index docIndex;
        private final IntIndexInput.Index freqIndex;
        private final IntIndexInput.Index posIndex;
        private final IntIndexInput startDocIn;
        private long payloadFP;
        private int pendingPosCount;
        private int position;
        private int payloadLength;
        private long pendingPayloadBytes;
        private boolean skipped;
        private SepSkipListReader skipper;
        private boolean payloadPending;
        private boolean posSeekPending;
        private BytesRefBuilder payload;

        SepDocsAndPositionsEnum() throws IOException {
            this.startDocIn = SepPostingsReader.this.docIn;
            this.docReader = SepPostingsReader.this.docIn.reader();
            this.docIndex = SepPostingsReader.this.docIn.index();
            this.freqReader = SepPostingsReader.this.freqIn.reader();
            this.freqIndex = SepPostingsReader.this.freqIn.index();
            this.posReader = SepPostingsReader.this.posIn.reader();
            this.posIndex = SepPostingsReader.this.posIn.index();
            this.payloadIn = SepPostingsReader.this.payloadIn.clone();
        }

        SepDocsAndPositionsEnum init(FieldInfo fieldInfo, SepTermState termState, Bits liveDocs) throws IOException {
            this.liveDocs = liveDocs;
            this.storePayloads = fieldInfo.hasPayloads();
            this.docIndex.copyFrom(termState.docIndex);
            this.docIndex.seek(this.docReader);
            this.freqIndex.copyFrom(termState.freqIndex);
            this.freqIndex.seek(this.freqReader);
            this.posIndex.copyFrom(termState.posIndex);
            this.posSeekPending = true;
            this.payloadPending = false;
            this.payloadFP = termState.payloadFP;
            this.skipFP = termState.skipFP;
            this.docFreq = termState.docFreq;
            this.count = 0;
            this.doc = -1;
            this.accum = 0;
            this.pendingPosCount = 0;
            this.pendingPayloadBytes = 0L;
            this.skipped = false;
            return this;
        }

        @Override
        public int nextDoc() throws IOException {
            do {
                if (this.count == this.docFreq) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                ++this.count;
                this.accum += this.docReader.next();
                this.freq = this.freqReader.next();
                this.pendingPosCount += this.freq;
            } while (this.liveDocs != null && !this.liveDocs.get(this.accum));
            this.position = 0;
            this.doc = this.accum;
            return this.doc;
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target - SepPostingsReader.this.skipInterval >= this.doc && this.docFreq >= SepPostingsReader.this.skipMinimum) {
                int newCount;
                if (this.skipper == null) {
                    this.skipper = new SepSkipListReader(SepPostingsReader.this.skipIn.clone(), SepPostingsReader.this.freqIn, SepPostingsReader.this.docIn, SepPostingsReader.this.posIn, SepPostingsReader.this.maxSkipLevels, SepPostingsReader.this.skipInterval);
                }
                if (!this.skipped) {
                    this.skipper.init(this.skipFP, this.docIndex, this.freqIndex, this.posIndex, this.payloadFP, this.docFreq, this.storePayloads);
                    this.skipper.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
                    this.skipped = true;
                }
                if ((newCount = this.skipper.skipTo(target)) > this.count) {
                    this.skipper.getFreqIndex().seek(this.freqReader);
                    this.skipper.getDocIndex().seek(this.docReader);
                    this.posIndex.copyFrom(this.skipper.getPosIndex());
                    this.posSeekPending = true;
                    this.count = newCount;
                    this.doc = this.accum = this.skipper.getDoc();
                    this.payloadFP = this.skipper.getPayloadPointer();
                    this.pendingPosCount = 0;
                    this.pendingPayloadBytes = 0L;
                    this.payloadPending = false;
                    this.payloadLength = this.skipper.getPayloadLength();
                }
            }
            do {
                if (this.nextDoc() != Integer.MAX_VALUE) continue;
                return Integer.MAX_VALUE;
            } while (target > this.doc);
            return this.doc;
        }

        @Override
        public int nextPosition() throws IOException {
            int code;
            if (this.posSeekPending) {
                this.posIndex.seek(this.posReader);
                this.payloadIn.seek(this.payloadFP);
                this.posSeekPending = false;
            }
            while (this.pendingPosCount > this.freq) {
                code = this.posReader.next();
                if (this.storePayloads && (code & 1) != 0) {
                    this.payloadLength = this.posReader.next();
                    assert (this.payloadLength >= 0);
                }
                --this.pendingPosCount;
                this.position = 0;
                this.pendingPayloadBytes += (long)this.payloadLength;
            }
            code = this.posReader.next();
            if (this.storePayloads) {
                if ((code & 1) != 0) {
                    this.payloadLength = this.posReader.next();
                    assert (this.payloadLength >= 0);
                }
                this.position += code >>> 1;
                this.pendingPayloadBytes += (long)this.payloadLength;
                this.payloadPending = this.payloadLength > 0;
            } else {
                this.position += code;
            }
            --this.pendingPosCount;
            assert (this.pendingPosCount >= 0);
            return this.position;
        }

        @Override
        public int startOffset() {
            return -1;
        }

        @Override
        public int endOffset() {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            if (!this.payloadPending) {
                return null;
            }
            if (this.pendingPayloadBytes == 0L) {
                return this.payload.get();
            }
            assert (this.pendingPayloadBytes >= (long)this.payloadLength);
            if (this.pendingPayloadBytes > (long)this.payloadLength) {
                this.payloadIn.seek(this.payloadIn.getFilePointer() + (this.pendingPayloadBytes - (long)this.payloadLength));
            }
            if (this.payload == null) {
                this.payload = new BytesRefBuilder();
            }
            this.payload.grow(this.payloadLength);
            this.payloadIn.readBytes(this.payload.bytes(), 0, this.payloadLength);
            this.payload.setLength(this.payloadLength);
            this.pendingPayloadBytes = 0L;
            return this.payload.get();
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    class SepDocsEnum
    extends DocsEnum {
        int docFreq;
        int doc = -1;
        int accum;
        int count;
        int freq;
        long freqStart;
        private boolean omitTF;
        private FieldInfo.IndexOptions indexOptions;
        private boolean storePayloads;
        private Bits liveDocs;
        private final IntIndexInput.Reader docReader;
        private final IntIndexInput.Reader freqReader;
        private long skipFP;
        private final IntIndexInput.Index docIndex;
        private final IntIndexInput.Index freqIndex;
        private final IntIndexInput.Index posIndex;
        private final IntIndexInput startDocIn;
        boolean skipped;
        SepSkipListReader skipper;

        SepDocsEnum() throws IOException {
            this.startDocIn = SepPostingsReader.this.docIn;
            this.docReader = SepPostingsReader.this.docIn.reader();
            this.docIndex = SepPostingsReader.this.docIn.index();
            if (SepPostingsReader.this.freqIn != null) {
                this.freqReader = SepPostingsReader.this.freqIn.reader();
                this.freqIndex = SepPostingsReader.this.freqIn.index();
            } else {
                this.freqReader = null;
                this.freqIndex = null;
            }
            this.posIndex = SepPostingsReader.this.posIn != null ? SepPostingsReader.this.posIn.index() : null;
        }

        SepDocsEnum init(FieldInfo fieldInfo, SepTermState termState, Bits liveDocs) throws IOException {
            this.liveDocs = liveDocs;
            this.indexOptions = fieldInfo.getIndexOptions();
            this.omitTF = this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY;
            this.storePayloads = fieldInfo.hasPayloads();
            this.docIndex.copyFrom(termState.docIndex);
            this.docIndex.seek(this.docReader);
            if (!this.omitTF) {
                this.freqIndex.copyFrom(termState.freqIndex);
                this.freqIndex.seek(this.freqReader);
            }
            this.docFreq = termState.docFreq;
            this.skipFP = termState.skipFP;
            this.count = 0;
            this.doc = -1;
            this.accum = 0;
            this.freq = 1;
            this.skipped = false;
            return this;
        }

        @Override
        public int nextDoc() throws IOException {
            do {
                if (this.count == this.docFreq) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                ++this.count;
                this.accum += this.docReader.next();
                if (this.omitTF) continue;
                this.freq = this.freqReader.next();
            } while (this.liveDocs != null && !this.liveDocs.get(this.accum));
            this.doc = this.accum;
            return this.doc;
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            if (target - SepPostingsReader.this.skipInterval >= this.doc && this.docFreq >= SepPostingsReader.this.skipMinimum) {
                int newCount;
                if (this.skipper == null) {
                    this.skipper = new SepSkipListReader(SepPostingsReader.this.skipIn.clone(), SepPostingsReader.this.freqIn, SepPostingsReader.this.docIn, SepPostingsReader.this.posIn, SepPostingsReader.this.maxSkipLevels, SepPostingsReader.this.skipInterval);
                }
                if (!this.skipped) {
                    this.skipper.init(this.skipFP, this.docIndex, this.freqIndex, this.posIndex, 0L, this.docFreq, this.storePayloads);
                    this.skipper.setIndexOptions(this.indexOptions);
                    this.skipped = true;
                }
                if ((newCount = this.skipper.skipTo(target)) > this.count) {
                    if (!this.omitTF) {
                        this.skipper.getFreqIndex().seek(this.freqReader);
                    }
                    this.skipper.getDocIndex().seek(this.docReader);
                    this.count = newCount;
                    this.doc = this.accum = this.skipper.getDoc();
                }
            }
            do {
                if (this.nextDoc() != Integer.MAX_VALUE) continue;
                return Integer.MAX_VALUE;
            } while (target > this.doc);
            return this.doc;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    private static final class SepTermState
    extends BlockTermState {
        IntIndexInput.Index docIndex;
        IntIndexInput.Index posIndex;
        IntIndexInput.Index freqIndex;
        long payloadFP;
        long skipFP;

        private SepTermState() {
        }

        @Override
        public SepTermState clone() {
            SepTermState other = new SepTermState();
            other.copyFrom(this);
            return other;
        }

        @Override
        public void copyFrom(TermState _other) {
            super.copyFrom(_other);
            SepTermState other = (SepTermState)_other;
            if (this.docIndex == null) {
                this.docIndex = other.docIndex.clone();
            } else {
                this.docIndex.copyFrom(other.docIndex);
            }
            if (other.freqIndex != null) {
                if (this.freqIndex == null) {
                    this.freqIndex = other.freqIndex.clone();
                } else {
                    this.freqIndex.copyFrom(other.freqIndex);
                }
            } else {
                this.freqIndex = null;
            }
            if (other.posIndex != null) {
                if (this.posIndex == null) {
                    this.posIndex = other.posIndex.clone();
                } else {
                    this.posIndex.copyFrom(other.posIndex);
                }
            } else {
                this.posIndex = null;
            }
            this.payloadFP = other.payloadFP;
            this.skipFP = other.skipFP;
        }

        @Override
        public String toString() {
            return super.toString() + " docIndex=" + this.docIndex + " freqIndex=" + this.freqIndex + " posIndex=" + this.posIndex + " payloadFP=" + this.payloadFP + " skipFP=" + this.skipFP;
        }
    }
}

