/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectorySnapshottable;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeDirectoryWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

public class INodesInPath {
    public static final Log LOG = LogFactory.getLog(INodesInPath.class);
    private final byte[][] path;
    private INode[] inodes;
    private int numNonNull;
    private int capacity;
    private boolean isSnapshot;
    private int snapshotRootIndex;
    private Snapshot snapshot = null;

    private static boolean isDotSnapshotDir(byte[] pathComponent) {
        return pathComponent == null ? false : Arrays.equals(HdfsConstants.DOT_SNAPSHOT_DIR_BYTES, pathComponent);
    }

    private static String constructPath(byte[][] components, int start, int end) {
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < end; ++i) {
            buf.append(DFSUtil.bytes2String(components[i]));
            if (i >= end - 1) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    static INodesInPath resolve(INodeDirectory startingDir, byte[][] components) throws UnresolvedLinkException {
        return INodesInPath.resolve(startingDir, components, components.length, false);
    }

    static INodesInPath resolve(INodeDirectory startingDir, byte[][] components, int numOfINodes, boolean resolveLink) throws UnresolvedLinkException {
        Preconditions.checkArgument(startingDir.compareTo(components[0]) == 0);
        INode curNode = startingDir;
        INodesInPath existing = new INodesInPath(components, numOfINodes);
        int count = 0;
        int index = numOfINodes - components.length;
        if (index > 0) {
            index = 0;
        }
        while (count < components.length && curNode != null) {
            INodeDirectory dir;
            boolean lastComp;
            boolean bl = lastComp = count == components.length - 1;
            if (index >= 0) {
                existing.addNode(curNode);
            }
            boolean isRef = curNode.isReference();
            boolean isDir = curNode.isDirectory();
            INodeDirectory iNodeDirectory = dir = isDir ? curNode.asDirectory() : null;
            if (!isRef && isDir && dir instanceof INodeDirectoryWithSnapshot) {
                if (!existing.isSnapshot()) {
                    existing.updateLatestSnapshot(((INodeDirectoryWithSnapshot)dir).getLastSnapshot());
                }
            } else if (isRef && isDir && !lastComp && !existing.isSnapshot()) {
                int dstSnapshotId = curNode.asReference().getDstSnapshotId();
                Snapshot latest = existing.getLatestSnapshot();
                if (latest == null || dstSnapshotId >= latest.getId()) {
                    Snapshot lastSnapshot = null;
                    if (curNode.isDirectory() && curNode.asDirectory() instanceof INodeDirectoryWithSnapshot) {
                        lastSnapshot = ((INodeDirectoryWithSnapshot)curNode.asDirectory()).getLastSnapshot();
                    }
                    existing.setSnapshot(lastSnapshot);
                }
            }
            if (curNode.isSymlink() && (!lastComp || lastComp && resolveLink)) {
                String path = INodesInPath.constructPath(components, 0, components.length);
                String preceding = INodesInPath.constructPath(components, 0, count);
                String remainder = INodesInPath.constructPath(components, count + 1, components.length);
                String link = DFSUtil.bytes2String(components[count]);
                String target = curNode.asSymlink().getSymlinkString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("UnresolvedPathException  path: " + path + " preceding: " + preceding + " count: " + count + " link: " + link + " target: " + target + " remainder: " + remainder);
                }
                throw new UnresolvedPathException(path, preceding, remainder, target);
            }
            if (lastComp || !isDir) break;
            byte[] childName = components[count + 1];
            if (INodesInPath.isDotSnapshotDir(childName) && isDir && dir instanceof INodeDirectorySnapshottable) {
                ++count;
                existing.isSnapshot = true;
                if (++index >= 0) {
                    --existing.capacity;
                }
                if (count == components.length - 1) break;
                Snapshot s = ((INodeDirectorySnapshottable)dir).getSnapshot(components[count + 1]);
                if (s == null) {
                    curNode = null;
                } else {
                    curNode = s.getRoot();
                    existing.setSnapshot(s);
                }
                if (index >= -1) {
                    existing.snapshotRootIndex = existing.numNonNull;
                }
            } else {
                curNode = dir.getChild(childName, existing.getPathSnapshot());
            }
            ++count;
            ++index;
        }
        return existing;
    }

    private INodesInPath(byte[][] path, int number) {
        this.path = path;
        assert (number >= 0);
        this.inodes = new INode[number];
        this.capacity = number;
        this.numNonNull = 0;
        this.isSnapshot = false;
        this.snapshotRootIndex = -1;
    }

    public Snapshot getLatestSnapshot() {
        return this.isSnapshot ? null : this.snapshot;
    }

    public Snapshot getPathSnapshot() {
        return this.isSnapshot ? this.snapshot : null;
    }

    private void setSnapshot(Snapshot s) {
        this.snapshot = s;
    }

    private void updateLatestSnapshot(Snapshot s) {
        if (this.snapshot == null || s != null && Snapshot.ID_COMPARATOR.compare(this.snapshot, s) < 0) {
            this.snapshot = s;
        }
    }

    INode[] getINodes() {
        if (this.capacity < this.inodes.length) {
            INode[] newNodes = new INode[this.capacity];
            System.arraycopy(this.inodes, 0, newNodes, 0, this.capacity);
            this.inodes = newNodes;
        }
        return this.inodes;
    }

    public INode getINode(int i) {
        return this.inodes[i >= 0 ? i : this.inodes.length + i];
    }

    public INode getLastINode() {
        return this.inodes[this.inodes.length - 1];
    }

    byte[] getLastLocalName() {
        return this.path[this.path.length - 1];
    }

    int getSnapshotRootIndex() {
        return this.snapshotRootIndex;
    }

    boolean isSnapshot() {
        return this.isSnapshot;
    }

    private void addNode(INode node) {
        this.inodes[this.numNonNull++] = node;
    }

    void setINode(int i, INode inode) {
        this.inodes[i >= 0 ? i : this.inodes.length + i] = inode;
    }

    void setLastINode(INode last) {
        this.inodes[this.inodes.length - 1] = last;
    }

    int getNumNonNull() {
        return this.numNonNull;
    }

    private static String toString(INode inode) {
        return inode == null ? null : inode.getLocalName();
    }

    public String toString() {
        return this.toString(true);
    }

    private String toString(boolean vaildateObject) {
        if (vaildateObject) {
            this.vaildate();
        }
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append(": path = ").append(DFSUtil.byteArray2PathString(this.path)).append("\n  inodes = ");
        if (this.inodes == null) {
            b.append("null");
        } else if (this.inodes.length == 0) {
            b.append("[]");
        } else {
            b.append("[").append(INodesInPath.toString(this.inodes[0]));
            for (int i = 1; i < this.inodes.length; ++i) {
                b.append(", ").append(INodesInPath.toString(this.inodes[i]));
            }
            b.append("], length=").append(this.inodes.length);
        }
        b.append("\n  numNonNull = ").append(this.numNonNull).append("\n  capacity   = ").append(this.capacity).append("\n  isSnapshot        = ").append(this.isSnapshot).append("\n  snapshotRootIndex = ").append(this.snapshotRootIndex).append("\n  snapshot          = ").append(this.snapshot);
        return b.toString();
    }

    void vaildate() {
        int n = this.snapshotRootIndex >= 0 ? this.snapshotRootIndex + 1 : this.numNonNull;
        int i = 0;
        if (this.inodes[i] != null) {
            ++i;
            while (i < n && this.inodes[i] != null) {
                INodeDirectory parent_i = this.inodes[i].getParent();
                INodeDirectory parent_i_1 = this.inodes[i - 1].getParent();
                if (!(parent_i == this.inodes[i - 1] || parent_i_1 != null && parent_i_1.isSnapshottable() && parent_i == parent_i_1)) {
                    throw new AssertionError((Object)("inodes[" + i + "].getParent() != inodes[" + (i - 1) + "]\n  inodes[" + i + "]=" + this.inodes[i].toDetailString() + "\n  inodes[" + (i - 1) + "]=" + this.inodes[i - 1].toDetailString() + "\n this=" + this.toString(false)));
                }
                ++i;
            }
        }
        if (i != n) {
            throw new AssertionError((Object)("i = " + i + " != " + n + ", this=" + this.toString(false)));
        }
    }
}

