/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterInt;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.source.JvmMetricsSource;

public class DataNodeInstrumentation
implements MetricsSource {
    final MetricsRegistry registry = new MetricsRegistry("datanode");
    final MetricMutableCounterLong bytesWritten = this.registry.newCounter("bytes_written", "", 0L);
    final MetricMutableCounterLong bytesRead = this.registry.newCounter("bytes_read", "", 0L);
    final MetricMutableCounterInt blocksWritten = this.registry.newCounter("blocks_written", "", 0);
    final MetricMutableCounterInt blocksRead = this.registry.newCounter("blocks_read", "", 0);
    final MetricMutableCounterInt blocksReplicated = this.registry.newCounter("blocks_replicated", "", 0);
    final MetricMutableCounterInt blocksRemoved = this.registry.newCounter("blocks_removed", "", 0);
    final MetricMutableCounterInt blocksVerified = this.registry.newCounter("blocks_verified", "", 0);
    final MetricMutableCounterInt blockVerificationFailures = this.registry.newCounter("block_verification_failures", "", 0);
    final MetricMutableCounterInt blocksGetLocalPathInfo = this.registry.newCounter("blocks_get_local_pathinfo", "", 0);
    final MetricMutableCounterInt readsFromLocalClient = this.registry.newCounter("reads_from_local_client", "", 0);
    final MetricMutableCounterInt readsFromRemoteClient = this.registry.newCounter("reads_from_remote_client", "", 0);
    final MetricMutableCounterInt writesFromLocalClient = this.registry.newCounter("writes_from_local_client", "", 0);
    final MetricMutableCounterInt writesFromRemoteClient = this.registry.newCounter("writes_from_remote_client", "", 0);
    final MetricMutableStat readBlockOp = this.registry.newStat("readBlockOp");
    final MetricMutableStat writeBlockOp = this.registry.newStat("writeBlockOp");
    final MetricMutableStat blockChecksumOp = this.registry.newStat("blockChecksumOp");
    final MetricMutableStat copyBlockOp = this.registry.newStat("copyBlockOp");
    final MetricMutableStat replaceBlockOp = this.registry.newStat("replaceBlockOp");
    final MetricMutableStat heartbeats = this.registry.newStat("heartBeats");
    final MetricMutableStat blockReports = this.registry.newStat("blockReports");

    public DataNodeInstrumentation(Configuration conf, String storageId) {
        String sessionId = conf.get("session.id");
        JvmMetricsSource.create("DataNode", sessionId);
        this.registry.setContext("dfs").tag("sessionId", "", sessionId);
    }

    public void shutdown() {
    }

    public void resetAllMinMax() {
        this.readBlockOp.resetMinMax();
        this.writeBlockOp.resetMinMax();
        this.blockChecksumOp.resetMinMax();
        this.copyBlockOp.resetMinMax();
        this.replaceBlockOp.resetMinMax();
        this.heartbeats.resetMinMax();
        this.blockReports.resetMinMax();
    }

    public void addHeartBeat(long latency) {
        this.heartbeats.add(latency);
    }

    public void addBlockReport(long latency) {
        this.blockReports.add(latency);
    }

    public void incrBlocksReplicated(int delta) {
        this.blocksReplicated.incr(delta);
    }

    public void incrBlocksWritten() {
        this.blocksWritten.incr();
    }

    public void incrBlocksRemoved(int delta) {
        this.blocksRemoved.incr(delta);
    }

    public void incrBytesWritten(int delta) {
        this.bytesWritten.incr(delta);
    }

    public void incrBlockVerificationFailures() {
        this.blockVerificationFailures.incr();
    }

    public void incrBlocksVerified() {
        this.blocksVerified.incr();
    }

    public void incrBlocksGetLocalPathInfo() {
        this.blocksGetLocalPathInfo.incr();
    }

    public void addReadBlockOp(long latency) {
        this.readBlockOp.add(latency);
    }

    public void incrReadsFromLocalClient() {
        this.readsFromLocalClient.incr();
    }

    public void incrReadsFromRemoteClient() {
        this.readsFromRemoteClient.incr();
    }

    public void addWriteBlockOp(long latency) {
        this.writeBlockOp.add(latency);
    }

    public void incrWritesFromLocalClient() {
        this.writesFromLocalClient.incr();
    }

    public void incrWritesFromRemoteClient() {
        this.writesFromRemoteClient.incr();
    }

    public void addReplaceBlockOp(long latency) {
        this.replaceBlockOp.add(latency);
    }

    public void addCopyBlockOp(long latency) {
        this.copyBlockOp.add(latency);
    }

    public void addBlockChecksumOp(long latency) {
        this.blockChecksumOp.add(latency);
    }

    public void incrBytesRead(int delta) {
        this.bytesRead.incr(delta);
    }

    public void incrBlocksRead() {
        this.blocksRead.incr();
    }

    public void getMetrics(MetricsBuilder builder, boolean all) {
        this.registry.snapshot(builder.addRecord(this.registry.name()), all);
    }

    public static DataNodeInstrumentation create(Configuration conf, String storageID) {
        return DataNodeInstrumentation.create(conf, storageID, (MetricsSystem)((Object)DefaultMetricsSystem.INSTANCE));
    }

    public static DataNodeInstrumentation create(Configuration conf, String storageID, MetricsSystem ms) {
        return ms.register("DataNode", "DataNode metrics", new DataNodeInstrumentation(conf, storageID));
    }
}

