/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.AsynchronousCloseException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.net.PeerServer;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiver;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Daemon;

class DataXceiverServer
implements Runnable {
    public static final Log LOG = DataNode.LOG;
    private final PeerServer peerServer;
    private final DataNode datanode;
    private final Set<Peer> peers = new HashSet<Peer>();
    int maxXceiverCount = 4096;
    BlockBalanceThrottler balanceThrottler;
    long estimateBlockSize;

    DataXceiverServer(PeerServer peerServer, Configuration conf, DataNode datanode) {
        this.peerServer = peerServer;
        this.datanode = datanode;
        this.maxXceiverCount = conf.getInt("dfs.datanode.max.transfer.threads", 4096);
        this.estimateBlockSize = conf.getLongBytes("dfs.blocksize", 0x8000000L);
        this.balanceThrottler = new BlockBalanceThrottler(conf.getLong("dfs.datanode.balance.bandwidthPerSec", 0x100000L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Peer peer = null;
        while (this.datanode.shouldRun) {
            try {
                peer = this.peerServer.accept();
                int curXceiverCount = this.datanode.getXceiverCount();
                if (curXceiverCount > this.maxXceiverCount) {
                    throw new IOException("Xceiver count " + curXceiverCount + " exceeds the limit of concurrent xcievers: " + this.maxXceiverCount);
                }
                new Daemon(this.datanode.threadGroup, DataXceiver.create(peer, this.datanode, this)).start();
            }
            catch (SocketTimeoutException ignored) {
            }
            catch (AsynchronousCloseException ace) {
                if (!this.datanode.shouldRun) continue;
                LOG.warn(this.datanode.getDisplayName() + ":DataXceiverServer: ", ace);
            }
            catch (IOException ie) {
                IOUtils.cleanup(null, peer);
                LOG.warn(this.datanode.getDisplayName() + ":DataXceiverServer: ", ie);
            }
            catch (OutOfMemoryError ie) {
                IOUtils.cleanup(null, peer);
                LOG.warn("DataNode is out of memory. Will retry in 30 seconds.", ie);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                }
            }
            catch (Throwable te) {
                LOG.error(this.datanode.getDisplayName() + ":DataXceiverServer: Exiting due to: ", te);
                this.datanode.shouldRun = false;
            }
        }
        DataXceiverServer te = this;
        synchronized (te) {
            for (Peer p : this.peers) {
                IOUtils.cleanup(LOG, p);
            }
        }
        try {
            this.peerServer.close();
        }
        catch (IOException ie) {
            LOG.warn(this.datanode.getDisplayName() + " :DataXceiverServer: close exception", ie);
        }
    }

    void kill() {
        assert (!this.datanode.shouldRun) : "shoudRun should be set to false before killing";
        try {
            this.peerServer.close();
        }
        catch (IOException ie) {
            LOG.warn(this.datanode.getDisplayName() + ":DataXceiverServer.kill(): ", ie);
        }
    }

    synchronized void addPeer(Peer peer) {
        this.peers.add(peer);
    }

    synchronized void closePeer(Peer peer) {
        this.peers.remove(peer);
        IOUtils.cleanup(null, peer);
    }

    static class BlockBalanceThrottler
    extends DataTransferThrottler {
        private int numThreads;

        private BlockBalanceThrottler(long bandwidth) {
            super(bandwidth);
            LOG.info("Balancing bandwith is " + bandwidth + " bytes/s");
        }

        synchronized boolean acquire() {
            if (this.numThreads >= 5) {
                return false;
            }
            ++this.numThreads;
            return true;
        }

        synchronized void release() {
            --this.numThreads;
        }
    }
}

