/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public abstract class BlockPlacementPolicy {
    static final Log LOG = LogFactory.getLog(BlockPlacementPolicy.class);

    abstract DatanodeDescriptor[] chooseTarget(String var1, int var2, DatanodeDescriptor var3, List<DatanodeDescriptor> var4, long var5);

    public abstract DatanodeDescriptor[] chooseTarget(String var1, int var2, DatanodeDescriptor var3, List<DatanodeDescriptor> var4, boolean var5, HashMap<Node, Node> var6, long var7);

    DatanodeDescriptor[] chooseTarget(BlockCollection srcBC, int numOfReplicas, DatanodeDescriptor writer, List<DatanodeDescriptor> chosenNodes, HashMap<Node, Node> excludedNodes, long blocksize) {
        return this.chooseTarget(srcBC.getName(), numOfReplicas, writer, chosenNodes, false, excludedNodes, blocksize);
    }

    DatanodeDescriptor[] chooseTarget(String src, int numOfReplicas, DatanodeDescriptor writer, HashMap<Node, Node> excludedNodes, long blocksize, List<DatanodeDescriptor> favoredNodes) {
        return this.chooseTarget(src, numOfReplicas, writer, new ArrayList<DatanodeDescriptor>(numOfReplicas), false, excludedNodes, blocksize);
    }

    public abstract int verifyBlockPlacement(String var1, LocatedBlock var2, int var3);

    public abstract DatanodeDescriptor chooseReplicaToDelete(BlockCollection var1, Block var2, short var3, Collection<DatanodeDescriptor> var4, Collection<DatanodeDescriptor> var5);

    protected abstract void initialize(Configuration var1, FSClusterStats var2, NetworkTopology var3);

    public static BlockPlacementPolicy getInstance(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap) {
        Class<BlockPlacementPolicy> replicatorClass = conf.getClass("dfs.block.replicator.classname", BlockPlacementPolicyDefault.class, BlockPlacementPolicy.class);
        BlockPlacementPolicy replicator = ReflectionUtils.newInstance(replicatorClass, conf);
        replicator.initialize(conf, stats, clusterMap);
        return replicator;
    }

    public void adjustSetsWithChosenReplica(Map<String, List<DatanodeDescriptor>> rackMap, List<DatanodeDescriptor> moreThanOne, List<DatanodeDescriptor> exactlyOne, DatanodeInfo cur) {
        String rack = this.getRack(cur);
        List<DatanodeDescriptor> datanodes = rackMap.get(rack);
        datanodes.remove(cur);
        if (datanodes.isEmpty()) {
            rackMap.remove(rack);
        }
        if (moreThanOne.remove(cur)) {
            if (datanodes.size() == 1) {
                moreThanOne.remove(datanodes.get(0));
                exactlyOne.add(datanodes.get(0));
            }
        } else {
            exactlyOne.remove(cur);
        }
    }

    protected String getRack(DatanodeInfo datanode) {
        return datanode.getNetworkLocation();
    }

    public void splitNodesWithRack(Collection<DatanodeDescriptor> dataNodes, Map<String, List<DatanodeDescriptor>> rackMap, List<DatanodeDescriptor> moreThanOne, List<DatanodeDescriptor> exactlyOne) {
        for (DatanodeDescriptor datanodeDescriptor : dataNodes) {
            String rackName = this.getRack(datanodeDescriptor);
            List<DatanodeDescriptor> datanodeList = rackMap.get(rackName);
            if (datanodeList == null) {
                datanodeList = new ArrayList<DatanodeDescriptor>();
                rackMap.put(rackName, datanodeList);
            }
            datanodeList.add(datanodeDescriptor);
        }
        for (List list : rackMap.values()) {
            if (list.size() == 1) {
                exactlyOne.add((DatanodeDescriptor)list.get(0));
                continue;
            }
            moreThanOne.addAll(list);
        }
    }

    @InterfaceAudience.Private
    public static class NotEnoughReplicasException
    extends Exception {
        private static final long serialVersionUID = 1L;

        NotEnoughReplicasException(String msg) {
            super(msg);
        }
    }
}

