/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.shell.Command;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class FsShell
extends Configured
implements Tool {
    static final Log LOG = LogFactory.getLog(FsShell.class);
    private FileSystem fs;
    private Trash trash;
    protected CommandFactory commandFactory;
    private final String usagePrefix = "Usage: hadoop fs [generic options]";

    public FsShell() {
        this(null);
    }

    public FsShell(Configuration conf) {
        super(conf);
    }

    protected FileSystem getFS() throws IOException {
        if (this.fs == null) {
            this.fs = FileSystem.get(this.getConf());
        }
        return this.fs;
    }

    protected Trash getTrash() throws IOException {
        if (this.trash == null) {
            this.trash = new Trash(this.getConf());
        }
        return this.trash;
    }

    protected void init() throws IOException {
        this.getConf().setQuietMode(true);
        if (this.commandFactory == null) {
            this.commandFactory = new CommandFactory(this.getConf());
            this.commandFactory.addObject(new Help(), "-help");
            this.commandFactory.addObject(new Usage(), "-usage");
            this.registerCommands(this.commandFactory);
        }
    }

    protected void registerCommands(CommandFactory factory) {
        if (this.getClass().equals(FsShell.class)) {
            factory.registerCommands(FsCommand.class);
        }
    }

    public Path getCurrentTrashDir() throws IOException {
        return this.getTrash().getCurrentTrashDir();
    }

    private void printUsage(PrintStream out) {
        this.printInfo(out, null, false);
    }

    private void printUsage(PrintStream out, String cmd) {
        this.printInfo(out, cmd, false);
    }

    private void printHelp(PrintStream out) {
        this.printInfo(out, null, true);
    }

    private void printHelp(PrintStream out, String cmd) {
        this.printInfo(out, cmd, true);
    }

    private void printInfo(PrintStream out, String cmd, boolean showHelp) {
        if (cmd != null) {
            Command instance = this.commandFactory.getInstance("-" + cmd);
            if (instance == null) {
                throw new UnknownCommandException(cmd);
            }
            if (showHelp) {
                this.printInstanceHelp(out, instance);
            } else {
                this.printInstanceUsage(out, instance);
            }
        } else {
            out.println("Usage: hadoop fs [generic options]");
            ArrayList<Command> instances = new ArrayList<Command>();
            for (String name : this.commandFactory.getNames()) {
                Command instance = this.commandFactory.getInstance(name);
                if (instance.isDeprecated()) continue;
                System.out.println("\t[" + instance.getUsage() + "]");
                instances.add(instance);
            }
            if (showHelp) {
                for (Command instance : instances) {
                    out.println();
                    this.printInstanceHelp(out, instance);
                }
            }
            out.println();
            ToolRunner.printGenericCommandUsage(out);
        }
    }

    private void printInstanceUsage(PrintStream out, Command instance) {
        out.println("Usage: hadoop fs [generic options] " + instance.getUsage());
    }

    private void printInstanceHelp(PrintStream out, Command instance) {
        boolean firstLine = true;
        for (String line : instance.getDescription().split("\n")) {
            String prefix;
            if (firstLine) {
                prefix = instance.getUsage() + ":\t";
                firstLine = false;
            } else {
                prefix = "\t\t";
            }
            System.out.println(prefix + line);
        }
    }

    @Override
    public int run(String[] argv) throws Exception {
        this.init();
        int exitCode = -1;
        if (argv.length < 1) {
            this.printUsage(System.err);
        } else {
            String cmd = argv[0];
            Command instance = null;
            try {
                instance = this.commandFactory.getInstance(cmd);
                if (instance == null) {
                    throw new UnknownCommandException();
                }
                exitCode = instance.run(Arrays.copyOfRange(argv, 1, argv.length));
            }
            catch (IllegalArgumentException e) {
                this.displayError(cmd, e.getLocalizedMessage());
                if (instance != null) {
                    this.printInstanceUsage(System.err, instance);
                }
            }
            catch (Exception e) {
                LOG.debug("Error", e);
                this.displayError(cmd, "Fatal internal error");
                e.printStackTrace(System.err);
            }
        }
        return exitCode;
    }

    private void displayError(String cmd, String message) {
        for (String line : message.split("\n")) {
            System.err.println(cmd + ": " + line);
            if (cmd.charAt(0) == '-') continue;
            Command instance = null;
            instance = this.commandFactory.getInstance("-" + cmd);
            if (instance == null) continue;
            System.err.println("Did you mean -" + cmd + "?  This command " + "begins with a dash.");
        }
    }

    public void close() throws IOException {
        if (this.fs != null) {
            this.fs.close();
            this.fs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        int res;
        FsShell shell = FsShell.newShellInstance();
        try {
            res = ToolRunner.run(shell, argv);
        }
        finally {
            shell.close();
        }
        System.exit(res);
    }

    protected static FsShell newShellInstance() {
        return new FsShell();
    }

    static class UnknownCommandException
    extends IllegalArgumentException {
        private final String cmd;

        UnknownCommandException() {
            this((String)null);
        }

        UnknownCommandException(String cmd) {
            this.cmd = cmd;
        }

        @Override
        public String getMessage() {
            return (this.cmd != null ? "`" + this.cmd + "': " : "") + "Unknown command";
        }
    }

    protected class Help
    extends FsCommand {
        public static final String NAME = "help";
        public static final String USAGE = "[cmd ...]";
        public static final String DESCRIPTION = "Displays help for given command or all commands if none\nis specified.";

        protected Help() {
        }

        @Override
        protected void processRawArguments(LinkedList<String> args) {
            if (args.isEmpty()) {
                FsShell.this.printHelp(System.out);
            } else {
                for (String arg : args) {
                    FsShell.this.printHelp(System.out, arg);
                }
            }
        }
    }

    protected class Usage
    extends FsCommand {
        public static final String NAME = "usage";
        public static final String USAGE = "[cmd ...]";
        public static final String DESCRIPTION = "Displays the usage for given command or all commands if none\nis specified.";

        protected Usage() {
        }

        @Override
        protected void processRawArguments(LinkedList<String> args) {
            if (args.isEmpty()) {
                FsShell.this.printUsage(System.out);
            } else {
                for (String arg : args) {
                    FsShell.this.printUsage(System.out, arg);
                }
            }
        }
    }
}

