/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import org.geolatte.geom.LineString;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.db.sqlserver.AbstractSqlServerDecoder;
import org.geolatte.geom.codec.db.sqlserver.IndexRange;
import org.geolatte.geom.codec.db.sqlserver.OpenGisType;
import org.geolatte.geom.codec.db.sqlserver.SqlServerGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

class LineStringSqlServerDecoder
extends AbstractSqlServerDecoder {
    LineStringSqlServerDecoder() {
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.LINESTRING;
    }

    protected LineString<?> createNullGeometry(CoordinateReferenceSystem<?> crs) {
        return new LineString(crs);
    }

    protected LineString<?> createGeometry(SqlServerGeometry nativeGeom) {
        return this.createLineString(nativeGeom, new IndexRange(0, nativeGeom.getNumPoints()));
    }

    protected LineString<?> createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        if (nativeGeom.isEmptyShape(shapeIndex)) {
            return this.createNullGeometry((CoordinateReferenceSystem)nativeGeom.getCoordinateReferenceSystem());
        }
        int figureOffset = nativeGeom.getFiguresForShape((int)shapeIndex).start;
        IndexRange pntIndexRange = nativeGeom.getPointsForFigure(figureOffset);
        return this.createLineString(nativeGeom, pntIndexRange);
    }

    protected LineString<?> createLineString(SqlServerGeometry nativeGeom, IndexRange pntIndexRange) {
        PositionSequence<?> coordinates = nativeGeom.coordinateRange(pntIndexRange);
        CoordinateReferenceSystem<?> coordinateReferenceSystem = nativeGeom.getCoordinateReferenceSystem();
        return new LineString(coordinates, coordinateReferenceSystem);
    }
}

