/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.Point;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class MultiPointSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == TypeGeometry.MULTIPOINT;
    }

    @Override
    Geometry<?> internalDecode(SDOGeometry sdoGeom) {
        CoordinateReferenceSystem<?> crs = this.getCoordinateReferenceSystem(sdoGeom);
        Double[] ordinates = sdoGeom.getOrdinates().getOrdinateArray();
        PositionSequence<?> positions = this.convertOrdinateArray(ordinates, sdoGeom, crs);
        Point[] pnts = new Point[positions.size()];
        int i = 0;
        for (Position p : positions) {
            pnts[i++] = new Point<Position>(p, crs);
        }
        return new MultiPoint(pnts);
    }
}

