/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ldap;

import javax.naming.directory.InitialDirContext;
import org.flowable.ldap.LDAPCallBack;
import org.flowable.ldap.LDAPConfiguration;
import org.flowable.ldap.LDAPConnectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(LDAPTemplate.class);
    protected LDAPConfiguration ldapConfigurator;

    public LDAPTemplate(LDAPConfiguration ldapConfigurator) {
        this.ldapConfigurator = ldapConfigurator;
    }

    public <T> T execute(LDAPCallBack<T> ldapCallBack) {
        InitialDirContext initialDirContext = null;
        try {
            initialDirContext = LDAPConnectionUtil.creatDirectoryContext(this.ldapConfigurator);
        }
        catch (Exception e) {
            LOGGER.info("Could not create LDAP connection : {}", (Object)e.getMessage(), (Object)e);
        }
        T result = ldapCallBack.executeInContext(initialDirContext);
        LDAPConnectionUtil.closeDirectoryContext(initialDirContext);
        return result;
    }

    public LDAPConfiguration getLdapConfigurator() {
        return this.ldapConfigurator;
    }

    public void setLdapConfigurator(LDAPConfiguration ldapConfigurator) {
        this.ldapConfigurator = ldapConfigurator;
    }
}

