/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.spring;

import java.net.URL;
import java.util.Map;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.idm.engine.IdmEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringIdmConfigurationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringIdmConfigurationHelper.class);

    public static IdmEngine buildIdmEngine(URL resource) {
        LOGGER.debug("==== BUILDING SPRING APPLICATION CONTEXT AND IDM ENGINE =========================================");
        GenericXmlApplicationContext applicationContext = new GenericXmlApplicationContext(new Resource[]{new UrlResource(resource)});
        Map beansOfType = applicationContext.getBeansOfType(IdmEngine.class);
        if (beansOfType == null || beansOfType.isEmpty()) {
            throw new FlowableException("no " + IdmEngine.class.getName() + " defined in the application context " + resource.toString());
        }
        IdmEngine idmEngine = (IdmEngine)beansOfType.values().iterator().next();
        LOGGER.debug("==== SPRING IDM ENGINE CREATED ==================================================================");
        return idmEngine;
    }
}

