/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.identitylink.service.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;
import org.flowable.identitylink.service.IdentityLinkServiceConfiguration;
import org.flowable.identitylink.service.event.impl.FlowableIdentityLinkEventBuilder;
import org.flowable.identitylink.service.impl.persistence.entity.AbstractEntityManager;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntityManager;
import org.flowable.identitylink.service.impl.persistence.entity.data.IdentityLinkDataManager;

public class IdentityLinkEntityManagerImpl
extends AbstractEntityManager<IdentityLinkEntity>
implements IdentityLinkEntityManager {
    protected IdentityLinkDataManager identityLinkDataManager;

    public IdentityLinkEntityManagerImpl(IdentityLinkServiceConfiguration identityLinkServiceConfiguration, IdentityLinkDataManager identityLinkDataManager) {
        super(identityLinkServiceConfiguration);
        this.identityLinkDataManager = identityLinkDataManager;
    }

    @Override
    protected DataManager<IdentityLinkEntity> getDataManager() {
        return this.identityLinkDataManager;
    }

    @Override
    public void deleteIdentityLink(IdentityLinkEntity identityLink) {
        this.delete(identityLink, false);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableIdentityLinkEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, identityLink));
        }
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByTaskId(String taskId) {
        return this.identityLinkDataManager.findIdentityLinksByTaskId(taskId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessInstanceId(String processInstanceId) {
        return this.identityLinkDataManager.findIdentityLinksByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessDefinitionId(String processDefinitionId) {
        return this.identityLinkDataManager.findIdentityLinksByProcessDefinitionId(processDefinitionId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByTaskUserGroupAndType(String taskId, String userId, String groupId, String type) {
        return this.identityLinkDataManager.findIdentityLinkByTaskUserGroupAndType(taskId, userId, groupId, type);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessInstanceUserGroupAndType(String processInstanceId, String userId, String groupId, String type) {
        return this.identityLinkDataManager.findIdentityLinkByProcessInstanceUserGroupAndType(processInstanceId, userId, groupId, type);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessDefinitionUserAndGroup(String processDefinitionId, String userId, String groupId) {
        return this.identityLinkDataManager.findIdentityLinkByProcessDefinitionUserAndGroup(processDefinitionId, userId, groupId);
    }

    @Override
    public IdentityLinkEntity addProcessInstanceIdentityLink(String processInstanceId, String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)this.identityLinkDataManager.create();
        identityLinkEntity.setProcessInstanceId(processInstanceId);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addTaskIdentityLink(String taskId, String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)this.identityLinkDataManager.create();
        identityLinkEntity.setTaskId(taskId);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addProcessDefinitionIdentityLink(String processDefinitionId, String userId, String groupId) {
        IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)this.identityLinkDataManager.create();
        identityLinkEntity.setProcessDefId(processDefinitionId);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType("candidate");
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addCandidateUser(String taskId, String userId) {
        return this.addTaskIdentityLink(taskId, userId, null, "candidate");
    }

    @Override
    public List<IdentityLinkEntity> addCandidateUsers(String taskId, Collection<String> candidateUsers) {
        ArrayList<IdentityLinkEntity> identityLinks = new ArrayList<IdentityLinkEntity>();
        for (String candidateUser : candidateUsers) {
            identityLinks.add(this.addCandidateUser(taskId, candidateUser));
        }
        return identityLinks;
    }

    @Override
    public IdentityLinkEntity addCandidateGroup(String taskId, String groupId) {
        return this.addTaskIdentityLink(taskId, null, groupId, "candidate");
    }

    @Override
    public List<IdentityLinkEntity> addCandidateGroups(String taskId, Collection<String> candidateGroups) {
        ArrayList<IdentityLinkEntity> identityLinks = new ArrayList<IdentityLinkEntity>();
        for (String candidateGroup : candidateGroups) {
            identityLinks.add(this.addCandidateGroup(taskId, candidateGroup));
        }
        return identityLinks;
    }

    @Override
    public List<IdentityLinkEntity> deleteProcessInstanceIdentityLink(String processInstanceId, String userId, String groupId, String type) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByProcessInstanceUserGroupAndType(processInstanceId, userId, groupId, type);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink);
        }
        return identityLinks;
    }

    @Override
    public List<IdentityLinkEntity> deleteTaskIdentityLink(String taskId, List<IdentityLinkEntity> currentIdentityLinks, String userId, String groupId, String type) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByTaskUserGroupAndType(taskId, userId, groupId, type);
        ArrayList<IdentityLinkEntity> removedIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
        ArrayList<String> identityLinkIds = new ArrayList<String>();
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink);
            identityLinkIds.add(identityLink.getId());
            removedIdentityLinkEntities.add(identityLink);
        }
        if (currentIdentityLinks != null) {
            for (IdentityLinkEntity identityLinkEntity : currentIdentityLinks) {
                if (!"candidate".equals(identityLinkEntity.getType()) || identityLinkIds.contains(identityLinkEntity.getId()) || (userId == null || !userId.equals(identityLinkEntity.getUserId())) && (groupId == null || !groupId.equals(identityLinkEntity.getGroupId()))) continue;
                this.deleteIdentityLink(identityLinkEntity);
                removedIdentityLinkEntities.add(identityLinkEntity);
            }
        }
        return removedIdentityLinkEntities;
    }

    @Override
    public List<IdentityLinkEntity> deleteProcessDefinitionIdentityLink(String processDefinitionId, String userId, String groupId) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByProcessDefinitionUserAndGroup(processDefinitionId, userId, groupId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink);
        }
        return identityLinks;
    }

    @Override
    public List<IdentityLinkEntity> deleteIdentityLinksByTaskId(String taskId) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinksByTaskId(taskId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink);
        }
        return identityLinks;
    }

    @Override
    public void deleteIdentityLinksByProcDef(String processDefId) {
        this.identityLinkDataManager.deleteIdentityLinksByProcDef(processDefId);
    }

    public IdentityLinkDataManager getIdentityLinkDataManager() {
        return this.identityLinkDataManager;
    }

    public void setIdentityLinkDataManager(IdentityLinkDataManager identityLinkDataManager) {
        this.identityLinkDataManager = identityLinkDataManager;
    }
}

