/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jcache;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.ehcache.jcache.JCacheManager;

public class JCacheCachingProvider
implements CachingProvider {
    private static final URI URI_DEFAULT;
    private final Map<ClassLoader, ConcurrentMap<URI, JCacheManager>> cacheManagers = new WeakHashMap<ClassLoader, ConcurrentMap<URI, JCacheManager>>();

    public javax.cache.CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    public javax.cache.CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.cache.CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        JCacheManager cacheManager;
        URL configurationURL;
        uri = uri == null ? this.getDefaultURI() : uri;
        classLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        properties = new Properties(properties);
        try {
            configurationURL = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        Map<ClassLoader, ConcurrentMap<URI, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, JCacheManager> byURI = this.cacheManagers.get(classLoader);
            if (byURI == null) {
                byURI = new ConcurrentHashMap<URI, JCacheManager>();
                this.cacheManagers.put(classLoader, byURI);
            }
            if ((cacheManager = (JCacheManager)byURI.get(uri)) == null) {
                Configuration configuration = ConfigurationFactory.parseConfiguration((URL)configurationURL);
                if (configuration.getName() == null) {
                    configuration.setName(uri.toString() + "::" + classLoader.toString() + "::" + this.toString());
                }
                configuration.setClassLoader(classLoader);
                CacheManager ehcacheManager = new CacheManager(configuration);
                cacheManager = new JCacheManager(this, ehcacheManager, uri, properties);
                byURI.put(uri, cacheManager);
            }
        }
        return cacheManager;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public URI getDefaultURI() {
        return URI_DEFAULT;
    }

    public Properties getDefaultProperties() {
        throw new UnsupportedOperationException("Implement me!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClassLoader, ConcurrentMap<URI, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            for (Map.Entry<ClassLoader, ConcurrentMap<URI, JCacheManager>> entry : this.cacheManagers.entrySet()) {
                for (JCacheManager jCacheManager : entry.getValue().values()) {
                    jCacheManager.close();
                }
            }
            this.cacheManagers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader) {
        Map<ClassLoader, ConcurrentMap<URI, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, JCacheManager> map2 = this.cacheManagers.remove(classLoader);
            if (map2 != null) {
                for (JCacheManager cacheManager : map2.values()) {
                    cacheManager.shutdown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        Map<ClassLoader, ConcurrentMap<URI, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            JCacheManager jCacheManager;
            ConcurrentMap<URI, JCacheManager> map2 = this.cacheManagers.get(classLoader);
            if (map2 != null && (jCacheManager = (JCacheManager)map2.remove(uri)) != null) {
                jCacheManager.shutdown();
            }
        }
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return optionalFeature == OptionalFeature.STORE_BY_REFERENCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown(JCacheManager jCacheManager) {
        Map<ClassLoader, ConcurrentMap<URI, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, JCacheManager> map2 = this.cacheManagers.get(jCacheManager.getClassLoader());
            if (map2.remove(jCacheManager.getURI()) != null) {
                jCacheManager.shutdown();
            }
        }
    }

    static {
        URI uri;
        try {
            URL resource = JCacheCachingProvider.class.getResource("/ehcache.xml");
            if (resource == null) {
                resource = Ehcache.class.getResource("/ehcache-failsafe.xml");
            }
            uri = new URI(resource.toString());
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        URI_DEFAULT = uri;
    }
}

