/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field.decorator;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class DecoratorInvocationHandler<T>
implements InvocationHandler {
    private final T target;
    private T decorator;
    private boolean returnDecoratorResult = false;

    public DecoratorInvocationHandler(T target, T decorator) {
        this.target = target;
        this.decorator = decorator;
    }

    public void setDecorator(T decorator) {
        this.decorator = decorator;
    }

    public T getTarget() {
        return this.target;
    }

    public T getDecorator() {
        return this.decorator;
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object firstResult = null;
        try {
            firstResult = this.invokeFirst(method, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        Object secondResult = null;
        try {
            secondResult = this.invokeSecond(method, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return this.getResult(firstResult, secondResult);
    }

    protected abstract Object invokeFirst(Method var1, Object[] var2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    protected abstract Object invokeSecond(Method var1, Object[] var2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

    protected abstract Object getResult(Object var1, Object var2);

    public void setReturnDecoratorResult(boolean returnDecoratorResult) {
        this.returnDecoratorResult = returnDecoratorResult;
    }

    protected boolean shouldReturnDecoratorResult() {
        return this.returnDecoratorResult;
    }
}

